/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class ApplicationPreferences {
    private Properties properties;
    private int defaultDisplayMode;
    private double interactiveTol;
    private Renderer objectPreviewRenderer;
    private Renderer texturePreviewRenderer;
    private Renderer defaultRenderer;

    public ApplicationPreferences() {
        this.loadPreferences();
    }

    public void loadPreferences() {
        this.properties = new Properties();
        this.initDefaultPreferences();
        File f = new File(System.getProperty("user.home"), ".aoiprefs");
        if (!f.exists()) {
            Translate.setLocale(Locale.getDefault());
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            this.properties.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.parsePreferences();
    }

    public void savePreferences() {
        File f = new File(System.getProperty("user.home"), ".aoiprefs");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.properties.save(out, "Art of Illusion Preferences File");
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initDefaultPreferences() {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length > 0) {
            this.texturePreviewRenderer = this.defaultRenderer = renderers[renderers.length - 1];
            this.objectPreviewRenderer = this.defaultRenderer;
        }
        this.defaultDisplayMode = 2;
        this.interactiveTol = 0.05;
    }

    private void parsePreferences() {
        this.objectPreviewRenderer = this.getNamedRenderer(this.properties.getProperty("objectPreviewRenderer"));
        this.texturePreviewRenderer = this.getNamedRenderer(this.properties.getProperty("texturePreviewRenderer"));
        this.defaultRenderer = this.getNamedRenderer(this.properties.getProperty("defaultRenderer"));
        this.defaultDisplayMode = this.parseIntProperty("defaultDisplayMode", this.defaultDisplayMode);
        this.interactiveTol = this.parseDoubleProperty("interactiveSurfaceError", this.interactiveTol);
        Translate.setLocale(this.parseLocaleProperty("language"));
    }

    private int parseIntProperty(String name, int defaultVal) {
        try {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private double parseDoubleProperty(String name, double defaultVal) {
        try {
            return new Double(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private Locale parseLocaleProperty(String name) {
        try {
            String desc = this.properties.getProperty(name);
            String language = desc.substring(0, 2);
            String country = desc.substring(3);
            return new Locale(language, country);
        }
        catch (Exception ex) {
            return Locale.getDefault();
        }
    }

    private Renderer getNamedRenderer(String name) {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length == 0) {
            return null;
        }
        int i = 0;
        while (i < renderers.length) {
            if (renderers[i].getName().equals(name)) {
                return renderers[i];
            }
            ++i;
        }
        return renderers[renderers.length - 1];
    }

    public final Renderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public final void setDefaultRenderer(Renderer rend) {
        this.defaultRenderer = rend;
        ((Hashtable)this.properties).put("defaultRenderer", rend.getName());
    }

    public final Renderer getObjectPreviewRenderer() {
        return this.objectPreviewRenderer;
    }

    public final void setObjectPreviewRenderer(Renderer rend) {
        this.objectPreviewRenderer = rend;
        ((Hashtable)this.properties).put("objectPreviewRenderer", rend.getName());
    }

    public final Renderer getTexturePreviewRenderer() {
        return this.texturePreviewRenderer;
    }

    public final void setTexturePreviewRenderer(Renderer rend) {
        this.texturePreviewRenderer = rend;
        ((Hashtable)this.properties).put("texturePreviewRenderer", rend.getName());
    }

    public final int getDefaultDisplayMode() {
        return this.defaultDisplayMode;
    }

    public final void setDefaultDisplayMode(int mode) {
        this.defaultDisplayMode = mode;
        ((Hashtable)this.properties).put("defaultDisplayMode", Integer.toString(mode));
    }

    public final double getInteractiveSurfaceError() {
        return this.interactiveTol;
    }

    public final void setInteractiveSurfaceError(double tol) {
        boolean changed = this.interactiveTol != tol;
        this.interactiveTol = tol;
        ((Hashtable)this.properties).put("interactiveSurfaceError", Double.toString(tol));
        if (changed) {
            EditingWindow[] windows = ModellingApp.getWindows();
            int i = 0;
            while (i < windows.length) {
                Scene sc = windows[i].getScene();
                if (sc != null) {
                    int j = 0;
                    while (j < sc.getNumObjects()) {
                        ObjectInfo info = sc.getObject(j);
                        Vec3 size = info.getBounds().getSize();
                        info.object.setSize(size.x, size.y, size.z);
                        info.clearCachedMeshes();
                        ++j;
                    }
                    windows[i].updateImage();
                }
                ++i;
            }
        }
    }

    public final Locale getLocale() {
        return Translate.getLocale();
    }

    public final void setLocale(Locale locale) {
        Translate.setLocale(locale);
        ((Hashtable)this.properties).put("language", locale.getLanguage() + '_' + locale.getCountry());
    }
}

