/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.SceneViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class CreateCurveTool
extends EditingTool {
    Image icon;
    Image selectedIcon;
    static int counter = 1;
    Point lastPoint;
    Vector clickPoint;
    Vector smoothness;
    int smoothing;
    Curve theCurve;
    CoordinateSystem coords;
    public static final int HANDLE_SIZE = 3;

    public CreateCurveTool(EditingWindow fr, int smoothingMethod) {
        super(fr);
        if (smoothingMethod == 2) {
            this.icon = this.loadImage("interpCurve.gif");
            this.selectedIcon = this.loadImage("selected/interpCurve.gif");
        } else {
            this.icon = this.loadImage("approxCurve.gif");
            this.selectedIcon = this.loadImage("selected/approxCurve.gif");
        }
        this.smoothing = smoothingMethod;
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("createCurveTool.helpText"));
    }

    public void deactivate() {
        this.addToScene();
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Image getSelectedIcon() {
        return this.selectedIcon;
    }

    public boolean hilightSelection() {
        return this.clickPoint == null;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Scene theScene = ((LayoutWindow)this.theFrame).getScene();
        Camera cam = view.getCamera();
        if (this.clickPoint == null) {
            return;
        }
        g.setPaintMode();
        g.setColor(Color.black);
        if (this.theCurve != null) {
            Object3D.draw(g, cam, this.theCurve.getWireframeMesh(), this.theCurve.getBounds());
        }
        g.setColor(Color.red);
        int i = 0;
        while (i < this.clickPoint.size()) {
            Point p1 = (Point)this.clickPoint.elementAt(i);
            g.fillRect(p1.x - 1, p1.y - 1, 3, 3);
            ++i;
        }
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Graphics g = view.getGraphics();
        this.lastPoint = e.getPoint();
        if (this.clickPoint == null) {
            this.clickPoint = new Vector();
            this.smoothness = new Vector();
            ((SceneViewer)view).drawImage(g);
        } else {
            g.setXORMode(Color.white);
            Point p = (Point)this.clickPoint.lastElement();
            g.drawLine(p.x, p.y, this.lastPoint.x, this.lastPoint.y);
        }
        g.dispose();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Point dragPoint = e.getPoint();
        if (this.clickPoint.size() == 0) {
            return;
        }
        Graphics g = view.getGraphics();
        g.setXORMode(Color.white);
        Point p = (Point)this.clickPoint.lastElement();
        g.drawLine(p.x, p.y, this.lastPoint.x, this.lastPoint.y);
        g.drawLine(p.x, p.y, dragPoint.x, dragPoint.y);
        this.lastPoint = dragPoint;
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Graphics g = view.getGraphics();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (e.getClickCount() != 2) {
            this.clickPoint.addElement(dragPoint);
            this.smoothness.addElement(new Float(e.isShiftDown() ? 0.0f : 1.0f));
        }
        if (this.clickPoint.size() > 1) {
            Vec3[] vertex = new Vec3[this.clickPoint.size()];
            float[] s = new float[this.clickPoint.size()];
            Vec3 orig = new Vec3();
            int i = 0;
            while (i < vertex.length) {
                vertex[i] = cam.convertScreenToWorld((Point)this.clickPoint.elementAt(i), 20.0);
                s[i] = ((Float)this.smoothness.elementAt(i)).floatValue();
                orig = orig.plus(vertex[i]);
                ++i;
            }
            orig = orig.times(1.0 / (double)vertex.length);
            Vec3 ydir = cam.getViewToWorld().timesDirection(Vec3.vy());
            Vec3 zdir = cam.getViewToWorld().timesDirection(new Vec3(0.0, 0.0, -1.0));
            this.coords = new CoordinateSystem(orig, zdir, ydir);
            i = 0;
            while (i < vertex.length) {
                vertex[i] = this.coords.toLocal().times(vertex[i]);
                vertex[i].z = 0.0;
                ++i;
            }
            this.theCurve = new Curve(vertex, s, this.smoothing, false);
            if (e.getClickCount() == 2) {
                this.theCurve.setClosed(e.isControlDown());
                this.addToScene();
                g.dispose();
                return;
            }
            cam.setObjectTransform(this.coords.fromLocal());
        }
        view.drawImage(g);
        this.drawOverlay(g, view);
        g.dispose();
    }

    public void keyPressed(KeyEvent e, ViewerCanvas view) {
        if (e.getKeyCode() == 10) {
            this.theCurve.setClosed(e.isControlDown());
            this.addToScene();
        }
    }

    private void addToScene() {
        if (this.theCurve != null) {
            ObjectInfo info = new ObjectInfo(this.theCurve, this.coords, "Curve " + counter++);
            info.addTrack(new PositionTrack(info), 0);
            info.addTrack(new RotationTrack(info), 1);
            UndoRecord undo = new UndoRecord(this.theWindow, false);
            ((LayoutWindow)this.theFrame).addObject(info, undo);
            this.theWindow.setUndoRecord(undo);
            ((LayoutWindow)this.theFrame).setSelection(((LayoutWindow)this.theFrame).getScene().getNumObjects() - 1);
        }
        this.clickPoint = null;
        this.smoothness = null;
        this.theCurve = null;
        this.coords = null;
        this.theWindow.updateImage();
    }
}

