/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.ObjectViewer;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.ObjectInfo;
import java.awt.Graphics;
import java.awt.Panel;

public abstract class MeshViewer
extends ObjectViewer {
    public static final int HANDLE_SIZE = 5;
    protected boolean showMesh;
    protected boolean showSurface;
    protected boolean showSkeleton;
    private int selectedJoint;
    private int baseJoint;
    private boolean detachSkeleton;
    private static boolean lastShowMesh = true;
    private static boolean lastShowSurface = true;
    private static boolean lastShowSkeleton = true;

    public MeshViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
        Joint[] j;
        Skeleton s = ((Mesh)((Object)obj.object)).getSkeleton();
        if (s != null && (j = s.getJoints()).length > 0) {
            this.baseJoint = j[0].id;
        }
        this.setMeshVisible(lastShowMesh);
        this.setSurfaceVisible(lastShowSurface);
        this.setSkeletonVisible(lastShowSkeleton);
    }

    public abstract void drawDraggedSelection(Graphics var1, Camera var2, Vec3[] var3);

    public abstract int[] getSelectionDistance();

    public abstract void setMesh(Mesh var1);

    public int getSelectedJoint() {
        return this.selectedJoint;
    }

    public void setSelectedJoint(int id) {
        this.selectedJoint = id;
    }

    public int getBaseJoint() {
        return this.baseJoint;
    }

    public void setBaseJoint(int id) {
        this.baseJoint = id;
    }

    public boolean getMeshVisible() {
        return this.showMesh;
    }

    public void setMeshVisible(boolean visible) {
        lastShowMesh = this.showMesh = visible;
    }

    public boolean getSurfaceVisible() {
        return this.showSurface;
    }

    public void setSurfaceVisible(boolean visible) {
        lastShowSurface = this.showSurface = visible;
    }

    public boolean getSkeletonVisible() {
        return this.showSkeleton;
    }

    public void setSkeletonVisible(boolean visible) {
        lastShowSkeleton = this.showSkeleton = visible;
    }

    public boolean getSkeletonDetached() {
        return this.detachSkeleton;
    }

    public void setSkeletonDetached(boolean detached) {
        this.detachSkeleton = detached;
    }
}

