/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ApplicationPreferences;
import artofillusion.JarClassLoader;
import artofillusion.LayoutWindow;
import artofillusion.ModellingTool;
import artofillusion.Plugin;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.TitleWindow;
import artofillusion.Translator;
import artofillusion.UndoRecord;
import artofillusion.animation.PositionTrack;
import artofillusion.animation.RotationTrack;
import artofillusion.image.ImageMap;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.script.ScriptRunner;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ModellingApp {
    public static final String VERSION = "1.3";
    public static final double DIST_TO_SCREEN = 20.0;
    public static final Color APP_BACKGROUND_COLOR = new Color(228, 228, 243);
    public static final String APP_DIRECTORY;
    public static final String PLUGIN_DIRECTORY;
    public static final String TOOL_SCRIPT_DIRECTORY;
    public static final String OBJECT_SCRIPT_DIRECTORY;
    public static final String STARTUP_SCRIPT_DIRECTORY;
    public static Font defaultFont;
    public static String currentDirectory;
    private static ApplicationPreferences preferences;
    private static ObjectInfo[] clipboardObject;
    private static Texture[] clipboardTexture;
    private static Material[] clipboardMaterial;
    private static ImageMap[] clipboardImage;
    private static Vector windows;
    private static JarClassLoader[] pluginLoader;
    private static Vector renderers;
    private static Vector translators;
    private static Vector modellingTools;
    private static Vector textures;
    private static Vector materials;
    private static Vector textureMappings;
    private static Vector materialMappings;
    private static Vector plugins;
    private static Hashtable classTranslations;
    static /* synthetic */ Class class$artofillusion$ModellingApp;

    public static void main(String[] args) {
        Translate.setLocale(Locale.getDefault());
        TitleWindow title = new TitleWindow();
        try {
            textures.addElement(Class.forName("artofillusion.texture.UniformTexture"));
            textures.addElement(Class.forName("artofillusion.texture.ImageMapTexture"));
            textures.addElement(Class.forName("artofillusion.texture.ProceduralTexture2D"));
            textures.addElement(Class.forName("artofillusion.texture.ProceduralTexture3D"));
            materials.addElement(Class.forName("artofillusion.material.UniformMaterial"));
            materials.addElement(Class.forName("artofillusion.material.ProceduralMaterial3D"));
            textureMappings.addElement(Class.forName("artofillusion.texture.UniformMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.ProjectionMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.CylindricalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.SphericalMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.UVMapping"));
            textureMappings.addElement(Class.forName("artofillusion.texture.LinearMapping3D"));
            materialMappings.addElement(Class.forName("artofillusion.material.LinearMaterialMapping"));
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (pluginLoader == null) {
            ModellingApp.scanPlugins();
        }
        preferences = new ApplicationPreferences();
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(0, new Object[0]);
            ++i;
        }
        int numWindows = windows.size();
        ModellingApp.runStartupScripts();
        if (numWindows == windows.size()) {
            ModellingApp.newWindow();
        }
        title.dispose();
    }

    public static ApplicationPreferences getPreferences() {
        return preferences;
    }

    public static Renderer[] getRenderers() {
        Object[] r = new Renderer[renderers.size()];
        renderers.copyInto(r);
        return r;
    }

    public static Plugin[] getPlugins() {
        Object[] p = new Plugin[plugins.size()];
        plugins.copyInto(p);
        return p;
    }

    public static Translator[] getTranslators() {
        Object[] t = new Translator[translators.size()];
        translators.copyInto(t);
        return t;
    }

    public static ModellingTool[] getModellingTools() {
        Object[] t = new ModellingTool[modellingTools.size()];
        modellingTools.copyInto(t);
        return t;
    }

    public static Class[] getTextureTypes() {
        Object[] t = new Class[textures.size()];
        textures.copyInto(t);
        return t;
    }

    public static Class[] getMaterialTypes() {
        Object[] m = new Class[materials.size()];
        materials.copyInto(m);
        return m;
    }

    public static Class[] getTextureMappings() {
        Object[] t = new Class[textureMappings.size()];
        textureMappings.copyInto(t);
        return t;
    }

    public static Class[] getMaterialMappings() {
        Object[] m = new Class[materialMappings.size()];
        materialMappings.copyInto(m);
        return m;
    }

    public static void registerRenderer(Renderer o) {
        renderers.addElement(o);
    }

    public static void registerTranslator(Translator o) {
        translators.addElement(o);
    }

    public static void registerModellingTool(ModellingTool o) {
        modellingTools.addElement(o);
    }

    public static void registerTexture(Texture o) {
        textures.addElement(o);
    }

    public static void registerMaterial(Material o) {
        materials.addElement(o);
    }

    public static void registerTextureMapping(TextureMapping o) {
        textureMappings.addElement(o);
    }

    public static void registerMaterialMapping(MaterialMapping o) {
        materialMappings.addElement(o);
    }

    public static void registerPlugin(Plugin o) {
        plugins.addElement(o);
    }

    public static void newWindow() {
        Scene theScene = new Scene();
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 20.0), new Vec3(0.0, 0.0, -1.0), Vec3.vy());
        ObjectInfo info = new ObjectInfo(new SceneCamera(), coords, "Camera 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        info = new ObjectInfo(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), coords.duplicate(), "Light 1");
        info.addTrack(new PositionTrack(info), 0);
        info.addTrack(new RotationTrack(info), 1);
        theScene.addObject(info, null);
        LayoutWindow fr = new LayoutWindow(theScene);
        windows.addElement(fr);
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(2, new Object[]{fr});
            ++i;
        }
        fr.show();
    }

    public static void newWindow(Scene theScene) {
        LayoutWindow fr = new LayoutWindow(theScene);
        windows.addElement(fr);
        int i = 0;
        while (i < plugins.size()) {
            ((Plugin)plugins.elementAt(i)).processMessage(2, new Object[]{fr});
            ++i;
        }
        fr.show();
        int i2 = windows.size() - 2;
        while (i2 >= 0) {
            LayoutWindow win;
            if (windows.elementAt(i2) instanceof LayoutWindow && (win = (LayoutWindow)windows.elementAt(i2)).getScene().getName() == null && !win.modified) {
                ModellingApp.closeWindow(win);
            }
            --i2;
        }
    }

    public static void addWindow(EditingWindow win) {
        windows.addElement(win);
    }

    public static void closeWindow(EditingWindow win) {
        if (win.confirmClose()) {
            windows.removeElement(win);
            if (win instanceof LayoutWindow) {
                int i = 0;
                while (i < plugins.size()) {
                    ((Plugin)plugins.elementAt(i)).processMessage(3, new Object[]{win});
                    ++i;
                }
            }
        }
        if (windows.size() == 0) {
            ModellingApp.quit();
        }
    }

    public static EditingWindow[] getWindows() {
        Object[] w = new EditingWindow[windows.size()];
        windows.copyInto(w);
        return w;
    }

    public static void quit() {
        int i = windows.size() - 1;
        while (i >= 0) {
            EditingWindow win = (EditingWindow)windows.elementAt(i);
            ModellingApp.closeWindow(win);
            if (windows.contains(win)) {
                return;
            }
            --i;
        }
        int i2 = 0;
        while (i2 < plugins.size()) {
            ((Plugin)plugins.elementAt(i2)).processMessage(1, new Object[0]);
            ++i2;
        }
        System.exit(0);
    }

    static void scanPlugins() {
        File dir2 = new File(PLUGIN_DIRECTORY);
        ZipFile zf = null;
        if (!dir2.exists()) {
            Frame fr = new Frame();
            new MessageDialog(fr, new String[]{"Unable to locate Plugins directory.  Make sure that", "Art of Illusion is properly installed, and that you", "launch it exactly as described in the instructions."});
            fr.dispose();
            pluginLoader = new JarClassLoader[0];
            return;
        }
        String[] files = dir2.list();
        pluginLoader = new JarClassLoader[files.length];
        int j = 0;
        int i = 0;
        while (i < files.length) {
            block19: {
                try {
                    zf = new ZipFile(new File(PLUGIN_DIRECTORY, files[i]));
                }
                catch (IOException ex) {
                    break block19;
                }
                try {
                    ModellingApp.pluginLoader[j++] = new JarClassLoader(zf);
                    ZipEntry ze = zf.getEntry("plugins");
                    if (ze == null) break block19;
                    BufferedReader in = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                    String name = in.readLine();
                    while (name != null) {
                        try {
                            Object instance = pluginLoader[j - 1].loadClass(name).newInstance();
                            if (instance instanceof Plugin) {
                                plugins.addElement(instance);
                            }
                            if (instance instanceof Renderer) {
                                renderers.addElement(instance);
                            }
                            if (instance instanceof Translator) {
                                translators.addElement(instance);
                            }
                            if (instance instanceof ModellingTool) {
                                modellingTools.addElement(instance);
                            }
                            if (instance instanceof Texture) {
                                textures.addElement(instance.getClass());
                            }
                            if (instance instanceof Material) {
                                materials.addElement(instance.getClass());
                            }
                        }
                        catch (ClassNotFoundException ex) {
                        }
                        catch (IllegalAccessException ex) {
                        }
                        catch (InstantiationException ex) {
                            // empty catch block
                        }
                        name = in.readLine();
                    }
                }
                catch (IOException ex) {
                    System.out.println("Error reading plugin file " + files[i]);
                }
            }
            ++i;
        }
        if (j < files.length) {
            JarClassLoader[] temp = new JarClassLoader[j];
            i = 0;
            while (i < j) {
                temp[i] = pluginLoader[i];
                ++i;
            }
            pluginLoader = temp;
        }
    }

    private static void runStartupScripts() {
        String[] files = new File(STARTUP_SCRIPT_DIRECTORY).list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".bsh")) {
                    try {
                        String script = ModellingApp.loadFile(new File(STARTUP_SCRIPT_DIRECTORY, files[i]));
                        ScriptRunner.executeScript(script);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        try {
            return ModellingApp.lookupClass(name);
        }
        catch (ClassNotFoundException ex) {
            int i = name.indexOf(36);
            if (i == -1) {
                String newName = (String)classTranslations.get(name);
                if (newName == null) {
                    throw ex;
                }
                return ModellingApp.lookupClass(newName);
            }
            String newName = (String)classTranslations.get(name.substring(0, i));
            if (newName == null) {
                throw ex;
            }
            return ModellingApp.lookupClass(newName + name.substring(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Class lookupClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            i = 0;
            ** while (i < ModellingApp.pluginLoader.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return ModellingApp.pluginLoader[i].loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                if (i == ModellingApp.pluginLoader.length - 1) {
                    throw ex;
                }
                ++i;
            }
            continue;
        }
lbl13:
        // 1 sources

        return null;
    }

    public static void centerWindow(Window win) {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = win.getSize();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        ((Component)win).setLocation(x, y);
    }

    /*
     * WARNING - void declaration
     */
    public static String loadFile(File f) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new FileReader(f));
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) != -1) {
            void var3_3;
            buf.append((char)var3_3);
        }
        in.close();
        return buf.toString();
    }

    public static boolean saveScene(Scene sc, LayoutWindow fr) {
        try {
            File f = new File(sc.getDirectory(), sc.getName());
            sc.writeToFile(f);
            int i = 0;
            while (i < plugins.size()) {
                ((Plugin)plugins.elementAt(i)).processMessage(4, new Object[]{f, fr});
                ++i;
            }
        }
        catch (IOException ex) {
            new MessageDialog((Frame)fr, new String[]{"An error occurred while attempting to save the scene.", ex.getMessage()});
            return false;
        }
        return true;
    }

    public static void openScene(Frame fr) {
        FileDialog fd = new FileDialog(fr, "Open Scene", 0);
        if (currentDirectory != null) {
            fd.setDirectory(currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        currentDirectory = fd.getDirectory();
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
            Scene sc = new Scene(in, true);
            sc.setName(fd.getFile());
            sc.setDirectory(fd.getDirectory());
            ModellingApp.newWindow(sc);
            in.close();
            if (sc.errorsLoading) {
                new MessageDialog(fr, new String[]{"Errors occurred while reading the file.  As a result, some elements", "of the scene could not be loaded correctly.  The file may have", "been created with a later version of Art of Illusion."});
            }
        }
        catch (InvalidObjectException ex) {
            new MessageDialog(fr, new String[]{"An error occurred while reading the file.  This file may", "have been created with a later version of Art of Illusion."});
        }
        catch (IOException ex) {
            new MessageDialog(fr, new String[]{"An error occurred while reading the file.", ex.getMessage()});
        }
    }

    public static void copyToClipboard(ObjectInfo[] obj, Scene scene) {
        Vector<Texture> textures = new Vector<Texture>();
        int i = 0;
        while (i < obj.length) {
            Texture tex = obj[i].object.getTexture();
            if (tex instanceof LayeredTexture) {
                LayeredMapping map = (LayeredMapping)obj[i].object.getTextureMapping();
                Texture[] layer = map.getLayers();
                int j = 0;
                while (j < layer.length) {
                    Texture dup = layer[j].duplicate();
                    dup.setID(layer[j].getID());
                    TextureMapping dupMap = map.getLayerMapping(j);
                    textures.addElement(dup);
                    map.setLayer(j, dup);
                    map.setLayerMapping(j, map.getLayerMapping(j).duplicate(dup));
                    ++j;
                }
            } else if (tex != null) {
                Texture dup = tex.duplicate();
                dup.setID(tex.getID());
                textures.addElement(dup);
                obj[i].object.setTexture(dup);
                obj[i].object.setTextureMapping(obj[i].object.getTextureMapping().duplicate(dup));
            }
            ++i;
        }
        Vector<Material> materials = new Vector<Material>();
        int i2 = 0;
        while (i2 < obj.length) {
            Material mat = obj[i2].object.getMaterial();
            if (mat != null) {
                Material dup = mat.duplicate();
                dup.setID(mat.getID());
                materials.addElement(dup);
                obj[i2].object.setMaterial(dup);
                obj[i2].object.setMaterialMapping(obj[i2].object.getMaterialMapping().duplicate(dup));
            }
            ++i2;
        }
        Vector<ImageMap> images = new Vector<ImageMap>();
        int i3 = 0;
        while (i3 < scene.getNumImages()) {
            ImageMap map = scene.getImage(i3);
            boolean used = false;
            int j = 0;
            while (j < textures.size() && !used) {
                used = ((Texture)textures.elementAt(j)).usesImage(map);
                ++j;
            }
            int j2 = 0;
            while (j2 < materials.size() && !used) {
                used = ((Material)materials.elementAt(j2)).usesImage(map);
                ++j2;
            }
            if (used) {
                images.addElement(map);
            }
            ++i3;
        }
        clipboardObject = obj;
        clipboardTexture = new Texture[textures.size()];
        textures.copyInto(clipboardTexture);
        clipboardMaterial = new Material[materials.size()];
        materials.copyInto(clipboardMaterial);
        clipboardImage = new ImageMap[images.size()];
        images.copyInto(clipboardImage);
    }

    public static void pasteClipboard(LayoutWindow win) {
        if (clipboardObject == null) {
            return;
        }
        Scene scene = win.getScene();
        UndoRecord undo = new UndoRecord(win, false);
        win.setUndoRecord(undo);
        int i = 0;
        while (i < clipboardImage.length) {
            int j = 0;
            while (j < scene.getNumImages() && clipboardImage[i].getID() != scene.getImage(j).getID()) {
                ++j;
            }
            if (j == scene.getNumImages()) {
                scene.addImage(clipboardImage[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < clipboardTexture.length) {
            Texture newtex;
            int j = 0;
            while (j < scene.getNumTextures() && clipboardTexture[i2].getID() != scene.getTexture(j).getID()) {
                ++j;
            }
            if (j == scene.getNumTextures()) {
                newtex = clipboardTexture[i2].duplicate();
                newtex.setID(clipboardTexture[i2].getID());
                scene.addTexture(newtex);
            } else {
                newtex = scene.getTexture(j);
            }
            j = 0;
            while (j < clipboardObject.length) {
                Texture current = ModellingApp.clipboardObject[j].object.getTexture();
                if (current == clipboardTexture[i2]) {
                    clipboardObject[j].setTexture(newtex, ModellingApp.clipboardObject[j].object.getTextureMapping().duplicate(newtex));
                } else if (current instanceof LayeredTexture) {
                    LayeredMapping map = (LayeredMapping)ModellingApp.clipboardObject[j].object.getTextureMapping();
                    map = (LayeredMapping)map.duplicate();
                    clipboardObject[j].setTexture(new LayeredTexture(map), map);
                    Texture[] layer = map.getLayers();
                    int k = 0;
                    while (k < layer.length) {
                        if (layer[k] == clipboardTexture[i2]) {
                            map.setLayer(k, newtex);
                            map.setLayerMapping(k, map.getLayerMapping(k).duplicate(newtex));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < clipboardMaterial.length) {
            Material newmat;
            int j = 0;
            while (j < scene.getNumMaterials() && clipboardMaterial[i3].getID() != scene.getMaterial(j).getID()) {
                ++j;
            }
            if (j == scene.getNumMaterials()) {
                newmat = clipboardMaterial[i3].duplicate();
                newmat.setID(clipboardMaterial[i3].getID());
                scene.addMaterial(newmat);
            } else {
                newmat = scene.getMaterial(j);
            }
            j = 0;
            while (j < clipboardObject.length) {
                Material current = ModellingApp.clipboardObject[j].object.getMaterial();
                if (current == clipboardMaterial[i3]) {
                    clipboardObject[j].setMaterial(newmat, ModellingApp.clipboardObject[j].object.getMaterialMapping().duplicate(newmat));
                }
                ++j;
            }
            ++i3;
        }
        ObjectInfo[] obj = ObjectInfo.duplicateAll(clipboardObject);
        int i4 = 0;
        while (i4 < obj.length) {
            win.addObject(obj[i4], undo);
            ++i4;
        }
    }

    public static int getClipboardSize() {
        if (clipboardObject == null) {
            return 0;
        }
        return clipboardObject.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        windows = new Vector();
        renderers = new Vector();
        translators = new Vector();
        modellingTools = new Vector();
        textures = new Vector();
        materials = new Vector();
        textureMappings = new Vector();
        materialMappings = new Vector();
        plugins = new Vector();
        classTranslations = new Hashtable();
        String dir2 = System.getProperty("user.dir");
        try {
            URL url = (class$artofillusion$ModellingApp == null ? (class$artofillusion$ModellingApp = ModellingApp.class$("artofillusion.ModellingApp")) : class$artofillusion$ModellingApp).getResource("/artofillusion/ModellingApp.class");
            if (url.toString().startsWith("jar:")) {
                String furl = url.getFile();
                dir2 = new File(new URL(furl = furl.substring(0, furl.indexOf(33))).getFile()).getParent();
                if (!new File(dir2).exists()) {
                    dir2 = System.getProperty("user.dir");
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        APP_DIRECTORY = dir2;
        PLUGIN_DIRECTORY = new File(APP_DIRECTORY, "Plugins").getAbsolutePath();
        File scripts = new File(APP_DIRECTORY, "Scripts");
        TOOL_SCRIPT_DIRECTORY = new File(scripts, "Tools").getAbsolutePath();
        OBJECT_SCRIPT_DIRECTORY = new File(scripts, "Objects").getAbsolutePath();
        STARTUP_SCRIPT_DIRECTORY = new File(scripts, "Startup").getAbsolutePath();
        classTranslations.put("artofillusion.tools.CSGObject", "artofillusion.object.CSGObject");
        classTranslations.put("artofillusion.Cube", "artofillusion.object.Cube");
        classTranslations.put("artofillusion.Curve", "artofillusion.object.Curve");
        classTranslations.put("artofillusion.Cylinder", "artofillusion.object.Cylinder");
        classTranslations.put("artofillusion.DirectionalLight", "artofillusion.object.DirectionalLight");
        classTranslations.put("artofillusion.NullObject", "artofillusion.object.NullObject");
        classTranslations.put("artofillusion.PointLight", "artofillusion.object.PointLight");
        classTranslations.put("artofillusion.SceneCamera", "artofillusion.object.SceneCamera");
        classTranslations.put("artofillusion.Sphere", "artofillusion.object.Sphere");
        classTranslations.put("artofillusion.SplineMesh", "artofillusion.object.SplineMesh");
        classTranslations.put("artofillusion.SpotLight", "artofillusion.object.SpotLight");
        classTranslations.put("artofillusion.TriangleMesh", "artofillusion.object.TriangleMesh");
        classTranslations.put("artofillusion.Tube", "artofillusion.object.Tube");
        classTranslations.put("artofillusion.CylindricalMapping", "artofillusion.texture.CylindricalMapping");
        classTranslations.put("artofillusion.ImageMapTexture", "artofillusion.texture.ImageMapTexture");
        classTranslations.put("artofillusion.LayeredMapping", "artofillusion.texture.LayeredMapping");
        classTranslations.put("artofillusion.LayeredTexture", "artofillusion.texture.LayeredTexture");
        classTranslations.put("artofillusion.LinearMapping3D", "artofillusion.texture.LinearMapping3D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture2D", "artofillusion.texture.ProceduralTexture2D");
        classTranslations.put("artofillusion.procedural.ProceduralTexture3D", "artofillusion.texture.ProceduralTexture3D");
        classTranslations.put("artofillusion.ProjectionMapping", "artofillusion.texture.ProjectionMapping");
        classTranslations.put("artofillusion.SphericalMapping", "artofillusion.texture.SphericalMapping");
        classTranslations.put("artofillusion.UniformMapping", "artofillusion.texture.UniformMapping");
        classTranslations.put("artofillusion.UniformTexture", "artofillusion.texture.UniformTexture");
        classTranslations.put("artofillusion.LinearMaterialMapping", "artofillusion.material.LinearMaterialMapping");
        classTranslations.put("artofillusion.procedural.ProceduralMaterial3D", "artofillusion.material.ProceduralMaterial3D");
        classTranslations.put("artofillusion.UniformMaterial", "artofillusion.material.UniformMaterial");
        classTranslations.put("artofillusion.UniformMaterialMapping", "artofillusion.material.UniformMaterialMapping");
    }
}

