/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.RenderingDialog;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ObjectViewer
extends ViewerCanvas {
    protected boolean showScene;
    protected boolean useWorldCoords;
    protected boolean freehandSelection;
    protected boolean draggingBox;
    protected boolean squareBox;
    protected boolean sentClick;
    protected Point clickPoint;
    protected Point dragPoint;
    protected Vector selectBoundsPoints;
    protected Shape selectBounds;
    protected Object3D theObject;
    protected ObjectInfo objInfo;
    protected ObjectInfo thisObjectInScene;
    protected Scene theScene;
    protected static int lastRenderMode = 3;
    protected static boolean lastShowScene;
    protected static boolean lastUseWorldCoords;
    protected static boolean lastShowGrid;
    protected static boolean lastSnapToGrid;
    protected static boolean lastFreehand;
    protected static int lastGridSubdivisions;
    protected static double lastGridSpacing;
    static final RGBColor surfaceRGB;
    static final Color surfaceColor;

    public ObjectViewer(ObjectInfo obj, Panel p) {
        if (obj != null) {
            this.theObject = obj.object;
            this.objInfo = obj.duplicate();
            this.objInfo.coords.setOrigin(new Vec3());
            this.objInfo.coords.setOrientation(Vec3.vz(), Vec3.vy());
            this.objInfo.clearDistortion();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.buildChoices(p);
        this.setRenderMode(lastRenderMode);
        this.setSceneVisible(lastShowScene);
        this.setUseWorldCoords(lastUseWorldCoords);
        this.setGrid(lastGridSpacing, lastGridSubdivisions, lastShowGrid, lastSnapToGrid);
        this.setFreehandSelection(lastFreehand);
    }

    public ObjectInfo getObject() {
        return this.objInfo;
    }

    public void setObject(Object3D obj) {
        this.theObject = obj;
        if (this.objInfo == null) {
            this.objInfo = new ObjectInfo(obj, new CoordinateSystem(), "");
        } else {
            this.objInfo.object = obj;
        }
        this.objInfo.clearCachedMeshes();
    }

    public void objectChanged() {
        this.objInfo.clearCachedMeshes();
    }

    public synchronized void updateImage() {
        Dimension dim = this.getSize();
        this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
        super.updateImage();
        if (this.theImage == null || this.objInfo == null) {
            return;
        }
        if (this.gr != null) {
            this.gr.setColor(Color.black);
        }
        if (this.showScene && this.theScene != null) {
            int i = 0;
            while (i < this.theScene.getNumObjects()) {
                ObjectInfo obj = this.theScene.getObject(i);
                this.drawSceneObject(obj, obj.coords);
                ++i;
            }
        }
        if (this.useWorldCoords && this.thisObjectInScene != null) {
            this.theCamera.setObjectTransform(this.thisObjectInScene.coords.fromLocal());
        } else {
            this.theCamera.setObjectTransform(this.objInfo.coords.fromLocal());
        }
        this.drawObject(this.gr);
        this.drawBorder();
        if (this.renderMode != 0) {
            this.imageSource.newPixels();
        }
    }

    private void drawSceneObject(ObjectInfo obj, CoordinateSystem coords) {
        if (obj == this.thisObjectInScene || !obj.visible) {
            return;
        }
        if (obj.object instanceof ObjectCollection) {
            Enumeration enumeration = ((ObjectCollection)obj.object).getObjects(obj, true, this.theScene);
            while (enumeration.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)enumeration.nextElement();
                CoordinateSystem elemCoords = elem.coords.duplicate();
                elemCoords.transformCoordinates(coords.fromLocal());
                this.drawSceneObject(elem, elemCoords);
            }
            return;
        }
        if (this.useWorldCoords) {
            this.theCamera.setObjectTransform(coords.fromLocal());
        } else {
            this.theCamera.setObjectTransform(this.thisObjectInScene.coords.toLocal().times(coords.fromLocal()));
        }
        if (this.theCamera.visibility(obj.getBounds()) == 0) {
            return;
        }
        if (this.renderMode == 0) {
            Object3D.draw(this.gr, this.theCamera, obj.getWireframePreview(), obj.getBounds());
        } else {
            RenderingMesh mesh = obj.getPreviewMesh();
            if (mesh == null) {
                this.renderWireframe(obj.getWireframePreview(), this.theCamera);
            } else if (this.renderMode == 1) {
                this.renderFlat(mesh, this.theCamera, coords.toLocal().timesDirection(Vec3.vz()), obj.object.isClosed(), surfaceRGB);
            } else if (this.renderMode == 2) {
                this.renderSmooth(mesh, this.theCamera, coords.toLocal().timesDirection(Vec3.vz()), obj.object.isClosed(), surfaceRGB);
            } else {
                this.renderFlatTransparent(mesh, this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), surfaceRGB);
            }
        }
    }

    protected abstract void drawObject(Graphics var1);

    public CoordinateSystem getDisplayCoordinates() {
        if (this.useWorldCoords && this.thisObjectInScene != null) {
            return this.thisObjectInScene.coords;
        }
        return this.objInfo.coords;
    }

    public void setRenderMode(int mode) {
        super.setRenderMode(mode);
        lastRenderMode = mode;
    }

    public boolean getFreehandSelection() {
        return this.freehandSelection;
    }

    public void setFreehandSelection(boolean freehand) {
        this.freehandSelection = freehand;
        lastFreehand = freehand;
    }

    public Scene getScene() {
        return this.theScene;
    }

    public void setScene(Scene sc, ObjectInfo thisObject) {
        this.theScene = sc;
        this.thisObjectInScene = thisObject;
    }

    public boolean getSceneVisible() {
        return this.showScene;
    }

    public void setSceneVisible(boolean visible) {
        lastShowScene = this.showScene = visible;
    }

    public boolean getUseWorldCoords() {
        return this.useWorldCoords;
    }

    public void setUseWorldCoords(boolean use) {
        lastUseWorldCoords = this.useWorldCoords = use;
    }

    public void setGrid(double spacing, int subdivisions, boolean show, boolean snap) {
        super.setGrid(spacing, subdivisions, show, snap);
        lastGridSpacing = spacing;
        lastGridSubdivisions = subdivisions;
        lastShowGrid = show;
        lastSnapToGrid = snap;
    }

    public void beginDraggingSelection(Point p, boolean square) {
        this.draggingBox = true;
        this.clickPoint = p;
        this.squareBox = square;
        this.dragPoint = null;
        if (this.freehandSelection) {
            this.selectBoundsPoints = new Vector();
        }
    }

    public void endDraggingSelection() {
        if (!this.draggingBox || this.dragPoint == null) {
            this.selectBounds = null;
            return;
        }
        this.repaint();
        if (this.freehandSelection) {
            int n = this.selectBoundsPoints.size();
            int[] x = new int[n];
            int[] y = new int[n];
            int i = 0;
            while (i < n) {
                Point p = (Point)this.selectBoundsPoints.elementAt(i);
                x[i] = p.x;
                y[i] = p.y;
                ++i;
            }
            this.selectBounds = new Polygon(x, y, n);
        } else {
            this.selectBounds = new Rectangle(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
    }

    public boolean selectionRegionContains(Point p) {
        if (this.selectBounds instanceof Rectangle) {
            return ((Rectangle)this.selectBounds).contains(p);
        }
        if (this.selectBounds instanceof Polygon) {
            return ((Polygon)this.selectBounds).contains(p);
        }
        return false;
    }

    public void mouseDragged(MouseEvent e) {
        Graphics g = this.getGraphics();
        this.moveToGrid(e);
        if (this.draggingBox && this.freehandSelection) {
            Point prev = this.dragPoint == null ? this.clickPoint : this.dragPoint;
            this.dragPoint = e.getPoint();
            g.setColor(Color.black);
            g.drawLine(prev.x, prev.y, this.dragPoint.x, this.dragPoint.y);
            this.selectBoundsPoints.addElement(this.dragPoint);
        } else if (this.draggingBox) {
            g.setXORMode(Color.white);
            g.setColor(Color.black);
            if (this.dragPoint != null) {
                g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
            }
            this.dragPoint = e.getPoint();
            if (this.squareBox) {
                if (Math.abs(this.dragPoint.x - this.clickPoint.x) > Math.abs(this.dragPoint.y - this.clickPoint.y)) {
                    this.dragPoint.y = this.dragPoint.y < this.clickPoint.y ? this.clickPoint.y - Math.abs(this.dragPoint.x - this.clickPoint.x) : this.clickPoint.y + Math.abs(this.dragPoint.x - this.clickPoint.x);
                } else {
                    this.dragPoint.x = this.dragPoint.x < this.clickPoint.x ? this.clickPoint.x - Math.abs(this.dragPoint.y - this.clickPoint.y) : this.clickPoint.x + Math.abs(this.dragPoint.y - this.clickPoint.y);
                }
            }
            g.drawRect(Math.min(this.clickPoint.x, this.dragPoint.x), Math.min(this.clickPoint.y, this.dragPoint.y), Math.abs(this.dragPoint.x - this.clickPoint.x), Math.abs(this.dragPoint.y - this.clickPoint.y));
        }
        g.dispose();
        if (this.sentClick) {
            this.activeTool.mouseDragged(e, this);
        }
    }

    public void previewObject() {
        Scene sc = new Scene();
        Container parent = this.getParent();
        double dist = this.theCamera.getDistToScreen();
        Renderer rend = ModellingApp.getPreferences().getObjectPreviewRenderer();
        if (rend == null) {
            return;
        }
        sc.addObject(new DirectionalLight(new RGBColor(1.0f, 1.0f, 1.0f), 0.8f), this.theCamera.getCameraCoordinates(), "", null);
        sc.addObject(this.objInfo, null);
        while (!(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        this.adjustCamera(true);
        rend.configurePreview();
        new RenderingDialog((Frame)parent, rend, sc, this.theCamera, dist / 2.0, dist);
        this.adjustCamera(this.perspectiveChoice.getSelectedIndex() == 0);
    }

    static {
        lastGridSubdivisions = 10;
        lastGridSpacing = 1.0;
        surfaceRGB = new RGBColor(0.8f, 0.8f, 1.0f);
        surfaceColor = new Color(0.8f, 0.8f, 1.0f);
    }
}

