/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class SkewMeshTool
extends EditingTool {
    boolean noSelection;
    boolean notOnHandle;
    boolean skewX;
    boolean skewY;
    boolean skewAll;
    static Image icon;
    static Image selectedIcon;
    Point clickPoint;
    double clickX;
    double clickY;
    double centerX;
    double centerY;
    Vec3 skewCenter;
    BoundingBox bounds;
    public static final int HANDLE_SIZE = 5;

    public SkewMeshTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("skewPoints.gif");
        selectedIcon = this.loadImage("selected/skewPoints.gif");
    }

    public void activate() {
        super.activate();
        MeshViewer view = (MeshViewer)this.theWindow.getView();
        int[] selected = view.getSelectionDistance();
        this.noSelection = false;
        int i = 0;
        while (i < selected.length) {
            if (selected[i] == 0) {
                this.theWindow.setHelpText(Translate.text("skewMeshTool.helpText"));
                return;
            }
            ++i;
        }
        this.theWindow.setHelpText(Translate.text("skewMeshTool.errorText"));
        this.noSelection = true;
    }

    public int whichClicks() {
        return 0;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        g.setColor(Color.red);
        Rectangle b = this.findScreenBounds(this.findSelectionBounds(v, cam, (MeshViewer)view), cam, (MeshViewer)view);
        if (b != null) {
            g.fillRect(b.x, b.y, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y, 5, 5);
            g.fillRect(b.x, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y, 5, 5);
            g.fillRect(b.x, b.y + (b.height - 5) / 2, 5, 5);
            g.fillRect(b.x + (b.width - 5) / 2, b.y + b.height - 5 + 1, 5, 5);
            g.fillRect(b.x + b.width - 5 + 1, b.y + (b.height - 5) / 2, 5, 5);
        }
    }

    public void mousePressed(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] v = mesh.getVertices();
        Camera cam = view.getCamera();
        if (this.noSelection) {
            return;
        }
        this.clickPoint = e.getPoint();
        this.bounds = this.findSelectionBounds(v, cam, (MeshViewer)view);
        Rectangle b = this.findScreenBounds(this.bounds, cam, (MeshViewer)view);
        if (!b.contains(this.clickPoint)) {
            this.notOnHandle = true;
            return;
        }
        int j = this.clickPoint.x <= b.x + 5 ? 0 : (this.clickPoint.x >= b.x + (b.width - 5) / 2 && this.clickPoint.x <= b.x + (b.width - 5) / 2 + 5 ? 1 : (this.clickPoint.x >= b.x + b.width - 5 ? 2 : -1));
        int k = this.clickPoint.y <= b.y + 5 ? 0 : (this.clickPoint.y >= b.y + (b.height - 5) / 2 && this.clickPoint.y <= b.y + (b.height - 5) / 2 + 5 ? 1 : (this.clickPoint.y >= b.y + b.height - 5 ? 2 : -1));
        if (j == -1 || k == -1 || j == 1 && k == 1) {
            this.notOnHandle = true;
            return;
        }
        this.notOnHandle = false;
        this.clickX = this.clickPoint.x;
        this.clickY = this.clickPoint.y;
        this.skewCenter = new Vec3(0.0, 0.0, (this.bounds.minz + this.bounds.maxz) / 2.0);
        if (j == 0) {
            this.skewY = true;
            this.centerX = b.x + b.width;
            this.skewCenter.x = this.bounds.minx;
        } else if (j == 2) {
            this.skewY = true;
            this.centerX = b.x;
            this.skewCenter.x = this.bounds.maxx;
        } else {
            this.skewY = false;
            this.skewCenter.x = this.bounds.minx + this.bounds.maxx;
        }
        if (k == 0) {
            this.skewX = true;
            this.centerY = b.y + b.height;
            this.skewCenter.y = this.bounds.miny;
        } else if (k == 2) {
            this.skewX = true;
            this.centerY = b.y;
            this.skewCenter.y = this.bounds.maxy;
        } else {
            this.skewX = false;
            this.skewCenter.y = this.bounds.miny + this.bounds.maxy;
        }
        if (e.isControlDown()) {
            this.centerX = b.x + b.width / 2;
            this.centerY = b.y + b.height / 2;
            this.skewCenter.x = (this.bounds.minx + this.bounds.maxx) / 2.0;
            this.skewCenter.y = (this.bounds.miny + this.bounds.maxy) / 2.0;
        }
        this.skewAll = this.skewX && this.skewY && e.isShiftDown();
    }

    public void mouseDragged(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        int vertSize = 5;
        int[] selectDist = ((MeshViewer)view).getSelectionDistance();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        Graphics g = view.getGraphics();
        double yskew = 0.0;
        double xskew = 0.0;
        if (this.skewX) {
            xskew = ((double)dragPoint.x - this.clickX) / ((double)dragPoint.y - this.centerY);
        }
        if (this.skewY) {
            yskew = ((double)dragPoint.y - this.clickY) / ((double)dragPoint.x - this.centerX);
        }
        if (this.skewAll) {
            double max = Math.max(Math.abs(xskew), Math.abs(yskew));
            if (xskew != 0.0) {
                xskew *= max / Math.abs(xskew);
            }
            if (yskew != 0.0) {
                yskew *= max / Math.abs(yskew);
            }
        }
        Vec3[] v = this.findSkewedPositions(vert, xskew, yskew, (MeshViewer)view);
        view.drawImage(g);
        g.setColor(Color.gray);
        int i = 0;
        while (i < v.length) {
            if (selectDist[i] > -1) {
                Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                g.fillRect((int)p.x - vertSize / 2, (int)p.y - vertSize / 2, vertSize, vertSize);
            }
            ++i;
        }
        ((MeshViewer)view).drawDraggedSelection(g, cam, v);
        g.dispose();
    }

    public void mouseReleased(MouseEvent e, ViewerCanvas view) {
        Mesh mesh = (Mesh)((Object)((MeshViewer)view).getObject().object);
        MeshVertex[] vert = mesh.getVertices();
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        if (this.noSelection || this.notOnHandle) {
            return;
        }
        double yskew = 0.0;
        double xskew = 0.0;
        if (this.skewX) {
            xskew = ((double)dragPoint.x - this.clickX) / ((double)dragPoint.y - this.centerY);
        }
        if (this.skewY) {
            yskew = ((double)dragPoint.y - this.clickY) / ((double)dragPoint.x - this.centerX);
        }
        if (this.skewAll) {
            double max = Math.max(Math.abs(xskew), Math.abs(yskew));
            if (xskew != 0.0) {
                xskew *= max / Math.abs(xskew);
            }
            if (yskew != 0.0) {
                yskew *= max / Math.abs(yskew);
            }
        }
        this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 0, new Object[]{mesh, mesh.duplicate()}));
        Vec3[] v = this.findSkewedPositions(vert, xskew, yskew, (MeshViewer)view);
        mesh.setVertices(v);
        ((ObjectViewer)view).objectChanged();
        this.theWindow.updateImage();
    }

    BoundingBox findSelectionBounds(MeshVertex[] vert, Camera cam, MeshViewer view) {
        int[] selected = view.getSelectionDistance();
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        int i = 0;
        while (i < vert.length) {
            if (selected[i] == 0) {
                Vec3 v = cam.getObjectToView().times(vert[i].r);
                if (v.x < minx) {
                    minx = v.x;
                }
                if (v.x > maxx) {
                    maxx = v.x;
                }
                if (v.y < miny) {
                    miny = v.y;
                }
                if (v.y > maxy) {
                    maxy = v.y;
                }
                if (v.z < minz) {
                    minz = v.z;
                }
                if (v.z > maxz) {
                    maxz = v.z;
                }
            }
            ++i;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    Rectangle findScreenBounds(BoundingBox b, Camera cam, MeshViewer view) {
        CoordinateSystem coords = view.getObject().coords;
        Mat4 m = cam.getObjectToWorld();
        cam.setObjectTransform(cam.getViewToWorld());
        Rectangle r = cam.findScreenBounds(b);
        cam.setObjectTransform(m);
        if (r != null) {
            r.setBounds(r.x - 10, r.y - 10, r.width + 20, r.height + 20);
        }
        return r;
    }

    Vec3[] findSkewedPositions(MeshVertex[] vert, double xskew, double yskew, MeshViewer view) {
        Vec3[] v = new Vec3[vert.length];
        int[] selected = view.getSelectionDistance();
        Camera cam = view.getCamera();
        Mat4 m = cam.getObjectToView();
        m = Mat4.translation(-this.skewCenter.x, -this.skewCenter.y, -this.skewCenter.z).times(m);
        Mat4 s = new Mat4(1.0, xskew, 0.0, 0.0, yskew, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        m = s.times(m);
        m = Mat4.translation(this.skewCenter.x, this.skewCenter.y, this.skewCenter.z).times(m);
        m = cam.getViewToWorld().times(m);
        m = view.getDisplayCoordinates().toLocal().times(m);
        int i = 0;
        while (i < vert.length) {
            v[i] = selected[i] == 0 ? m.times(vert[i].r).minus(vert[i].r) : new Vec3();
            ++i;
        }
        if (this.theFrame instanceof MeshEditorWindow) {
            ((MeshEditorWindow)this.theFrame).adjustDeltas(v);
        }
        i = 0;
        while (i < vert.length) {
            v[i].add(vert[i].r);
            ++i;
        }
        return v;
    }
}

