/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.Camera;
import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.ObjectViewer;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class TriMeshViewer
extends MeshViewer {
    boolean[] selected;
    boolean[] visible;
    boolean draggingSelectionBox;
    boolean dragging;
    boolean tolerant;
    int[] selectionDistance;
    int maxDistance;
    int deselect;
    int selectMode;
    Point[] screenVert;
    double[] screenZ;
    int[][] boundary;
    public static final int POINT_MODE = 0;
    public static final int EDGE_MODE = 1;
    public static final int FACE_MODE = 2;

    public TriMeshViewer(ObjectInfo obj, Panel p) {
        super(obj, p);
        TriangleMesh mesh = (TriangleMesh)obj.object;
        this.selected = new boolean[mesh.getVertices().length];
        this.visible = new boolean[mesh.getVertices().length];
        this.findSelectionDistance();
    }

    protected void drawObject(Graphics g) {
        block58: {
            TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
            TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
            TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
            Dimension dim = this.getSize();
            if (this.showSurface) {
                if (this.renderMode == 0) {
                    g.setColor(ObjectViewer.surfaceColor);
                    Object3D.draw(g, this.theCamera, this.objInfo.getWireframePreview(), this.objInfo.getBounds());
                } else if (this.renderMode == 3) {
                    this.renderFlatTransparent(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), ObjectViewer.surfaceRGB);
                } else if (this.renderMode == 1) {
                    this.renderFlat(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
                } else {
                    this.renderSmooth(this.objInfo.getPreviewMesh(), this.theCamera, this.theCamera.getViewToWorld().timesDirection(Vec3.vz()), this.theObject.isClosed(), ObjectViewer.surfaceRGB);
                }
            }
            if (this.showSkeleton && ((TriangleMesh)this.theObject).getSkeleton() != null) {
                ((TriangleMesh)this.theObject).getSkeleton().draw(this, this.getSelectedJoint(), this.getBaseJoint());
            }
            this.screenVert = new Point[v.length];
            this.screenZ = new double[v.length];
            Vec2[] p = new Vec2[v.length];
            int i = 0;
            while (i < v.length) {
                p[i] = this.theCamera.getObjectToScreen().timesXY(v[i].r);
                this.screenVert[i] = new Point((int)p[i].x, (int)p[i].y);
                this.screenZ[i] = this.theCamera.getObjectToView().timesZ(v[i].r);
                this.visible[i] = this.screenZ[i] > this.theCamera.getClipDistance();
                ++i;
            }
            if (!this.showMesh) break block58;
            Color col = Color.black;
            if (this.renderMode == 1 || this.renderMode == 2) {
                if (this.selectMode == 0) {
                    i = 0;
                    while (i < e.length) {
                        if (this.visible[e[i].v1] && this.visible[e[i].v2]) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, col.getRGB());
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < v.length) {
                        if (!this.selected[i] && this.visible[i]) {
                            this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, col);
                        }
                        ++i;
                    }
                } else if (this.selectMode == 1) {
                    i = 0;
                    while (i < e.length) {
                        if (!this.selected[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, col.getRGB());
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < e.length) {
                        if (this.visible[e[i].v1] && this.visible[e[i].v2] && !this.selected[e[i].f1] && (e[i].f2 == -1 || !this.selected[e[i].f2])) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, col.getRGB());
                        }
                        ++i;
                    }
                }
            } else if (this.selectMode == 0) {
                i = 0;
                while (i < e.length) {
                    if (this.visible[e[i].v1] && this.visible[e[i].v2]) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], col);
                    }
                    ++i;
                }
                i = 0;
                while (i < v.length) {
                    if (!this.selected[i] && this.visible[i]) {
                        this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, col);
                    }
                    ++i;
                }
            } else if (this.selectMode == 1) {
                i = 0;
                while (i < e.length) {
                    if (!this.selected[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], col);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < e.length) {
                    if (this.visible[e[i].v1] && this.visible[e[i].v2] && !this.selected[e[i].f1] && (e[i].f2 == -1 || !this.selected[e[i].f2])) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], col);
                    }
                    ++i;
                }
            }
            if (this.currentTool.hilightSelection()) {
                col = Color.magenta;
            }
            if (this.renderMode == 1 || this.renderMode == 2) {
                if (this.selectMode == 0) {
                    i = 0;
                    while (i < v.length) {
                        if (this.selected[i] && this.visible[i]) {
                            this.renderBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, this.screenZ[i] - 0.01, col);
                        }
                        ++i;
                    }
                } else if (this.selectMode == 1) {
                    i = 0;
                    while (i < e.length) {
                        if (this.selected[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, col.getRGB());
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < e.length) {
                        if (this.visible[e[i].v1] && this.visible[e[i].v2] && (this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                            this.renderLine(p[e[i].v1], this.screenZ[e[i].v1] - 0.01, p[e[i].v2], this.screenZ[e[i].v2] - 0.01, this.theCamera, col.getRGB());
                        }
                        ++i;
                    }
                }
            } else if (this.selectMode == 0) {
                i = 0;
                while (i < v.length) {
                    if (this.selected[i] && this.visible[i]) {
                        this.drawBox(this.screenVert[i].x - 2, this.screenVert[i].y - 2, 5, 5, col);
                    }
                    ++i;
                }
            } else if (this.selectMode == 1) {
                i = 0;
                while (i < e.length) {
                    if (this.selected[i] && this.visible[e[i].v1] && this.visible[e[i].v2]) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], col);
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < e.length) {
                    if (this.visible[e[i].v1] && this.visible[e[i].v2] && (this.selected[e[i].f1] || e[i].f2 != -1 && this.selected[e[i].f2])) {
                        this.drawLine(this.screenVert[e[i].v1], this.screenVert[e[i].v2], col);
                    }
                    ++i;
                }
            }
        }
    }

    public void drawDraggedSelection(Graphics g, Camera cam, Vec3[] v) {
        TriangleMesh.Vertex[] vert = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] edge = ((TriangleMesh)this.theObject).getEdges();
        if (this.selectMode == 0) {
            int i = 0;
            while (i < vert.length) {
                if (vert[i].r != v[i]) {
                    Vec2 p = cam.getObjectToScreen().timesXY(v[i]);
                    g.fillRect((int)p.x - 2, (int)p.y - 2, 5, 5);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < edge.length) {
            if (vert[edge[i].v1].r != v[edge[i].v1] || vert[edge[i].v2].r != v[edge[i].v2]) {
                cam.drawClippedLine(g, v[edge[i].v1], v[edge[i].v2]);
            }
            ++i;
        }
    }

    public void setSelectionMode(int mode) {
        boolean[] newSel;
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        if (mode == this.selectMode) {
            return;
        }
        if (mode == 0) {
            newSel = new boolean[v.length];
            if (this.selectMode == 1) {
                int i = 0;
                while (i < e.length) {
                    if (this.selected[i]) {
                        newSel[e[i].v2] = true;
                        newSel[e[i].v1] = true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    if (this.selected[i]) {
                        newSel[f[i].v3] = true;
                        newSel[f[i].v2] = true;
                        newSel[f[i].v1] = true;
                    }
                    ++i;
                }
            }
        } else if (mode == 1) {
            newSel = new boolean[e.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    int i = 0;
                    while (i < e.length) {
                        newSel[i] = this.selected[e[i].v1] || this.selected[e[i].v2];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < e.length) {
                        newSel[i] = this.selected[e[i].v1] && this.selected[e[i].v2];
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    if (this.selected[i]) {
                        newSel[f[i].e3] = true;
                        newSel[f[i].e2] = true;
                        newSel[f[i].e1] = true;
                    }
                    ++i;
                }
            }
        } else {
            newSel = new boolean[f.length];
            if (this.selectMode == 0) {
                if (this.tolerant) {
                    int i = 0;
                    while (i < f.length) {
                        newSel[i] = this.selected[f[i].v1] || this.selected[f[i].v2] || this.selected[f[i].v3];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < f.length) {
                        newSel[i] = this.selected[f[i].v1] && this.selected[f[i].v2] && this.selected[f[i].v3];
                        ++i;
                    }
                }
            } else {
                int i = 0;
                while (i < f.length) {
                    newSel[i] = this.selected[f[i].e1] && this.selected[f[i].e2] && this.selected[f[i].e3];
                    ++i;
                }
            }
        }
        this.selectMode = mode;
        this.setSelection(newSel);
    }

    public int getSelectionMode() {
        return this.selectMode;
    }

    public boolean[] getSelection() {
        return this.selected;
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tol) {
        this.tolerant = tol;
    }

    public void setSelection(boolean[] sel) {
        this.selected = sel;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    public int[] getSelectionDistance() {
        if (this.maxDistance != MeshEditorWindow.getTensionDistance()) {
            this.findSelectionDistance();
        }
        return this.selectionDistance;
    }

    void findSelectionDistance() {
        int i;
        int[] dist = new int[((TriangleMesh)this.theObject).getVertices().length];
        TriangleMesh.Edge[] e = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        this.maxDistance = MeshEditorWindow.getTensionDistance();
        if (this.selectMode == 0) {
            i = 0;
            while (i < dist.length) {
                dist[i] = this.selected[i] ? 0 : -1;
                ++i;
            }
        } else if (this.selectMode == 1) {
            i = 0;
            while (i < dist.length) {
                dist[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.selected.length) {
                if (this.selected[i]) {
                    dist[e[i].v2] = 0;
                    dist[e[i].v1] = 0;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < dist.length) {
                dist[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.selected.length) {
                if (this.selected[i]) {
                    dist[f[i].v3] = 0;
                    dist[f[i].v2] = 0;
                    dist[f[i].v1] = 0;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.maxDistance) {
            int j = 0;
            while (j < e.length) {
                if (dist[e[j].v1] == -1 && dist[e[j].v2] == i) {
                    dist[e[j].v1] = i + 1;
                } else if (dist[e[j].v2] == -1 && dist[e[j].v1] == i) {
                    dist[e[j].v2] = i + 1;
                }
                ++j;
            }
            ++i;
        }
        this.selectionDistance = dist;
    }

    public void setMesh(Mesh mesh) {
        TriangleMesh obj = (TriangleMesh)mesh;
        this.setObject(obj);
        if (this.selectMode == 0 && this.selected.length != obj.getVertices().length) {
            this.selected = new boolean[obj.getVertices().length];
            this.visible = new boolean[obj.getVertices().length];
        }
        if (this.selectMode == 1 && this.selected.length != obj.getEdges().length) {
            this.selected = new boolean[obj.getEdges().length];
            this.visible = new boolean[obj.getEdges().length];
        }
        if (this.selectMode == 2 && this.selected.length != obj.getFaces().length) {
            this.selected = new boolean[obj.getFaces().length];
            this.visible = new boolean[obj.getFaces().length];
        }
        this.findSelectionDistance();
        this.boundary = null;
        this.currentTool.getWindow().updateMenus();
    }

    public int[][] findSelectedBoundaries() {
        int j;
        if (this.selectMode != 1) {
            return new int[0][0];
        }
        if (this.boundary == null) {
            this.boundary = ((TriangleMesh)this.theObject).findBoundaryEdges();
        }
        boolean[] allSelected = new boolean[this.boundary.length];
        int count = 0;
        int i = 0;
        while (i < this.boundary.length) {
            j = 0;
            while (j < this.boundary[i].length) {
                if (!this.selected[this.boundary[i][j]]) break;
                ++j;
            }
            if (j == this.boundary[i].length) {
                allSelected[i] = true;
                ++count;
            }
            ++i;
        }
        int[][] index = new int[count][];
        j = 0;
        i = 0;
        while (i < allSelected.length) {
            if (allSelected[i]) {
                index[j++] = this.boundary[i];
            }
            ++i;
        }
        return index;
    }

    public void mousePressed(MouseEvent e) {
        TriangleMesh.Vertex[] v = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] f = ((TriangleMesh)this.theObject).getFaces();
        this.sentClick = true;
        this.deselect = -1;
        this.dragging = false;
        this.clickPoint = e.getPoint();
        this.activeTool = this.metaTool != null && e.isMetaDown() ? this.metaTool : (this.altTool != null && e.isAltDown() ? this.altTool : this.currentTool);
        if (this.activeTool.whichClicks() == 0) {
            this.activeTool.mousePressed(e, this);
            this.dragging = true;
            return;
        }
        int i = this.findClickTarget(e.getPoint());
        if (i == -1) {
            this.draggingSelectionBox = true;
            this.beginDraggingSelection(e.getPoint(), false);
            this.sentClick = false;
            return;
        }
        int j = this.selectMode == 1 ? (this.visible[ed[i].v1] ? ed[i].v1 : ed[i].v2) : (this.selectMode == 2 ? (this.visible[f[i].v1] ? f[i].v1 : (this.visible[f[i].v2] ? f[i].v2 : f[i].v3)) : i);
        if (this.selected[i]) {
            if (e.isShiftDown()) {
                this.deselect = i;
            }
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
            return;
        }
        if (!e.isShiftDown()) {
            int k = 0;
            while (k < this.selected.length) {
                this.selected[k] = false;
                ++k;
            }
        }
        this.selected[i] = true;
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        if (e.isShiftDown()) {
            this.sentClick = false;
            this.updateImage();
            this.repaint();
        } else {
            this.activeTool.mousePressedOnHandle(e, this, 0, j);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            Point p = e.getPoint();
            if (Math.abs(p.x - this.clickPoint.x) < 2 && Math.abs(p.y - this.clickPoint.y) < 2) {
                return;
            }
        }
        this.dragging = true;
        this.deselect = -1;
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        int i;
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        this.moveToGrid(e);
        this.endDraggingSelection();
        if (this.draggingSelectionBox && !e.isShiftDown() && !e.isControlDown()) {
            i = 0;
            while (i < this.selected.length) {
                this.selected[i] = false;
                ++i;
            }
        }
        if (this.selectBounds != null) {
            boolean newsel;
            boolean bl = newsel = !e.isControlDown();
            if (this.selectMode == 0) {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[i])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            } else if (this.selectMode == 1) {
                if (this.tolerant) {
                    i = 0;
                    while (i < this.selected.length) {
                        if (this.selectionRegionContains(this.screenVert[ed[i].v1]) || this.selectionRegionContains(this.screenVert[ed[i].v2])) {
                            this.selected[i] = newsel;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < this.selected.length) {
                        if (this.selectionRegionContains(this.screenVert[ed[i].v1]) && this.selectionRegionContains(this.screenVert[ed[i].v2])) {
                            this.selected[i] = newsel;
                        }
                        ++i;
                    }
                }
            } else if (this.tolerant) {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[fc[i].v1]) || this.selectionRegionContains(this.screenVert[fc[i].v2]) || this.selectionRegionContains(this.screenVert[fc[i].v3])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.selected.length) {
                    if (this.selectionRegionContains(this.screenVert[fc[i].v1]) && this.selectionRegionContains(this.screenVert[fc[i].v2]) && this.selectionRegionContains(this.screenVert[fc[i].v3])) {
                        this.selected[i] = newsel;
                    }
                    ++i;
                }
            }
        }
        this.draggingSelectionBox = false;
        this.draggingBox = false;
        if (this.sentClick) {
            if (!this.dragging) {
                Point p = e.getPoint();
                e.translatePoint(this.clickPoint.x - p.x, this.clickPoint.y - p.y);
            }
            this.activeTool.mouseReleased(e, this);
        }
        if (this.deselect > -1) {
            this.selected[this.deselect] = false;
        }
        this.findSelectionDistance();
        this.currentTool.getWindow().updateMenus();
        this.updateImage();
        this.repaint();
    }

    private int findClickTarget(Point pos) {
        TriangleMesh.Vertex[] vt = (TriangleMesh.Vertex[])((TriangleMesh)this.theObject).getVertices();
        TriangleMesh.Edge[] ed = ((TriangleMesh)this.theObject).getEdges();
        TriangleMesh.Face[] fc = ((TriangleMesh)this.theObject).getFaces();
        double closestz = Double.MAX_VALUE;
        boolean sel = false;
        int which = -1;
        if (this.selectMode == 0) {
            int i = 0;
            while (i < vt.length) {
                if (this.visible[i] && (!sel || this.selected[i])) {
                    double z;
                    Point v1 = this.screenVert[i];
                    if (pos.x >= v1.x - 2 && pos.x <= v1.x + 2 && pos.y >= v1.y - 2 && pos.y <= v1.y + 2 && (z = this.theCamera.getObjectToView().timesZ(vt[i].r)) < closestz) {
                        which = i;
                        closestz = z;
                        sel = this.selected[i];
                    }
                }
                ++i;
            }
        } else if (this.selectMode == 1) {
            int i = 0;
            while (i < ed.length) {
                if (this.visible[ed[i].v1] && this.visible[ed[i].v2] && (!sel || this.selected[i])) {
                    Point v1 = this.screenVert[ed[i].v1];
                    Point v2 = this.screenVert[ed[i].v2];
                    if (!(pos.x < v1.x - 2 && pos.x < v2.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2)) {
                        double z;
                        double w;
                        double u;
                        double v;
                        if (Math.abs(v1.x - v2.x) > Math.abs(v1.y - v2.y)) {
                            if (v2.x > v1.x) {
                                v = ((double)pos.x - (double)v1.x) / (double)(v2.x - v1.x);
                                u = 1.0 - v;
                            } else {
                                u = ((double)pos.x - (double)v2.x) / (double)(v1.x - v2.x);
                                v = 1.0 - u;
                            }
                            w = u * (double)v1.y + v * (double)v2.y - (double)pos.y;
                        } else {
                            if (v2.y > v1.y) {
                                v = ((double)pos.y - (double)v1.y) / (double)(v2.y - v1.y);
                                u = 1.0 - v;
                            } else {
                                u = ((double)pos.y - (double)v2.y) / (double)(v1.y - v2.y);
                                v = 1.0 - u;
                            }
                            w = u * (double)v1.x + v * (double)v2.x - (double)pos.x;
                        }
                        if (!(Math.abs(w) > 2.0) && (z = u * this.theCamera.getObjectToView().timesZ(vt[ed[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[ed[i].v2].r)) < closestz) {
                            which = i;
                            closestz = z;
                            sel = this.selected[i];
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < fc.length) {
                if (this.visible[fc[i].v1] && this.visible[fc[i].v2] && this.visible[fc[i].v3] && (!sel || this.selected[i])) {
                    Point v1 = this.screenVert[fc[i].v1];
                    Point v2 = this.screenVert[fc[i].v2];
                    Point v3 = this.screenVert[fc[i].v3];
                    if (!(pos.x < v1.x - 2 && pos.x < v2.x - 2 && pos.x < v3.x - 2 || pos.x > v1.x + 2 && pos.x > v2.x + 2 && pos.x > v3.x + 2 || pos.y < v1.y - 2 && pos.y < v2.y - 2 && pos.y < v3.y - 2 || pos.y > v1.y + 2 && pos.y > v2.y + 2 && pos.y > v3.y + 2)) {
                        double z;
                        double u;
                        double w;
                        double denom;
                        double v;
                        double e1x = v1.x - v2.x;
                        double e1y = v1.y - v2.y;
                        double e2x = v1.x - v3.x;
                        double e2y = v1.y - v3.y;
                        double vy = pos.y - v1.y;
                        double vx = pos.x - v1.x;
                        if (!((v = (e2x *= (denom = 1.0 / (e1x * e2y - e1y * e2x))) * vy - (e2y *= denom) * vx) < 0.0 || v > 1.0 || (w = vx * (e1y *= denom) - vy * (e1x *= denom)) < 0.0 || w > 1.0 || (u = 1.0 - v - w) < 0.0 || u > 1.0 || !((z = u * this.theCamera.getObjectToView().timesZ(vt[fc[i].v1].r) + v * this.theCamera.getObjectToView().timesZ(vt[fc[i].v2].r) + w * this.theCamera.getObjectToView().timesZ(vt[fc[i].v3].r)) < closestz))) {
                            which = i;
                            closestz = z;
                            sel = this.selected[i];
                        }
                    }
                }
                ++i;
            }
        }
        return which;
    }
}

