/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.Camera;
import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.text.NumberFormat;
import java.util.Enumeration;

public class AnimationPreviewer
implements Runnable {
    LayoutWindow window;
    double originalTime;
    ValueField widthField;
    ValueField heightField;
    ValueField startField;
    ValueField endField;
    ValueField fpsField;
    Label timeLabel;
    Label frameLabel;
    Scene theScene;
    ObjectInfo sceneCamera;
    Choice camChoice;
    Canvas canvas;
    Thread previewThread;
    Dialog display;
    Image theImage;
    Graphics imageGraphics;
    Graphics canvasGraphics;
    byte[][] imageData;
    int[] sourceData;
    MemoryImageSource imSource;
    NumberFormat format;
    static int currentCamera = 0;
    static int width = 320;
    static int height = 240;
    static int fps = 15;
    static double startTime = 0.0;
    static double endTime = 1.0;

    public AnimationPreviewer(LayoutWindow parent) {
        ObjectInfo obj;
        this.window = parent;
        this.theScene = this.window.getScene();
        int i = 0;
        int count = 0;
        while (i < this.theScene.getNumObjects()) {
            obj = this.theScene.getObject(i);
            if (obj.object instanceof SceneCamera) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            new MessageDialog((Frame)this.window, "A scene must contain a camera to be rendered.");
            return;
        }
        if (count <= currentCamera) {
            currentCamera = 0;
        }
        ObjectInfo[] cameras = new ObjectInfo[count];
        i = 0;
        count = 0;
        while (i < this.theScene.getNumObjects()) {
            obj = this.theScene.getObject(i);
            if (obj.object instanceof SceneCamera) {
                cameras[count++] = obj;
            }
            ++i;
        }
        this.camChoice = new Choice();
        i = 0;
        while (i < cameras.length) {
            this.camChoice.add(cameras[i].name);
            ++i;
        }
        this.camChoice.select(currentCamera);
        this.widthField = new ValueField((double)width, 7);
        this.heightField = new ValueField((double)height, 7);
        this.startField = new ValueField(startTime, 0);
        this.endField = new ValueField(endTime, 0);
        this.fpsField = new ValueField(fps, 7);
        ComponentsDialog dlg = new ComponentsDialog((Frame)this.window, "Render Wireframe Preview", new Component[]{this.camChoice, this.startField, this.endField, this.widthField, this.heightField, this.fpsField}, new String[]{"Camera", "Start Time", "End Time", "Width", "Height", "Frames/Sec"});
        if (!dlg.clickedOk()) {
            return;
        }
        currentCamera = this.camChoice.getSelectedIndex();
        this.sceneCamera = cameras[currentCamera];
        width = (int)this.widthField.getValue();
        height = (int)this.heightField.getValue();
        startTime = this.startField.getValue();
        endTime = this.endField.getValue();
        fps = (int)this.fpsField.getValue();
        this.originalTime = this.theScene.getTime();
        this.display = new Dialog(this.window, "Preview", true);
        this.format = NumberFormat.getNumberInstance();
        this.format.setMaximumFractionDigits(3);
        Panel p = new Panel();
        p.setLayout(new GridLayout(2, 0));
        this.timeLabel = new Label();
        p.add(this.timeLabel);
        this.frameLabel = new Label();
        p.add(this.frameLabel);
        this.display.add((Component)p, "North");
        this.canvas = new Canvas(){

            public Dimension getPreferredSize() {
                return new Dimension(width, height);
            }
        };
        this.display.add((Component)this.canvas, "Center");
        p = new Panel();
        Button b = new Button("Done");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AnimationPreviewer.this.previewThread.interrupt();
                try {
                    AnimationPreviewer.this.previewThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AnimationPreviewer.this.theScene.setTime(AnimationPreviewer.this.originalTime);
                AnimationPreviewer.this.canvasGraphics.dispose();
                AnimationPreviewer.this.imageGraphics.dispose();
                AnimationPreviewer.this.display.dispose();
            }
        });
        p.add(b);
        this.display.add((Component)p, "South");
        this.display.pack();
        this.theImage = this.canvas.createImage(width, height);
        this.canvasGraphics = this.canvas.getGraphics();
        this.imageGraphics = this.theImage.getGraphics();
        this.previewThread = new Thread(this);
        this.previewThread.start();
        this.display.show();
    }

    public void run() {
        long ms;
        int totalFrames = (int)Math.ceil((endTime - startTime) * (double)fps);
        if (totalFrames <= 0) {
            totalFrames = 1;
        }
        int dataSize = (int)Math.ceil((double)(width * height) / 8.0);
        this.imageData = new byte[totalFrames][dataSize];
        Camera cam = new Camera();
        cam.setSize(width, height);
        long lastUpdate = 0L;
        long delay = 1000 / fps;
        int i = 0;
        while (i < totalFrames) {
            double time = startTime + (double)i / (double)fps;
            this.setLabels(time, i);
            this.theScene.setTime(time);
            SceneCamera sc = (SceneCamera)this.sceneCamera.object;
            cam.setCameraCoordinates(this.sceneCamera.coords.duplicate());
            cam.setDistToScreen((double)height / 200.0 / Math.tan(sc.getFieldOfView() * Math.PI / 360.0));
            this.imageGraphics.setColor(Color.white);
            this.imageGraphics.fillRect(0, 0, width, height);
            this.imageGraphics.setColor(Color.black);
            int j = 0;
            while (j < this.theScene.getNumObjects()) {
                ObjectInfo obj = this.theScene.getObject(j);
                if (obj.visible) {
                    this.drawObject(obj, cam, this.imageGraphics);
                }
                ++j;
            }
            this.canvasGraphics.drawImage(this.theImage, 0, 0, null);
            this.recordImage(this.imageData[i]);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ms = System.currentTimeMillis();
            if (ms < lastUpdate + delay) {
                try {
                    Thread.sleep(lastUpdate + delay - ms);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            lastUpdate = System.currentTimeMillis();
            ++i;
        }
        this.sourceData = new int[width * height];
        this.imSource = new MemoryImageSource(width, height, this.sourceData, 0, width);
        this.imSource.setAnimated(true);
        this.theImage = Toolkit.getDefaultToolkit().createImage(this.imSource);
        while (!Thread.currentThread().isInterrupted()) {
            int i2 = 0;
            while (i2 < totalFrames) {
                double time = startTime + (double)i2 / (double)fps;
                this.setLabels(time, i2);
                this.retrieveImage(this.imageData[i2]);
                this.canvasGraphics.drawImage(this.theImage, 0, 0, null);
                ms = System.currentTimeMillis();
                if (ms < lastUpdate + delay) {
                    try {
                        Thread.sleep(lastUpdate + delay - ms);
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                lastUpdate = System.currentTimeMillis();
                ++i2;
            }
        }
    }

    private void drawObject(ObjectInfo obj, Camera cam, Graphics g) {
        if (obj.object instanceof ObjectCollection) {
            Enumeration enumeration = ((ObjectCollection)obj.object).getObjects(obj, true, this.theScene);
            while (enumeration.hasMoreElements()) {
                ObjectInfo info = (ObjectInfo)enumeration.nextElement();
                CoordinateSystem coords = info.coords.duplicate();
                coords.transformCoordinates(obj.coords.fromLocal());
                cam.setObjectTransform(coords.fromLocal());
                info.draw(g, cam);
            }
            return;
        }
        cam.setObjectTransform(obj.coords.fromLocal());
        obj.draw(g, cam);
    }

    private void setLabels(double time, int frame) {
        this.timeLabel.setText("Time: " + this.format.format(time));
        this.frameLabel.setText("Frame: " + (frame + 1));
        this.timeLabel.getParent().validate();
    }

    private void recordImage(byte[] bytes) {
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(this.theImage, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return;
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] != -1) {
                int i1 = i / 8;
                int i2 = i & 7;
                int n = i1;
                bytes[n] = (byte)(bytes[n] | 1 << i2);
            }
            ++i;
        }
    }

    public void retrieveImage(byte[] bytes) {
        int i = 0;
        while (i < this.sourceData.length) {
            int i1 = i / 8;
            int i2 = i & 7;
            this.sourceData[i] = (bytes[i1] & 1 << i2) == 0 ? -1 : -16777216;
            ++i;
        }
        this.imSource.newPixels();
    }
}

