/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayKeyframe
implements Keyframe {
    public double[] val;

    public ArrayKeyframe(double[] values) {
        this.val = values;
    }

    public Keyframe duplicate() {
        return new ArrayKeyframe(this.val);
    }

    public Keyframe duplicate(Object owner) {
        return new ArrayKeyframe(this.val);
    }

    public double[] getGraphValues() {
        return this.val;
    }

    public void setGraphValues(double[] values) {
        this.val = new double[values.length];
        System.arraycopy(values, 0, this.val, 0, values.length);
    }

    public Keyframe blend(Keyframe o2, double weight1, double weight2) {
        double[] d = new double[this.val.length];
        ArrayKeyframe key2 = (ArrayKeyframe)o2;
        int i = 0;
        while (i < this.val.length) {
            d[i] = weight1 * this.val[i] + weight2 * key2.val[i];
            ++i;
        }
        return new ArrayKeyframe(d);
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
        double[] d = new double[this.val.length];
        ArrayKeyframe key2 = (ArrayKeyframe)o2;
        ArrayKeyframe key3 = (ArrayKeyframe)o3;
        int i = 0;
        while (i < this.val.length) {
            d[i] = weight1 * this.val[i] + weight2 * key2.val[i] + weight3 * key3.val[i];
            ++i;
        }
        return new ArrayKeyframe(d);
    }

    public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
        double[] d = new double[this.val.length];
        ArrayKeyframe key2 = (ArrayKeyframe)o2;
        ArrayKeyframe key3 = (ArrayKeyframe)o3;
        ArrayKeyframe key4 = (ArrayKeyframe)o4;
        int i = 0;
        while (i < this.val.length) {
            d[i] = weight1 * this.val[i] + weight2 * key2.val[i] + weight3 * key3.val[i] + weight4 * key4.val[i];
            ++i;
        }
        return new ArrayKeyframe(d);
    }

    public boolean equals(Keyframe k) {
        if (!(k instanceof ArrayKeyframe)) {
            return false;
        }
        ArrayKeyframe key = (ArrayKeyframe)k;
        int i = 0;
        while (i < this.val.length) {
            if (this.val[i] != key.val[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeShort(this.val.length);
        int i = 0;
        while (i < this.val.length) {
            out.writeDouble(this.val[i]);
            ++i;
        }
    }

    public ArrayKeyframe(DataInputStream in, Object parent) throws IOException {
        this.val = new double[in.readShort()];
        int i = 0;
        while (i < this.val.length) {
            this.val[i] = in.readDouble();
            ++i;
        }
    }
}

