/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.SVD;
import artofillusion.math.Vec3;
import java.util.Vector;

public class IKSolver {
    private Skeleton skeleton;
    private Joint[] joint;
    private Joint anchor;
    private Joint center;
    private boolean justDrag;

    public IKSolver(Skeleton s, int baseID, int selectedID) {
        int k;
        this.skeleton = s;
        if (baseID == selectedID || this.skeleton.getJoint(baseID) == null) {
            this.anchor = this.skeleton.getJoint(selectedID);
            this.joint = IKSolver.findConnectedJoints(this.anchor);
            this.justDrag = true;
            return;
        }
        Vector<Joint> v1 = new Vector<Joint>();
        Vector<Joint> v2 = new Vector<Joint>();
        Joint jt = this.skeleton.getJoint(selectedID);
        while (jt != null) {
            v1.addElement(jt);
            jt = jt.parent;
        }
        jt = this.skeleton.getJoint(baseID);
        while (jt != null) {
            v2.addElement(jt);
            jt = jt.parent;
        }
        boolean needAnchor = false;
        int i = v1.size() - 1;
        int j = v2.size() - 1;
        while (i >= 0 && j >= 0 && v1.elementAt(i) == v2.elementAt(j)) {
            --i;
            --j;
        }
        if (i == -1) {
            this.joint = new Joint[j + 3];
            k = j + 1;
            while (k >= 0) {
                this.joint[k + 1] = (Joint)v2.elementAt(k);
                --k;
            }
            needAnchor = true;
        } else if (j == -1) {
            this.joint = new Joint[i + 2];
            k = i + 1;
            while (k >= 0) {
                this.joint[i + 1 - k] = (Joint)v1.elementAt(k);
                --k;
            }
        } else {
            if (i == v1.size() - 1) {
                this.anchor = (Joint)v1.elementAt(0);
                this.joint = IKSolver.findConnectedJoints(this.anchor);
                this.justDrag = true;
                return;
            }
            this.joint = new Joint[i + j + 4];
            int m = 1;
            int k2 = 0;
            while (k2 <= j) {
                this.joint[m] = (Joint)v2.elementAt(k2);
                ++k2;
                ++m;
            }
            int k3 = i + 1;
            while (k3 >= 0) {
                this.joint[m] = (Joint)v1.elementAt(k3);
                --k3;
                ++m;
            }
            this.center = this.joint[j + 2];
            needAnchor = true;
        }
        if (needAnchor) {
            CoordinateSystem c = this.joint[1].coords;
            this.joint[0] = this.anchor = new Joint(new CoordinateSystem(c.getOrigin().plus(c.getZDirection()), new Vec3(c.getZDirection()), new Vec3(c.getUpDirection())), this.joint[1], "");
        }
    }

    private static Joint[] findConnectedJoints(Joint j) {
        while (j.parent != null) {
            j = j.parent;
        }
        Vector v = new Vector();
        IKSolver.addToVector(j, v);
        Object[] jt = new Joint[v.size()];
        v.copyInto(jt);
        return jt;
    }

    private static void addToVector(Joint j, Vector v) {
        v.addElement(j);
        int i = 0;
        while (i < j.children.length) {
            IKSolver.addToVector(j.children[i], v);
            ++i;
        }
    }

    public Joint getDraggedJoint() {
        return this.joint[this.joint.length - 1];
    }

    public void solve(Vec3 goal) {
        if (this.justDrag) {
            Vec3 offset = goal.minus(this.anchor.coords.getOrigin());
            int i = 0;
            while (i < this.joint.length) {
                this.joint[i].coords.setOrigin(this.joint[i].coords.getOrigin().plus(offset));
                ++i;
            }
            return;
        }
        Joint last = this.joint[this.joint.length - 1];
        double lastDist = last.coords.getOrigin().distance(goal);
        double maxScale = 1.0;
        int count = 0;
        do {
            this.step(goal, maxScale);
            double dist = last.coords.getOrigin().distance(goal);
            if (dist > lastDist) {
                maxScale *= 0.5;
            } else if (count > 1 && (dist < 1.0E-4 || lastDist - dist < 1.0E-4)) break;
            lastDist = dist;
        } while (++count < 100);
    }

    /*
     * Unable to fully structure code
     */
    private void step(Vec3 goal, double maxScale) {
        fpos = this.joint[this.joint.length - 1].coords.getOrigin();
        diff = goal.minus(fpos);
        grad = new Vec3();
        offset = this.anchor != null;
        f = new double[this.joint[this.joint.length - 1].parent == this.joint[this.joint.length - 2] ? this.joint.length : this.joint.length - 1][4];
        dofgrad = new Vec3[f.length * 4];
        i = 1;
        while (i < f.length) {
            j = this.joint[i];
            parent = this.joint[i - 1];
            coords = j.coords;
            pos = coords.getOrigin();
            zdir = coords.getZDirection();
            updir = coords.getUpDirection();
            if (j.parent == parent) {
                if (!j.length.fixed) {
                    dofgrad[i * 4] = zdir;
                }
            } else if (!parent.length.fixed) {
                dofgrad[(i - 1) * 4] = zdir;
            }
            if (j.parent == parent) {
                r = fpos.minus(parent.coords.getOrigin());
                r = parent.coords.toLocal().timesDirection(r);
                r = j.getInverseTransform().timesDirection(r);
                c1 = Math.cos(j.angle1.pos * 3.141592653589793 / 180.0);
                s1 = Math.sin(j.angle1.pos * 3.141592653589793 / 180.0);
                c2 = Math.cos(j.angle2.pos * 3.141592653589793 / 180.0);
                s2 = Math.sin(j.angle2.pos * 3.141592653589793 / 180.0);
                ct = Math.cos(j.twist.pos * 3.141592653589793 / 180.0);
                st = Math.sin(j.twist.pos * 3.141592653589793 / 180.0);
                if (!j.angle1.fixed) {
                    dofgrad[i * 4 + 1] = new Vec3(c1 * s2 * st * r.x + c1 * s2 * ct * r.y - s1 * s2 * r.z, -s1 * st * r.x - s1 * ct * r.y - c1 * r.z, c1 * c2 * st * r.x + c1 * c2 * ct * r.y - s1 * c2 * r.z);
                    parent.coords.fromLocal().transformDirection(dofgrad[i * 4 + 1]);
                }
                if (!j.angle2.fixed) {
                    dofgrad[i * 4 + 2] = new Vec3((s1 * c2 * st - s2 * ct) * r.x + (s1 * c2 * ct + s2 * st) * r.y + c1 * c2 * r.z, 0.0, -(c2 * ct + s1 * s2 * st) * r.x + (c2 * st - s1 * s2 * ct) * r.y - c1 * s2 * r.z);
                    parent.coords.fromLocal().transformDirection(dofgrad[i * 4 + 2]);
                }
                if (!j.twist.fixed) {
                    dofgrad[i * 4 + 3] = new Vec3((s1 * s2 * ct - c2 * st) * r.x - (c2 * ct + s1 * s2 * st) * r.y, c1 * ct * r.x - c1 * st * r.y, (s1 * c2 * ct + s2 * st) * r.x + (s2 * ct - s1 * c2 * st) * r.y);
                    parent.coords.fromLocal().transformDirection(dofgrad[i * 4 + 3]);
                }
            } else {
                r = this.joint[0].coords.getOrigin().minus(j.coords.getOrigin());
                r = j.coords.toLocal().timesDirection(r);
                r = parent.getInverseTransform().timesDirection(r);
                c1 = Math.cos(parent.angle1.pos * 3.141592653589793 / 180.0);
                s1 = Math.sin(parent.angle1.pos * 3.141592653589793 / 180.0);
                c2 = Math.cos(parent.angle2.pos * 3.141592653589793 / 180.0);
                s2 = Math.sin(parent.angle2.pos * 3.141592653589793 / 180.0);
                ct = Math.cos(parent.twist.pos * 3.141592653589793 / 180.0);
                st = Math.sin(parent.twist.pos * 3.141592653589793 / 180.0);
                if (!parent.angle1.fixed) {
                    dofgrad[(i - 1) * 4 + 1] = new Vec3(c1 * s2 * st * r.x + c1 * s2 * ct * r.y - s1 * s2 * r.z, -s1 * st * r.x - s1 * ct * r.y - c1 * r.z, c1 * c2 * st * r.x + c1 * c2 * ct * r.y - s1 * c2 * r.z);
                    parent.getInverseTransform().transformDirection(dofgrad[(i - 1) * 4 + 1]);
                    j.coords.fromLocal().transformDirection(dofgrad[(i - 1) * 4 + 1]);
                }
                if (!parent.angle2.fixed) {
                    dofgrad[(i - 1) * 4 + 2] = new Vec3((s1 * c2 * st - s2 * ct) * r.x + (s1 * c2 * ct + s2 * st) * r.y + c1 * c2 * r.z, 0.0, -(c2 * ct + s1 * s2 * st) * r.x + (c2 * st - s1 * s2 * ct) * r.y - c1 * s2 * r.z);
                    parent.getInverseTransform().transformDirection(dofgrad[(i - 1) * 4 + 2]);
                    j.coords.fromLocal().transformDirection(dofgrad[(i - 1) * 4 + 2]);
                }
                if (!parent.twist.fixed) {
                    dofgrad[(i - 1) * 4 + 3] = new Vec3((s1 * s2 * ct - c2 * st) * r.x - (c2 * ct + s1 * s2 * st) * r.y, c1 * ct * r.x - c1 * st * r.y, (s1 * c2 * ct + s2 * st) * r.x + (s2 * ct - s1 * c2 * st) * r.y);
                    parent.getInverseTransform().transformDirection(dofgrad[(i - 1) * 4 + 3]);
                    j.coords.fromLocal().transformDirection(dofgrad[(i - 1) * 4 + 3]);
                }
            }
            ++i;
        }
        numDOF = 0;
        index = new int[dofgrad.length];
        dofscale = new double[dofgrad.length];
        i = 0;
        while (i < dofgrad.length) {
            if (dofgrad[i] == null || !((dot = dofgrad[i].dot(diff)) > 1.0E-10) && !(dot < -1.0E-10)) ** GOTO lbl-1000
            jointnum = i / 4;
            dofnum = i % 4;
            dofscale[i] = dofnum == 0 ? this.joint[jointnum].length.getForceScale(dot) : (dofnum == 1 ? this.joint[jointnum].angle1.getForceScale(dot) : (dofnum == 2 ? this.joint[jointnum].angle2.getForceScale(dot) : this.joint[jointnum].twist.getForceScale(dot)));
            if (dofscale[i] > 0.0) {
                index[i] = numDOF++;
            } else lbl-1000:
            // 2 sources

            {
                index[i] = -1;
            }
            ++i;
        }
        if (numDOF == 0) {
            return;
        }
        mat = new double[3][numDOF];
        a = new double[numDOF > 3 ? numDOF : 3];
        numDOF = 0;
        i = 0;
        while (i < dofgrad.length) {
            if (index[i] != -1) {
                div = 1.0 / dofscale[i];
                mat[0][numDOF] = dofgrad[i].x * div;
                mat[1][numDOF] = dofgrad[i].y * div;
                mat[2][numDOF] = dofgrad[i].z * div;
                ++numDOF;
            }
            ++i;
        }
        a[0] = diff.x;
        a[1] = diff.y;
        a[2] = diff.z;
        SVD.solve(mat, a, 0.01);
        i = 0;
        while (i < f.length) {
            j = 0;
            while (j < 4) {
                k = i * 4 + j;
                if (index[k] != -1) {
                    f[i][j] = a[index[k]] * dofscale[k];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < f.length) {
            j = this.joint[i];
            if (f[i][0] > 0.0 && !j.length.loop && j.length.pos == j.length.max) {
                f[i][0] = 0.0;
            }
            if (f[i][0] < 0.0 && !j.length.loop && j.length.pos == j.length.min) {
                f[i][0] = 0.0;
            }
            if (f[i][1] > 0.0 && !j.angle1.loop && j.angle1.pos == j.angle1.max) {
                f[i][1] = 0.0;
            }
            if (f[i][1] < 0.0 && !j.angle1.loop && j.angle1.pos == j.angle1.min) {
                f[i][1] = 0.0;
            }
            if (f[i][2] > 0.0 && !j.angle2.loop && j.angle2.pos == j.angle2.max) {
                f[i][2] = 0.0;
            }
            if (f[i][2] < 0.0 && !j.angle2.loop && j.angle2.pos == j.angle2.min) {
                f[i][2] = 0.0;
            }
            if (f[i][3] > 0.0 && !j.twist.loop && j.twist.pos == j.twist.max) {
                f[i][3] = 0.0;
            }
            if (f[i][3] < 0.0 && !j.twist.loop && j.twist.pos == j.twist.min) {
                f[i][3] = 0.0;
            }
            ++i;
        }
        max = 0.0;
        i = 0;
        while (i < f.length) {
            j = 1;
            while (j < 4) {
                v0 = g = f[i][j] < 0.0 ? -f[i][j] : f[i][j];
                if (g > max) {
                    max = g;
                }
                ++j;
            }
            ++i;
        }
        scale = maxScale * (max > 0.2 ? 0.2 / max : 0.2);
        i = 0;
        while (i < f.length) {
            j = 0;
            while (j < f[i].length) {
                v1 = f[i];
                v2 = j++;
                v1[v2] = v1[v2] * scale;
            }
            ++i;
        }
        i = 0;
        while (i < f.length) {
            j = this.joint[i];
            f[i][0] = j.length.getClippedForce(f[i][0]);
            f[i][1] = j.angle1.getClippedForce(f[i][1] * 180.0 / 3.141592653589793);
            f[i][2] = j.angle2.getClippedForce(f[i][2] * 180.0 / 3.141592653589793);
            f[i][3] = j.twist.getClippedForce(f[i][3] * 180.0 / 3.141592653589793);
            ++i;
        }
        i = 0;
        while (i < f.length) {
            j = this.joint[i];
            if (j != this.center) {
                if (!j.twist.fixed) {
                    j.twist.pos += f[i][3];
                }
                if (!j.length.fixed) {
                    j.length.set(j.length.pos + f[i][0]);
                }
                if (!j.angle1.fixed) {
                    j.angle1.set(j.angle1.pos + f[i][1]);
                }
                if (!j.angle2.fixed) {
                    j.angle2.set(j.angle2.pos + f[i][2]);
                }
            }
            ++i;
        }
        if (this.anchor != null) {
            i = 0;
            while (i < this.joint[1].children.length) {
                j = this.joint[1].children[i];
                if (!j.length.fixed) {
                    j.length.set(j.length.pos + f[0][0]);
                }
                if (!j.angle1.fixed) {
                    j.angle1.set(j.angle1.pos + f[0][1]);
                }
                if (!j.angle2.fixed) {
                    j.angle2.set(j.angle2.pos + f[0][2]);
                }
                if (!j.twist.fixed) {
                    j.twist.set(j.twist.pos + f[0][3]);
                }
                ++i;
            }
        }
        if (this.anchor == null) {
            this.joint[0].recalcCoords(true);
        } else {
            m = this.anchor.coords.fromLocal();
            if (this.center == null) {
                this.joint[this.joint.length - 2].recalcCoords(true);
            } else {
                this.center.recalcCoords(true);
            }
            this.anchor.recalcCoords(false);
            m = m.times(this.anchor.coords.toLocal());
            all = this.skeleton.getJoints();
            i = 0;
            while (i < all.length) {
                all[i].coords.transformCoordinates(m);
                ++i;
            }
            this.anchor.coords.transformCoordinates(m);
        }
    }

    private void clip(Vec3 v) {
        if (v.x > -1.0E-10 && v.x < 1.0E-10) {
            v.x = 0.0;
        }
        if (v.y > -1.0E-10 && v.y < 1.0E-10) {
            v.y = 0.0;
        }
        if (v.z > -1.0E-10 && v.z < 1.0E-10) {
            v.z = 0.0;
        }
    }
}

