/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.VectorKeyframe;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class PositionTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;
    int smoothingMethod;
    int mode;
    int relCoords;
    int joint;
    ObjectRef relObject;
    WeightTrack theWeight;
    boolean enablex;
    boolean enabley;
    boolean enablez;
    private static final int ABSOLUTE = 0;
    private static final int RELATIVE = 1;
    private static final int WORLD = 0;
    private static final int PARENT = 1;
    private static final int OBJECT = 2;
    private static final int LOCAL = 3;

    public PositionTrack(ObjectInfo info) {
        super("Position");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 1;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.enablez = true;
        this.enabley = true;
        this.enablex = true;
        this.joint = -1;
    }

    public void apply(double time) {
        Joint j;
        Vec3 pos = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        double weight = this.theWeight.getWeight(time);
        if (pos == null) {
            return;
        }
        Vec3 v = this.info.coords.getOrigin();
        if (this.mode == 0) {
            double w = 1.0 - weight;
            if (this.enablex) {
                v.x *= w;
            }
            if (this.enabley) {
                v.y *= w;
            }
            if (this.enablez) {
                v.z *= w;
            }
        }
        if (this.mode == 0 && this.relCoords == 1) {
            if (this.info.parent != null) {
                pos = this.info.parent.coords.fromLocal().times(pos);
            }
        } else if (this.mode == 0 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().times(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 1) {
            if (this.info.parent != null) {
                pos = this.info.parent.coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pos = this.info.coords.fromLocal().timesDirection(pos);
        }
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            if (this.info.pose != null && !this.info.pose.equals(this.info.object.getPoseKeyframe())) {
                this.info.object.applyPoseKeyframe(this.info.pose);
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            pos = pos.minus(new ObjectRef(this.info, j).getCoords().getOrigin());
            pos.add(this.info.coords.getOrigin());
        }
        if (this.enablex) {
            v.x += pos.x * weight;
        }
        if (this.enabley) {
            v.y += pos.y * weight;
        }
        if (this.enablez) {
            v.z += pos.z * weight;
        }
        this.info.coords.setOrigin(v);
    }

    public Track duplicate(Object obj) {
        PositionTrack t = new PositionTrack((ObjectInfo)obj);
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.enablex = this.enablex;
        t.enabley = this.enabley;
        t.enablez = this.enablez;
        t.joint = this.joint;
        return t;
    }

    public void copy(Track tr) {
        PositionTrack t = (PositionTrack)tr;
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.enablex = t.enablex;
        this.enabley = t.enabley;
        this.enablez = t.enablez;
        this.joint = t.joint;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        Vec3 pos = this.info.coords.getOrigin();
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            pos = new ObjectRef(this.info, j).getCoords().getOrigin();
        }
        if (this.relCoords == 1) {
            if (this.info.parent != null) {
                pos = this.info.parent.coords.toLocal().times(pos);
            }
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            pos = coords.toLocal().times(pos);
        }
        VectorKeyframe k = new VectorKeyframe(pos);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        CoordinateSystem coords;
        Joint j;
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        VectorKeyframe pos = (VectorKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        Vec3 current = this.info.coords.getOrigin();
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            current = new ObjectRef(this.info, j).getCoords().getOrigin();
        }
        if (this.relCoords == 1) {
            if (this.info.parent != null) {
                current = this.info.parent.coords.toLocal().times(current);
            }
        } else if (this.relCoords == 2 && (coords = this.relObject.getCoords()) != null) {
            current = coords.toLocal().times(current);
        }
        boolean change = false;
        if (this.enablex && Math.abs(pos.x - current.x) > 1.0E-10 || this.enabley && Math.abs(pos.y - current.y) > 1.0E-10 || this.enablez && Math.abs(pos.z - current.z) > 1.0E-10) {
            return this.setKeyframe(time, sc);
        }
        return null;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public boolean affectsX() {
        return this.enablex;
    }

    public boolean affectsY() {
        return this.enabley;
    }

    public boolean affectsZ() {
        return this.enablez;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public int getCoordinateSystem() {
        return this.relCoords;
    }

    public void setCoordinateSystem(int system) {
        this.relCoords = system;
    }

    public ObjectRef getCoordsObject() {
        return this.relObject;
    }

    public void setCoordsObject(ObjectRef obj) {
        this.relObject = obj;
        this.relCoords = 2;
    }

    public String[] getValueNames() {
        return new String[]{"X", "Y", "Z"};
    }

    public double[] getDefaultGraphValues() {
        Vec3 pos = this.info.coords.getOrigin();
        return new double[]{pos.x, pos.y, pos.z};
    }

    public double[][] getValueRange() {
        double[][] range = new double[3][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = -1.7976931348623157E308;
            range[i][1] = Double.MAX_VALUE;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        ObjectInfo info;
        if (this.relCoords == 2 && (info = this.relObject.getObject()) != null) {
            return new ObjectInfo[]{info};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeBoolean(this.enablex);
        out.writeBoolean(this.enabley);
        out.writeBoolean(this.enablez);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            ((VectorKeyframe)v[i]).writeToFile(out);
            s[i].writeToStream(out);
            ++i;
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public PositionTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        this.enablex = in.readBoolean();
        this.enabley = in.readBoolean();
        this.enablez = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new VectorKeyframe(new Vec3(in));
            s[i] = new Smoothness(in);
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight = new WeightTrack(in, this, scene);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        VectorKeyframe key = (VectorKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField xField = new ValueField(key.x, 0, 5);
        ValueField yField = new ValueField(key.y, 0, 5);
        ValueField zField = new ValueField(key.z, 0, 5);
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (" + Translate.text("left") + ")");
        final Label rightLabel = new Label(" (" + Translate.text("right") + ")");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)new Label("X"), gc);
        p.add((Component)new Label("Y"), gc);
        p.add((Component)new Label("Z"), gc);
        p.add((Component)new Label(Translate.text("Time")), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)xField, gc);
        p.add((Component)yField, gc);
        p.add((Component)zField, gc);
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label(Translate.text("Smoothness") + ':'), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Frame)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.x = xField.getValue();
        key.y = yField.getValue();
        key.z = zField.getValue();
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        TextField nameField = new TextField(this.getName());
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        final Choice modeChoice = new Choice();
        modeChoice.add("Absolute");
        modeChoice.add("Relative");
        modeChoice.select(this.mode);
        Choice jointChoice = new Choice();
        jointChoice.add("Object Origin");
        if (j != null) {
            int i = 0;
            while (i < j.length) {
                jointChoice.add(j[i].name);
                ++i;
            }
            int i2 = 0;
            while (i2 < j.length) {
                if (j[i2].id == this.joint) {
                    jointChoice.select(i2 + 1);
                }
                ++i2;
            }
        }
        final Choice coordsChoice = new Choice();
        coordsChoice.add("World");
        coordsChoice.add("Parent");
        coordsChoice.add("Other Object...");
        if (this.mode == 1) {
            coordsChoice.add("Local");
        }
        coordsChoice.select(this.relCoords);
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, win, "Position Relative To:", this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add("Local");
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        Checkbox xbox = new Checkbox("X", this.enablex);
        p.add(xbox);
        Checkbox ybox = new Checkbox("Y", this.enabley);
        p.add(ybox);
        Checkbox zbox = new Checkbox("Z", this.enablez);
        p.add(zbox);
        ComponentsDialog dlg = new ComponentsDialog((Frame)win, "Options for Position Track", new Component[]{nameField, smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector, p}, new String[]{"Track Name:", "Smoothing Method:", "Track Mode:", "Apply To:", "Coordinate System:", "", "Track Affects:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        this.setName(nameField.getText());
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
        this.enablex = xbox.getState();
        this.enabley = ybox.getState();
        this.enablez = zbox.getState();
    }
}

