/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.UndoRecord;
import artofillusion.animation.ArrayKeyframe;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.ObjectRef;
import artofillusion.animation.ObjectRefSelector;
import artofillusion.animation.Skeleton;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.animation.WeightTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import artofillusion.procedural.Procedure;
import artofillusion.procedural.ProcedureEditor;
import artofillusion.procedural.ProcedureOwner;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueChecker;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProceduralPositionTrack
extends Track
implements ProcedureOwner {
    ObjectInfo info;
    Procedure proc;
    Timecourse tc;
    TextureParameter[] parameter;
    int smoothingMethod;
    int mode;
    int relCoords;
    int joint;
    ObjectRef relObject;
    WeightTrack theWeight;
    private static final int ABSOLUTE = 0;
    private static final int RELATIVE = 1;
    private static final int WORLD = 0;
    private static final int PARENT = 1;
    private static final int OBJECT = 2;
    private static final int LOCAL = 3;

    public ProceduralPositionTrack(ObjectInfo info) {
        super("Position (procedural)");
        this.info = info;
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "0", 0.0, null, 0), new OutputModule("Y", "0", 0.0, null, 0), new OutputModule("Z", "0", 0.0, null, 0)});
        this.parameter = new TextureParameter[0];
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
        this.smoothingMethod = 2;
        this.mode = 0;
        this.relCoords = 0;
        this.relObject = new ObjectRef();
        this.theWeight = new WeightTrack(this);
        this.joint = -1;
    }

    public void apply(double time) {
        Joint j;
        PointInfo point = new PointInfo();
        Vec3 v = this.info.coords.getOrigin();
        Vec3 jointDelta = null;
        OutputModule[] output = this.proc.getOutputModules();
        point.x = v.x;
        point.y = v.y;
        point.z = v.z;
        if (this.joint > -1 && this.mode == 0 && (j = this.info.getSkeleton().getJoint(this.joint)) != null) {
            if (this.info.pose != null && !this.info.pose.equals(this.info.object.getPoseKeyframe())) {
                this.info.object.applyPoseKeyframe(this.info.pose);
                j = this.info.getSkeleton().getJoint(this.joint);
            }
            jointDelta = new ObjectRef(this.info, j).getCoords().getOrigin().minus(this.info.coords.getOrigin());
            point.x += jointDelta.x;
            point.y += jointDelta.y;
            point.z += jointDelta.z;
        }
        point.t = time;
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params != null) {
            point.param = params.val;
        }
        this.proc.initForPoint(point);
        Vec3 pos = new Vec3(output[0].getAverageValue(0, 0.0), output[1].getAverageValue(0, 0.0), output[2].getAverageValue(0, 0.0));
        double weight = this.theWeight.getWeight(time);
        if (this.mode == 0) {
            double w = 1.0 - weight;
            v.x *= w;
            v.y *= w;
            v.z *= w;
        }
        if (this.mode == 0 && this.relCoords == 1) {
            if (this.info.parent != null) {
                pos = this.info.parent.coords.fromLocal().times(pos);
            }
        } else if (this.mode == 0 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().times(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 1) {
            if (this.info.parent != null) {
                pos = this.info.parent.coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 2) {
            CoordinateSystem coords = this.relObject.getCoords();
            if (coords != null) {
                pos = coords.fromLocal().timesDirection(pos);
            }
        } else if (this.mode == 1 && this.relCoords == 3) {
            pos = this.info.coords.fromLocal().timesDirection(pos);
        }
        if (jointDelta != null) {
            pos.subtract(jointDelta);
        }
        v.x += pos.x * weight;
        v.y += pos.y * weight;
        v.z += pos.z * weight;
        this.info.coords.setOrigin(v);
    }

    public Track duplicate(Object obj) {
        ProceduralPositionTrack t = new ProceduralPositionTrack((ObjectInfo)obj);
        t.proc.copy(this.proc);
        t.mode = this.mode;
        t.relCoords = this.relCoords;
        t.smoothingMethod = this.smoothingMethod;
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        t.relObject = this.relObject.duplicate();
        t.theWeight = (WeightTrack)this.theWeight.duplicate(t);
        t.joint = this.joint;
        return t;
    }

    public void copy(Track tr) {
        ProceduralPositionTrack t = (ProceduralPositionTrack)tr;
        this.proc.copy(t.proc);
        this.mode = t.mode;
        this.relCoords = t.relCoords;
        this.smoothingMethod = t.smoothingMethod;
        this.tc = t.tc.duplicate(this.info);
        this.relObject = t.relObject.duplicate();
        this.theWeight = (WeightTrack)t.theWeight.duplicate(this);
        this.joint = t.joint;
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        double[] p;
        if (this.parameter.length == 0) {
            return null;
        }
        ArrayKeyframe params = (ArrayKeyframe)this.tc.evaluate(time, this.smoothingMethod);
        if (params == null) {
            p = this.getDefaultGraphValues();
        } else {
            p = new double[params.val.length];
            System.arraycopy(params.val, 0, p, 0, p.length);
        }
        ArrayKeyframe k = new ArrayKeyframe(p);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return false;
    }

    public Track[] getSubtracks() {
        return new Track[]{this.theWeight};
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
    }

    public String[] getValueNames() {
        String[] names = new String[this.parameter.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.parameter[i].name;
            ++i;
        }
        return names;
    }

    public double[] getDefaultGraphValues() {
        double[] val = new double[this.parameter.length];
        int i = 0;
        while (i < val.length) {
            val[i] = this.parameter[i].defaultVal;
            ++i;
        }
        return val;
    }

    public double[][] getValueRange() {
        double[][] range = new double[this.parameter.length][2];
        int i = 0;
        while (i < range.length) {
            range[i][0] = this.parameter[i].minVal;
            range[i][1] = this.parameter[i].maxVal;
            ++i;
        }
        return range;
    }

    public ObjectInfo[] getDependencies() {
        ObjectInfo info;
        if (this.relCoords == 2 && (info = this.relObject.getObject()) != null) {
            return new ObjectInfo[]{info};
        }
        return new ObjectInfo[0];
    }

    public void deleteDependencies(ObjectInfo obj) {
        if (this.relObject.getObject() == obj) {
            this.relObject = new ObjectRef();
        }
    }

    private TextureParameter[] findParameters() {
        Module[] module = this.proc.getModules();
        int count = 0;
        int i = 0;
        while (i < module.length) {
            if (module[i] instanceof ParameterModule) {
                ++count;
            }
            ++i;
        }
        TextureParameter[] params = new TextureParameter[count];
        count = 0;
        int i2 = 0;
        while (i2 < module.length) {
            if (module[i2] instanceof ParameterModule) {
                params[count] = ((ParameterModule)module[i2]).getParameter(this);
                ((ParameterModule)module[i2]).setIndex(count++);
            }
            ++i2;
        }
        return params;
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Smoothness[] s = this.tc.getSmoothness();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(1);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        this.proc.writeToStream(out, scene);
        out.writeInt(this.smoothingMethod);
        out.writeInt(this.mode);
        out.writeInt(this.relCoords);
        out.writeInt(this.joint);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            ((ArrayKeyframe)v[i]).writeToStream(out);
            s[i].writeToStream(out);
            ++i;
        }
        if (this.relCoords == 2) {
            this.relObject.writeToStream(out);
        }
        this.theWeight.writeToStream(out, scene);
    }

    public ProceduralPositionTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        this.proc = new Procedure(new OutputModule[]{new OutputModule("X", "0", 0.0, null, 0), new OutputModule("Y", "0", 0.0, null, 0), new OutputModule("Z", "0", 0.0, null, 0)});
        this.proc.readFromStream(in, scene);
        this.smoothingMethod = in.readInt();
        this.mode = in.readInt();
        this.relCoords = in.readInt();
        this.joint = version == 0 ? -1 : in.readInt();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new ArrayKeyframe(in, this);
            s[i] = new Smoothness(in);
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
        this.relObject = this.relCoords == 2 ? new ObjectRef(in, scene) : new ObjectRef();
        this.theWeight = new WeightTrack(in, this, scene);
        this.parameter = this.findParameters();
    }

    public void editKeyframe(LayoutWindow win, int which) {
        ArrayKeyframe key = (ArrayKeyframe)this.tc.getValues()[which];
        Smoothness s = this.tc.getSmoothness()[which];
        double time = this.tc.getTimes()[which];
        ValueField[] valField = new ValueField[this.parameter.length];
        ValueSlider[] valSlider = new ValueSlider[this.parameter.length];
        ValueField timeField = new ValueField(time, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, s.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, s.getRightSmoothness());
        final Checkbox sameBox = new Checkbox("Separate Left and Right Smoothness", !s.isForceSame());
        final Label leftLabel = new Label(" (" + Translate.text("left") + ")");
        final Label rightLabel = new Label(" (" + Translate.text("right") + ")");
        Panel p = new Panel();
        GridBagConstraints gc = new GridBagConstraints();
        int i = 0;
        while (i < this.parameter.length) {
            if (this.parameter[i].minVal == -1.7976931348623157E308 || this.parameter[i].maxVal == Double.MAX_VALUE) {
                final TextureParameter tp = this.parameter[i];
                valField[i] = new ValueField(key.val[i], 0, 5);
                valField[i].setValueChecker(new ValueChecker(){

                    public boolean isValid(double v) {
                        return v >= tp.minVal && v <= tp.maxVal;
                    }
                });
            } else {
                valSlider[i] = new ValueSlider(this.parameter[i].minVal, this.parameter[i].maxVal, 50, key.val[i]);
            }
            ++i;
        }
        p.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        int i2 = 0;
        while (i2 < this.parameter.length) {
            p.add((Component)new Label(this.parameter[i2].name), gc);
            ++i2;
        }
        p.add((Component)new Label(Translate.text("Time")), gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        int i3 = 0;
        while (i3 < this.parameter.length) {
            if (valField[i3] != null) {
                p.add((Component)valField[i3], gc);
            } else {
                p.add((Component)valSlider[i3], gc);
            }
            ++i3;
        }
        p.add((Component)timeField, gc);
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.anchor = 10;
        p.add((Component)sameBox, gc);
        p.add((Component)new Label(Translate.text("Smoothness") + ':'), gc);
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.anchor = 13;
        gc.insets.right = 5;
        p.add((Component)leftLabel, gc);
        p.add((Component)rightLabel, gc);
        gc.gridx = 1;
        gc.anchor = 17;
        gc.insets.right = 0;
        p.add((Component)s1Slider, gc);
        p.add((Component)s2Slider, gc);
        leftLabel.setEnabled(sameBox.getState());
        rightLabel.setEnabled(sameBox.getState());
        s2Slider.setEnabled(sameBox.getState());
        sameBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                leftLabel.setEnabled(sameBox.getState());
                rightLabel.setEnabled(sameBox.getState());
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        PanelDialog dlg = new PanelDialog((Frame)win, "Edit Keyframe", p);
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        int i4 = 0;
        while (i4 < valField.length) {
            key.val[i4] = valField[i4] != null ? valField[i4].getValue() : valSlider[i4].getValue();
            ++i4;
        }
        if (sameBox.getState()) {
            s.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            s.setSmoothness(s1Slider.getValue());
        }
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        ProcedureEditor editor = new ProcedureEditor(this.proc, this, win.getScene());
        editor.setEditingWindow(win);
    }

    public String getWindowTitle() {
        return "Procedural Position Track";
    }

    public Object getPreview(ProcedureEditor editor) {
        return null;
    }

    public void updatePreview(Object preview) {
    }

    public void disposePreview(Object preview) {
    }

    public boolean allowParameters() {
        return true;
    }

    public boolean canEditName() {
        return true;
    }

    public void acceptEdits(ProcedureEditor editor) {
        EditingWindow win = editor.getEditingWindow();
        win.setUndoRecord(new UndoRecord(win, false, 2, new Object[]{this.info, this.info.duplicate()}));
        TextureParameter[] newparams = this.findParameters();
        int[] index = new int[newparams.length];
        int i = 0;
        while (i < newparams.length) {
            index[i] = -1;
            int j = 0;
            while (j < this.parameter.length) {
                if (this.parameter[j].equals(newparams[i])) {
                    index[i] = j;
                }
                ++j;
            }
            ++i;
        }
        this.parameter = newparams;
        Keyframe[] key = this.tc.getValues();
        int i2 = 0;
        while (i2 < key.length) {
            double[] newval = new double[this.parameter.length];
            int j = 0;
            while (j < newval.length) {
                newval[j] = index[j] > -1 ? ((ArrayKeyframe)key[i2]).val[index[j]] : this.parameter[j].defaultVal;
                ++j;
            }
            ((ArrayKeyframe)key[i2]).val = newval;
            ++i2;
        }
        ((LayoutWindow)win).getScore().finishEditingTrack(this);
    }

    public void editProperties(ProcedureEditor editor) {
        Skeleton s = this.info.getSkeleton();
        Joint[] j = s == null ? null : s.getJoints();
        Choice smoothChoice = new Choice();
        smoothChoice.add("Discontinuous");
        smoothChoice.add("Linear");
        smoothChoice.add("Interpolating");
        smoothChoice.add("Approximating");
        smoothChoice.select(this.smoothingMethod);
        final Choice modeChoice = new Choice();
        modeChoice.add("Absolute");
        modeChoice.add("Relative");
        modeChoice.select(this.mode);
        Choice jointChoice = new Choice();
        jointChoice.add("Object Origin");
        if (j != null) {
            int i = 0;
            while (i < j.length) {
                jointChoice.add(j[i].name);
                ++i;
            }
            int i2 = 0;
            while (i2 < j.length) {
                if (j[i2].id == this.joint) {
                    jointChoice.select(i2 + 1);
                }
                ++i2;
            }
        }
        final Choice coordsChoice = new Choice();
        coordsChoice.add("World");
        coordsChoice.add("Parent");
        coordsChoice.add("Other Object...");
        if (this.mode == 1) {
            coordsChoice.add("Local");
        }
        coordsChoice.select(this.relCoords);
        final ObjectRefSelector objSelector = new ObjectRefSelector(this.relObject, (LayoutWindow)editor.getEditingWindow(), "Position Relative To:", this.info);
        objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
        modeChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                int sel = modeChoice.getSelectedIndex();
                if (sel == 0 && coordsChoice.getItemCount() == 4) {
                    coordsChoice.remove(3);
                }
                if (sel == 1 && coordsChoice.getItemCount() == 3) {
                    coordsChoice.add("Local");
                }
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        coordsChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                objSelector.setEnabled(coordsChoice.getSelectedIndex() == 2);
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(editor.getParentFrame(), "Position Track Properties", new Component[]{smoothChoice, modeChoice, jointChoice, coordsChoice, objSelector}, new String[]{"Parameter Smoothing Method:", "Track Mode:", "Apply To:", "Coordinate System:", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        editor.saveState(false);
        this.smoothingMethod = smoothChoice.getSelectedIndex();
        this.mode = modeChoice.getSelectedIndex();
        this.relCoords = coordsChoice.getSelectedIndex();
        this.relObject = objSelector.getSelection();
        this.joint = jointChoice.getSelectedIndex() == 0 ? -1 : j[jointChoice.getSelectedIndex() - 1].id;
    }
}

