/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.NumberFormat;

public class VerticalAxis
extends Canvas {
    double minValue;
    double maxValue;
    double vscale;
    double[] tickPos;
    NumberFormat nf = NumberFormat.getNumberInstance();
    boolean lineAtBottom;
    public static final int TICK_SIZE = 6;

    public VerticalAxis() {
        this.setGraphRange(0.0, 1.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                VerticalAxis.this.setGraphRange(VerticalAxis.this.minValue, VerticalAxis.this.maxValue);
                VerticalAxis.this.repaint();
            }
        });
    }

    public void setGraphRange(double min, double max) {
        Dimension dim = this.getSize();
        this.minValue = min;
        this.maxValue = max;
        this.vscale = (double)dim.height / (max - min);
        double height = this.getSize().height;
        if (height <= 0.0) {
            return;
        }
        double increment = Math.pow(10.0, Math.floor(Math.log(max - min) / Math.log(10.0)));
        int pixels = (int)(height * increment / (max - min));
        if (pixels < 20) {
            while (pixels < 20) {
                pixels *= 5;
                increment *= 5.0;
            }
        } else if ((max - min) / increment < 4.0) {
            increment *= 0.5;
        }
        double lowest = Math.ceil(min / increment) * increment;
        int num = (int)Math.ceil((max - lowest) / increment) + 1;
        this.tickPos = new double[num];
        int i = 0;
        while (i < num) {
            this.tickPos[i] = lowest + (double)i * increment;
            ++i;
        }
    }

    public void showLineAtBottom(boolean show) {
        this.lineAtBottom = show;
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        int labelOffset = (fm.getMaxAscent() + fm.getMaxDescent()) / 2;
        Dimension dim = this.getSize();
        if (this.tickPos == null) {
            return;
        }
        if (this.tickPos.length > 1) {
            this.nf.setMaximumFractionDigits((int)Math.max(0.0, 1.0 - Math.log(this.tickPos[1] - this.tickPos[0]) / Math.log(10.0)));
        } else {
            this.nf.setMaximumFractionDigits(3);
        }
        int i = 0;
        while (i < this.tickPos.length) {
            int y = dim.height - (int)Math.round(this.vscale * (this.tickPos[i] - this.minValue));
            g.drawLine(dim.width - 6, y, dim.width, y);
            String s = this.nf.format(this.tickPos[i]);
            int x = dim.width - 6 - 2 - fm.stringWidth(s);
            g.drawString(s, x, y + labelOffset);
            ++i;
        }
        if (this.lineAtBottom) {
            g.drawLine(0, dim.height - 1, dim.width, dim.height - 1);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = 50;
        return dim;
    }
}

