/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.animation.BooleanKeyframe;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.Track;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class VisibilityTrack
extends Track {
    ObjectInfo info;
    Timecourse tc;

    public VisibilityTrack(ObjectInfo info) {
        super("Visibility");
        this.info = info;
        this.tc = new Timecourse(new Keyframe[0], new double[0], new Smoothness[0]);
    }

    public void apply(double time) {
        BooleanKeyframe v = (BooleanKeyframe)this.tc.evaluate(time, 1);
        if (v == null) {
            return;
        }
        this.info.visible = v.val;
    }

    public Track duplicate(Object obj) {
        VisibilityTrack t = new VisibilityTrack((ObjectInfo)obj);
        t.tc = this.tc.duplicate((ObjectInfo)obj);
        return t;
    }

    public void copy(Track tr) {
        VisibilityTrack t = (VisibilityTrack)tr;
        this.tc = t.tc.duplicate(this.info);
    }

    public double[] getKeyTimes() {
        return this.tc.getTimes();
    }

    public Timecourse getTimecourse() {
        return this.tc;
    }

    public void setKeyframe(double time, Keyframe k, Smoothness s) {
        this.tc.addTimepoint(k, time, s);
    }

    public Keyframe setKeyframe(double time, Scene sc) {
        BooleanKeyframe k = new BooleanKeyframe(this.info.visible);
        this.tc.addTimepoint(k, time, new Smoothness());
        return k;
    }

    public Keyframe setKeyframeIfModified(double time, Scene sc) {
        if (this.tc.getTimes().length == 0) {
            return this.setKeyframe(time, sc);
        }
        BooleanKeyframe v = (BooleanKeyframe)this.tc.evaluate(time, 1);
        if (v.val == this.info.visible) {
            return null;
        }
        return this.setKeyframe(time, sc);
    }

    public int moveKeyframe(int which, double time) {
        return this.tc.moveTimepoint(which, time);
    }

    public void deleteKeyframe(int which) {
        this.tc.removeTimepoint(which);
    }

    public boolean isNullTrack() {
        return this.tc.getTimes().length == 0;
    }

    public boolean canAcceptAsParent(Object obj) {
        return obj instanceof ObjectInfo;
    }

    public Object getParent() {
        return this.info;
    }

    public void setParent(Object obj) {
        this.info = (ObjectInfo)obj;
    }

    public String[] getValueNames() {
        return new String[]{"Visible"};
    }

    public double[] getDefaultGraphValues() {
        return new double[]{1.0};
    }

    public double[][] getValueRange() {
        return new double[][]{{0.0, 1.0}};
    }

    public void writeToStream(DataOutputStream out, Scene scene) throws IOException {
        double[] t = this.tc.getTimes();
        Keyframe[] v = this.tc.getValues();
        out.writeShort(0);
        out.writeUTF(this.name);
        out.writeBoolean(this.enabled);
        out.writeInt(t.length);
        int i = 0;
        while (i < t.length) {
            out.writeDouble(t[i]);
            v[i].writeToStream(out);
            ++i;
        }
    }

    public VisibilityTrack(DataInputStream in, Object parent, Scene scene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.enabled = in.readBoolean();
        int keys = in.readInt();
        double[] t = new double[keys];
        Smoothness[] s = new Smoothness[keys];
        Keyframe[] v = new Keyframe[keys];
        int i = 0;
        while (i < keys) {
            t[i] = in.readDouble();
            v[i] = new BooleanKeyframe(in, this.info);
            s[i] = new Smoothness();
            ++i;
        }
        this.info = (ObjectInfo)parent;
        this.tc = new Timecourse(v, t, s);
    }

    public void editKeyframe(LayoutWindow win, int which) {
        BooleanKeyframe key = (BooleanKeyframe)this.tc.getValues()[which];
        double time = this.tc.getTimes()[which];
        Checkbox visibleBox = new Checkbox("Visible", key.val);
        ValueField timeField = new ValueField(time, 0, 5);
        ComponentsDialog dlg = new ComponentsDialog((Frame)win, "Edit Keyframe", new Component[]{visibleBox, timeField}, new String[]{"", Translate.text("Time")});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        key.val = visibleBox.getState();
        this.moveKeyframe(which, timeField.getValue());
    }

    public void edit(LayoutWindow win) {
        TextField nameField = new TextField(this.getName());
        ComponentsDialog dlg = new ComponentsDialog((Frame)win, "Options for Visibility Track", new Component[]{nameField}, new String[]{"Track Name:"});
        if (!dlg.clickedOk()) {
            return;
        }
        win.setUndoRecord(new UndoRecord(win, false, 12, new Object[]{this, this.duplicate(this.info)}));
        this.setName(nameField.getText());
    }
}

