/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImagesDialog;
import artofillusion.math.Vec2;
import artofillusion.ui.ValueSlider;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImageOrValue {
    ImageMap map;
    float value;
    int component;

    public ImageOrValue(float val) {
        this.value = val;
    }

    public ImageOrValue(float scale, ImageMap theMap, int whichComponent) {
        this.value = scale;
        this.map = theMap;
        this.component = whichComponent;
    }

    public ImageMap getImage() {
        return this.map;
    }

    public float getValue() {
        return this.value;
    }

    public float getValue(boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            return this.value;
        }
        return this.map.getComponent(this.component, wrapx, wrapy, x, y, xsize, ysize) * this.value;
    }

    public void getGradient(Vec2 grad, boolean wrapx, boolean wrapy, double x, double y, double xsize, double ysize) {
        if (this.map == null) {
            grad.set(0.0, 0.0);
        } else {
            this.map.getGradient(grad, this.component, wrapx, wrapy, x, y, xsize, ysize);
            grad.scale(this.value);
        }
    }

    public float getAverageValue() {
        if (this.map == null) {
            return this.value;
        }
        return this.map.getAverageComponent(this.component) * this.value;
    }

    public ImageOrValue duplicate() {
        ImageOrValue copy = new ImageOrValue(this.value);
        copy.map = this.map;
        copy.component = this.component;
        return copy;
    }

    public void copy(ImageOrValue obj) {
        this.value = obj.value;
        this.map = obj.map;
        this.component = obj.component;
    }

    public ImageOrValue(DataInputStream in, Scene theScene) throws IOException {
        int index = in.readInt();
        if (index > -1) {
            this.map = theScene.getImage(index);
        }
        this.value = in.readFloat();
        this.component = in.readInt();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(theScene.indexOf(this.map));
        }
        out.writeFloat(this.value);
        out.writeInt(this.component);
    }

    public Panel getEditingPanel(Frame parent, Scene theScene, AdjustmentListener adjust, ActionListener action) {
        return new EditingPanel(parent, theScene, adjust, action);
    }

    class EditingPanel
    extends Panel
    implements AdjustmentListener,
    ItemListener {
        Frame fr;
        Scene sc;
        Canvas preview;
        Choice componentChoice;
        Label componentLabel;
        Label valueLabel;
        ValueSlider slider;
        AdjustmentListener adjust;

        public EditingPanel(Frame parent, Scene theScene, AdjustmentListener adjust, ActionListener action) {
            this.fr = parent;
            this.sc = theScene;
            this.adjust = adjust;
            this.preview = new Canvas(this){
                private final /* synthetic */ EditingPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(50, 50);
                }

                public void paint(Graphics g) {
                    if (EditingPanel.access$000((EditingPanel)this.this$1).map != null) {
                        g.drawImage(EditingPanel.access$000((EditingPanel)this.this$1).map.getPreview(), 0, 0, null);
                    } else {
                        g.drawRect(1, 1, 48, 48);
                    }
                }
            };
            this.preview.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ EditingPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseReleased(MouseEvent e) {
                    ImagesDialog dlg = new ImagesDialog(this.this$1.fr, this.this$1.sc, EditingPanel.access$000((EditingPanel)this.this$1).map);
                    EditingPanel.access$000((EditingPanel)this.this$1).map = dlg.getSelection();
                    this.this$1.updateComponents();
                    this.this$1.preview.repaint();
                }
            });
            this.componentChoice = new Choice();
            this.componentChoice.add("Red");
            this.componentChoice.add("Green");
            this.componentChoice.add("Blue");
            this.componentChoice.addItemListener(this);
            this.componentLabel = new Label("Component:");
            this.valueLabel = new Label("");
            this.slider = new ValueSlider(0.0, 1.0, 100, ImageOrValue.this.value);
            this.slider.addAdjustmentListener(this);
            if (action != null) {
                this.slider.addActionListener(action);
            }
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridheight = 2;
            this.add((Component)this.preview, gc);
            gc.gridheight = 1;
            gc.gridx = 1;
            this.add((Component)this.valueLabel, gc);
            this.add((Component)this.slider, gc);
            gc.gridx = 2;
            this.add((Component)this.componentLabel, gc);
            this.add((Component)this.componentChoice, gc);
            this.updateComponents();
        }

        void updateComponents() {
            if (this.adjust != null) {
                this.adjust.adjustmentValueChanged(null);
            }
            if (ImageOrValue.this.map == null) {
                this.valueLabel.setText("Value:");
            } else {
                this.valueLabel.setText("Scale:");
            }
            if (ImageOrValue.this.map != null && ImageOrValue.this.map.getComponents() > this.componentChoice.getItemCount()) {
                this.componentChoice.add("Alpha");
            } else if (this.componentChoice.getItemCount() == 4) {
                this.componentChoice.remove(3);
            }
            if (ImageOrValue.this.map == null || ImageOrValue.this.map.getComponents() == 1) {
                this.componentChoice.setEnabled(false);
                ImageOrValue.this.component = 0;
                return;
            }
            this.componentChoice.setEnabled(true);
            if (ImageOrValue.this.component >= this.componentChoice.getItemCount()) {
                ImageOrValue.this.component = 0;
            }
            this.componentChoice.select(ImageOrValue.this.component);
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            ImageOrValue.this.value = (float)this.slider.getValue();
            if (this.adjust != null) {
                this.adjust.adjustmentValueChanged(e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            ImageOrValue.this.component = this.componentChoice.getSelectedIndex();
            if (this.adjust != null) {
                this.adjust.adjustmentValueChanged(null);
            }
        }

        static /* synthetic */ ImageOrValue access$000(EditingPanel x0) {
            return x0.ImageOrValue.this;
        }
    }
}

