/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImagesDialog
extends Dialog
implements ActionListener {
    Scene theScene;
    Frame parent;
    int selection;
    ScrollPane sp;
    Scrollbar sb;
    ImagesCanvas ic;
    Button[] b;

    public ImagesDialog(Frame fr, Scene sc, ImageMap selected) {
        super(fr, "Images", true);
        this.parent = fr;
        this.theScene = sc;
        this.selection = 0;
        while (this.selection < sc.getNumImages() && sc.getImage(this.selection) != selected) {
            ++this.selection;
        }
        if (this.selection == sc.getNumImages()) {
            this.selection = -1;
        }
        this.sp = new ScrollPane(2);
        this.sb = new Scrollbar(1, 0, 0, 0, 0);
        Panel buttons = new Panel();
        this.add((Component)this.sp, "Center");
        this.ic = new ImagesCanvas(5);
        this.sp.add(this.ic);
        this.add((Component)this.sb, "East");
        this.sb.addAdjustmentListener(this.ic);
        this.add((Component)buttons, "South");
        this.b = new Button[4];
        this.b[0] = new Button("Load...");
        buttons.add(this.b[0]);
        this.b[0].addActionListener(this);
        this.b[0].setActionCommand("load");
        this.b[1] = new Button("Delete...");
        buttons.add(this.b[1]);
        this.b[1].addActionListener(this);
        this.b[1].setActionCommand("delete");
        this.b[2] = new Button("Select None");
        buttons.add(this.b[2]);
        this.b[2].addActionListener(this);
        this.b[2].setActionCommand("deselect");
        this.b[3] = new Button("Done");
        buttons.add(this.b[3]);
        this.b[3].addActionListener(this);
        this.b[3].setActionCommand("done");
        this.hilightButtons();
        this.sp.setSize(this.ic.getGridWidth() * 5 + 4, this.ic.getGridHeight() * 4 + 4);
        this.pack();
        this.setResizable(false);
        this.ic.scrollToSelection();
        ModellingApp.centerWindow(this);
        this.show();
    }

    public ImageMap getSelection() {
        if (this.selection < 0) {
            return null;
        }
        return this.theScene.getImage(this.selection);
    }

    void hilightButtons() {
        this.b[1].setEnabled(this.selection >= 0);
        this.b[2].setEnabled(this.selection >= 0);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("load")) {
            FileDialog fd = new FileDialog(this.parent, "Select Image to Load", 0);
            String sep = System.getProperty("file.separator");
            fd.show();
            if (fd.getFile() == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            String path = fd.getDirectory().endsWith(sep) ? fd.getDirectory() + fd.getFile() : fd.getDirectory() + sep + fd.getFile();
            try {
                this.theScene.addImage(new ImageMap(this.parent, path));
            }
            catch (InterruptedException ex) {
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.selection = this.theScene.getNumImages() - 1;
            this.ic.imagesChanged();
            this.ic.scrollToSelection();
            this.hilightButtons();
        } else if (command.equals("delete")) {
            MessageDialog dial = new MessageDialog(this.parent, "Delete the selected image?", new String[]{Translate.text("button.ok"), Translate.text("button.cancel")});
            if (dial.getChoice() == 1) {
                return;
            }
            boolean success = this.theScene.removeImage(this.selection);
            if (!success) {
                new MessageDialog(this.parent, new String[]{"This image could not be deleted, because it is", "currently being used by a texture or material."});
                return;
            }
            this.selection = -1;
            this.ic.imagesChanged();
            this.hilightButtons();
        } else if (command.equals("deselect")) {
            this.selection = -1;
            this.ic.imagesChanged();
            this.hilightButtons();
        } else if (command.equals("done")) {
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.hilightButtons();
    }

    class ImagesCanvas
    extends Canvas
    implements MouseListener,
    AdjustmentListener {
        int w;
        int h;
        int gridw;
        int gridh;

        public ImagesCanvas(int width) {
            this.w = width;
            this.gridw = 60;
            this.gridh = 60;
            ImagesDialog.this.sb.setUnitIncrement(this.gridh);
            this.imagesChanged();
            this.addMouseListener(this);
        }

        public void imagesChanged() {
            this.h = (ImagesDialog.this.theScene.getNumImages() - 1) / this.w + 1;
            ImagesDialog.this.sb.setMaximum(this.h * this.gridh + 2);
            ImagesDialog.this.sb.setVisibleAmount(ImagesDialog.this.sp.getViewportSize().height);
            ImagesDialog.this.sp.invalidate();
            ImagesDialog.this.sp.validate();
            this.repaint();
        }

        public int getGridWidth() {
            return this.gridw;
        }

        public int getGridHeight() {
            return this.gridh;
        }

        public void scrollToSelection() {
            if (ImagesDialog.this.selection < 0) {
                return;
            }
            ImagesDialog.this.sp.setScrollPosition(0, ImagesDialog.this.selection / this.w * this.gridh);
        }

        public void paint(Graphics g) {
            int i = 0;
            while (i < ImagesDialog.this.theScene.getNumImages()) {
                g.drawImage(ImagesDialog.this.theScene.getImage(i).getPreview(), i % this.w * this.gridw + 5, i / this.w * this.gridh + 5, this);
                ++i;
            }
            if (ImagesDialog.this.selection >= 0) {
                int x = ImagesDialog.this.selection % this.w * this.gridw;
                int y = ImagesDialog.this.selection / this.w * this.gridh;
                g.drawRect(x + 1, y + 1, this.gridw - 2, this.gridh - 2);
                g.drawRect(x + 2, y + 2, this.gridw - 4, this.gridh - 4);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.w * this.gridw, this.h * this.gridh);
        }

        public void mouseReleased(MouseEvent e) {
            Point p = e.getPoint();
            int i = p.x / this.gridw;
            int j = p.y / this.gridh;
            ImagesDialog.this.selection = i < 5 && i + j * this.w < ImagesDialog.this.theScene.getNumImages() ? i + j * this.w : -1;
            this.repaint();
            ImagesDialog.this.hilightButtons();
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            ImagesDialog.this.sp.setScrollPosition(0, ImagesDialog.this.sb.getValue());
            this.repaint();
        }
    }
}

