/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Callback;
import artofillusion.ModellingApp;
import artofillusion.ObjectViewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.SplineMeshEditorWindow;
import artofillusion.TextureParameter;
import artofillusion.WireframeMesh;
import artofillusion.animation.Actor;
import artofillusion.animation.ActorPose;
import artofillusion.animation.Joint;
import artofillusion.animation.Keyframe;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.Skeleton;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Vector;

public class SplineMesh
extends Object3D
implements Mesh {
    MeshVertex[] vertex;
    Skeleton skeleton;
    boolean uclosed;
    boolean vclosed;
    BoundingBox bounds;
    int usize;
    int vsize;
    int cachedUSize;
    int cachedVSize;
    int smoothingMethod;
    float[] usmoothness;
    float[] vsmoothness;
    TextureParameter[] parameter;
    RenderingMesh cachedMesh;
    WireframeMesh cachedWire;
    private static final int MAX_SUBDIVISIONS = 20;

    public SplineMesh(Vec3[][] v, float[] usmoothness, float[] vsmoothness, int smoothingMethod, boolean uclosed, boolean vclosed) {
        this.smoothingMethod = smoothingMethod;
        this.uclosed = uclosed;
        this.vclosed = vclosed;
        this.setSkeleton(new Skeleton());
        MeshVertex[][] vert = new MeshVertex[v.length][v[0].length];
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[0].length) {
                vert[i][j] = new MeshVertex(v[i][j]);
                ++j;
            }
            ++i;
        }
        this.setShape(vert, usmoothness, vsmoothness);
    }

    private SplineMesh() {
    }

    public Object3D duplicate() {
        SplineMesh mesh = new SplineMesh();
        mesh.setTexture(this.theTexture);
        if (this.texMapping != null) {
            mesh.setTextureMapping(this.texMapping.duplicate());
        }
        mesh.setMaterial(this.theMaterial);
        if (this.matMapping != null) {
            mesh.setMaterialMapping(this.matMapping.duplicate());
        }
        mesh.vertex = new MeshVertex[this.vertex.length];
        int i = 0;
        while (i < this.vertex.length) {
            mesh.vertex[i] = new MeshVertex(this.vertex[i]);
            ++i;
        }
        mesh.usmoothness = new float[this.usize];
        i = 0;
        while (i < this.usize) {
            mesh.usmoothness[i] = this.usmoothness[i];
            ++i;
        }
        mesh.vsmoothness = new float[this.vsize];
        i = 0;
        while (i < this.vsize) {
            mesh.vsmoothness[i] = this.vsmoothness[i];
            ++i;
        }
        mesh.setSmoothingMethod(this.smoothingMethod);
        mesh.skeleton = this.skeleton.duplicate();
        mesh.usize = this.usize;
        mesh.vsize = this.vsize;
        mesh.uclosed = this.uclosed;
        mesh.vclosed = this.vclosed;
        return mesh;
    }

    public void copyObject(Object3D obj) {
        SplineMesh mesh = (SplineMesh)obj;
        this.parameter = null;
        this.setTexture(mesh.getTexture());
        if (mesh.getTextureMapping() != null) {
            this.setTextureMapping(mesh.getTextureMapping().duplicate());
        }
        this.setMaterial(mesh.getMaterial());
        if (mesh.getMaterialMapping() != null) {
            this.setMaterialMapping(mesh.getMaterialMapping().duplicate());
        }
        this.vertex = new MeshVertex[mesh.vertex.length];
        int i = 0;
        while (i < mesh.vertex.length) {
            this.vertex[i] = new MeshVertex(mesh.vertex[i]);
            ++i;
        }
        this.usmoothness = new float[mesh.usize];
        i = 0;
        while (i < mesh.usize) {
            this.usmoothness[i] = mesh.usmoothness[i];
            ++i;
        }
        this.vsmoothness = new float[mesh.vsize];
        i = 0;
        while (i < mesh.vsize) {
            this.vsmoothness[i] = mesh.vsmoothness[i];
            ++i;
        }
        this.setSmoothingMethod(mesh.getSmoothingMethod());
        this.skeleton.copy(mesh.skeleton);
        this.usize = mesh.usize;
        this.vsize = mesh.vsize;
        this.uclosed = mesh.uclosed;
        this.vclosed = mesh.vclosed;
    }

    void findBounds() {
        double maxz;
        double maxy;
        double maxx;
        Vec3[] vert;
        if (this.cachedMesh != null) {
            vert = this.cachedMesh.vert;
        } else if (this.cachedWire != null) {
            vert = this.cachedWire.vert;
        } else {
            this.getWireframeMesh();
            vert = this.cachedWire.vert;
        }
        double minx = maxx = vert[0].x;
        double miny = maxy = vert[0].y;
        double minz = maxz = vert[0].z;
        int i = 1;
        while (i < vert.length) {
            if (vert[i].x < minx) {
                minx = vert[i].x;
            }
            if (vert[i].x > maxx) {
                maxx = vert[i].x;
            }
            if (vert[i].y < miny) {
                miny = vert[i].y;
            }
            if (vert[i].y > maxy) {
                maxy = vert[i].y;
            }
            if (vert[i].z < minz) {
                minz = vert[i].z;
            }
            if (vert[i].z > maxz) {
                maxz = vert[i].z;
            }
            ++i;
        }
        this.bounds = new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    public MeshVertex[] getVertices() {
        return this.vertex;
    }

    public final MeshVertex getVertex(int u, int v) {
        return this.vertex[u + this.usize * v];
    }

    public final int getUSize() {
        return this.usize;
    }

    public final int getVSize() {
        return this.vsize;
    }

    public int getSmoothingMethod() {
        return this.smoothingMethod;
    }

    public float[] getUSmoothness() {
        return this.usmoothness;
    }

    public float[] getVSmoothness() {
        return this.vsmoothness;
    }

    public void setVertices(Vec3[] v) {
        int i = 0;
        while (i < v.length) {
            this.vertex[i].r = v[i];
            ++i;
        }
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothingMethod(int method) {
        this.smoothingMethod = method;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSmoothness(float[] usmoothness, float[] vsmoothness) {
        this.usmoothness = usmoothness;
        this.vsmoothness = vsmoothness;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setShape(MeshVertex[][] v, float[] usmoothness, float[] vsmoothness) {
        this.usize = v.length;
        this.vsize = v[0].length;
        this.vertex = new MeshVertex[this.usize * this.vsize];
        int i = 0;
        while (i < this.usize) {
            int j = 0;
            while (j < this.vsize) {
                this.vertex[i + this.usize * j] = v[i][j];
                ++j;
            }
            ++i;
        }
        this.usmoothness = usmoothness;
        this.vsmoothness = vsmoothness;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean isUClosed() {
        return this.uclosed;
    }

    public boolean isVClosed() {
        return this.vclosed;
    }

    public boolean isClosed() {
        int i;
        Vec3 v2;
        Vec3 v1;
        if (!this.vclosed) {
            v1 = this.vertex[0].r;
            v2 = this.vertex[this.usize * (this.vsize - 1)].r;
            i = 1;
            while (i < this.usize) {
                if (v1.distance2(this.vertex[i].r) > 1.0E-24 || v2.distance2(this.vertex[i + this.usize * (this.vsize - 1)].r) > 1.0E-24) {
                    return false;
                }
                ++i;
            }
        }
        if (!this.uclosed) {
            v1 = this.vertex[0].r;
            v2 = this.vertex[this.usize - 1].r;
            i = 1;
            while (i < this.vsize) {
                if (v1.distance2(this.vertex[i * this.usize].r) > 1.0E-24 || v2.distance2(this.vertex[i * this.usize + this.usize - 1].r) > 1.0E-24) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void setClosed(boolean u, boolean v) {
        this.uclosed = u;
        this.vclosed = v;
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.bounds.getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.x *= xscale;
            this.vertex[i].r.y *= yscale;
            this.vertex[i].r.z *= zscale;
            ++i;
        }
        this.skeleton.scale(xscale, yscale, zscale);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.bounds = null;
    }

    public boolean editable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Callback cb) {
        SplineMeshEditorWindow ed = new SplineMeshEditorWindow(parent, "Spline Mesh '" + info.name + "'", info, cb, true);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), info);
        ed.show();
    }

    public void editGesture(EditingWindow parent, ObjectInfo info, Callback cb, ObjectInfo realObject) {
        SplineMeshEditorWindow ed = new SplineMeshEditorWindow(parent, "Gesture '" + info.name + "'", info, cb, false);
        ((ObjectViewer)ed.getView()).setScene(parent.getScene(), realObject);
        ed.show();
    }

    private Object[] subdivideMesh(double tol) {
        int j;
        MeshVertex[][] v = new MeshVertex[this.vsize][this.usize];
        int i = 0;
        while (i < this.usize) {
            j = 0;
            while (j < this.vsize) {
                v[j][i] = this.vertex[i + this.usize * j];
                ++j;
            }
            ++i;
        }
        Object[] output = this.usize == 2 ? new Object[]{v, this.usmoothness} : (this.smoothingMethod == 2 ? this.interpOneAxis(v, this.usmoothness, this.uclosed, tol) : this.approxOneAxis(v, this.usmoothness, this.uclosed, tol));
        MeshVertex[][] newv = (MeshVertex[][])output[0];
        float[] newus = (float[])output[1];
        v = new MeshVertex[newv[0].length][newv.length];
        i = 0;
        while (i < newv.length) {
            j = 0;
            while (j < newv[0].length) {
                v[j][i] = newv[i][j];
                ++j;
            }
            ++i;
        }
        output = this.vsize == 2 ? new Object[]{v, this.vsmoothness} : (this.smoothingMethod == 2 ? this.interpOneAxis(v, this.vsmoothness, this.vclosed, tol) : this.approxOneAxis(v, this.vsmoothness, this.vclosed, tol));
        return new Object[]{output[0], newus, output[1]};
    }

    private Object[] interpOneAxis(MeshVertex[][] v, float[] s, boolean closed, double tol) {
        double tol2 = tol * tol;
        boolean[] refine = closed ? new boolean[v[0].length] : new boolean[v[0].length - 1];
        int i = 0;
        while (i < refine.length) {
            refine[i] = true;
            ++i;
        }
        int count = refine.length;
        int iterations = 0;
        do {
            int j;
            boolean[] newrefine = new boolean[refine.length + count];
            MeshVertex[][] newv = new MeshVertex[v.length][v[0].length + count];
            float[] news = new float[v[0].length + count];
            i = 0;
            int k = 0;
            while (i < refine.length) {
                j = 0;
                while (j < v.length) {
                    newv[j][k] = v[j][i];
                    ++j;
                }
                news[k] = Math.min(s[i] * 2.0f, 1.0f);
                ++k;
                if (refine[i]) {
                    int p4;
                    int p3;
                    int p1 = i - 1;
                    if (p1 < 0) {
                        p1 = closed ? v[0].length - 1 : 0;
                    }
                    if ((p3 = i + 1) == v[0].length) {
                        p3 = closed ? 0 : v[0].length - 1;
                    }
                    if ((p4 = i + 2) >= v[0].length) {
                        p4 = closed ? (p4 %= v[0].length) : v[0].length - 1;
                    }
                    j = 0;
                    while (j < v.length) {
                        Vec3 temp;
                        newv[j][k] = SplineMesh.calcInterpPoint(v[j], s, p1, i, p3, p4);
                        if (v[j][i].r.distance2(newv[j][k].r) > tol2 && v[j][p3].r.distance2(newv[j][k].r) > tol2 && (temp = v[j][i].r.plus(v[j][p3].r).times(0.5)).distance2(newv[j][k].r) > tol2) {
                            newrefine[(k - 1 + newrefine.length) % newrefine.length] = true;
                            newrefine[k] = true;
                        }
                        ++j;
                    }
                    news[k] = 1.0f;
                    ++k;
                }
                ++i;
            }
            if (!closed) {
                j = 0;
                while (j < v.length) {
                    newv[j][k] = v[j][i];
                    ++j;
                }
            }
            count = 0;
            j = 0;
            while (j < newrefine.length) {
                if (newrefine[j]) {
                    ++count;
                }
                ++j;
            }
            v = newv;
            s = news;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return new Object[]{v, s};
    }

    private Object[] approxOneAxis(MeshVertex[][] v, float[] s, boolean closed, double tol) {
        int count;
        boolean[] refine = new boolean[v[0].length];
        int i = 0;
        while (i < refine.length) {
            refine[i] = true;
            ++i;
        }
        if (closed) {
            count = refine.length;
        } else {
            count = refine.length - 1;
            refine[refine.length - 1] = false;
            refine[0] = false;
        }
        int iterations = 0;
        do {
            int j;
            boolean[] newrefine = new boolean[refine.length + count];
            MeshVertex[][] newv = new MeshVertex[v.length][v[0].length + count];
            float[] news = new float[v[0].length + count];
            i = 0;
            int k = 0;
            while (i < refine.length) {
                int p3;
                int p1 = i - 1;
                if (p1 < 0) {
                    p1 = closed ? refine.length - 1 : 0;
                }
                if ((p3 = i + 1) == refine.length) {
                    p3 = closed ? 0 : refine.length - 1;
                }
                if (!refine[i]) {
                    j = 0;
                    while (j < v.length) {
                        newv[j][k] = v[j][i];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < v.length) {
                        newv[j][k] = SplineMesh.calcApproxPoint(v[j], s, p1, i, p3);
                        Vec3 temp = newv[j][k].r.minus(v[j][i].r);
                        if (temp.length2() > tol * tol) {
                            newrefine[(k + 1) % newrefine.length] = true;
                            newrefine[(k - 1 + newrefine.length) % newrefine.length] = true;
                            newrefine[k] = true;
                        }
                        ++j;
                    }
                }
                news[k] = Math.min(s[i] * 2.0f, 1.0f);
                if (!closed && i == refine.length - 1) break;
                ++k;
                if (refine[i] || refine[p3]) {
                    j = 0;
                    while (j < v.length) {
                        newv[j][k] = MeshVertex.blend(v[j][i], v[j][p3], 0.5, 0.5);
                        ++j;
                    }
                    news[k] = 1.0f;
                    ++k;
                }
                ++i;
            }
            count = 0;
            j = 0;
            while (j < newrefine.length - 1) {
                if (newrefine[j] || newrefine[j + 1]) {
                    ++count;
                }
                ++j;
            }
            if (closed && (newrefine[0] || newrefine[newrefine.length - 1])) {
                ++count;
            }
            if (newv[0][0].param != null && newv[0][1].param == null) {
                System.out.println("huh???");
            }
            v = newv;
            s = news;
            refine = newrefine;
        } while (count > 0 && ++iterations < 20);
        return new Object[]{v, s};
    }

    public static MeshVertex calcInterpPoint(MeshVertex[] v, float[] s, int i, int j, int k, int m) {
        double w1 = -0.0625 * (double)s[j];
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * (double)s[k];
        double w3 = 0.5 - w4;
        MeshVertex vt = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w3 * v[k].r.x + w4 * v[m].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w3 * v[k].r.y + w4 * v[m].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w3 * v[k].r.z + w4 * v[m].r.z));
        if (v[j].param != null) {
            vt.param = new double[v[j].param.length];
            int n = 0;
            while (n < vt.param.length) {
                vt.param[n] = w1 * v[i].param[n] + w2 * v[j].param[n] + w3 * v[k].param[n] + w4 * v[m].param[n];
                ++n;
            }
        }
        if (v[j].ikJoint == v[k].ikJoint) {
            vt.ikJoint = v[j].ikJoint;
            vt.ikWeight = 0.5 * (v[j].ikWeight + v[k].ikWeight);
        } else if (v[j].ikWeight > v[k].ikWeight) {
            vt.ikJoint = v[j].ikJoint;
            vt.ikWeight = v[j].ikWeight;
        } else {
            vt.ikJoint = v[k].ikJoint;
            vt.ikWeight = v[k].ikWeight;
        }
        return vt;
    }

    public static MeshVertex calcApproxPoint(MeshVertex[] v, float[] s, int i, int j, int k) {
        double w1 = 0.125 * (double)s[j];
        double w2 = 1.0 - 2.0 * w1;
        MeshVertex vt = new MeshVertex(new Vec3(w1 * v[i].r.x + w2 * v[j].r.x + w1 * v[k].r.x, w1 * v[i].r.y + w2 * v[j].r.y + w1 * v[k].r.y, w1 * v[i].r.z + w2 * v[j].r.z + w1 * v[k].r.z));
        if (v[j].param != null) {
            vt.param = new double[v[j].param.length];
            int n = 0;
            while (n < vt.param.length) {
                vt.param[n] = w1 * v[i].param[n] + w2 * v[j].param[n] + w1 * v[k].param[n];
                ++n;
            }
        }
        vt.ikJoint = v[j].ikJoint;
        vt.ikWeight = v[j].ikWeight;
        return vt;
    }

    public WireframeMesh getWireframeMesh() {
        int j;
        int i;
        int vdim;
        int udim;
        Vec3[] point;
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        if (this.cachedMesh != null) {
            point = this.cachedMesh.vert;
            udim = this.cachedUSize;
            vdim = this.cachedVSize;
        } else {
            Object[] output = this.subdivideMesh(ModellingApp.getPreferences().getInteractiveSurfaceError());
            MeshVertex[][] v = (MeshVertex[][])output[0];
            this.cachedUSize = udim = v.length;
            this.cachedVSize = vdim = v[0].length;
            point = new Vec3[udim * vdim];
            i = 0;
            while (i < udim) {
                j = 0;
                while (j < vdim) {
                    point[i + udim * j] = v[i][j].r;
                    ++j;
                }
                ++i;
            }
        }
        i = udim * (vdim - 1) + vdim * (udim - 1);
        if (this.uclosed) {
            i += vdim;
        }
        if (this.vclosed) {
            i += udim;
        }
        int[] from = new int[i];
        int[] to = new int[i];
        int k = 0;
        i = 0;
        while (i < udim - 1) {
            j = 0;
            while (j < vdim - 1) {
                int n = i + udim * j;
                from[k + 1] = n;
                from[k] = n;
                to[k++] = i + 1 + udim * j;
                to[k++] = i + udim * (j + 1);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < udim - 1) {
            from[k] = i + udim * (vdim - 1);
            to[k++] = i + 1 + udim * (vdim - 1);
            ++i;
        }
        i = 0;
        while (i < vdim - 1) {
            from[k] = udim - 1 + udim * i;
            to[k++] = udim - 1 + udim * (i + 1);
            ++i;
        }
        if (this.uclosed) {
            i = 0;
            while (i < vdim) {
                from[k] = i * udim;
                to[k++] = i * udim + udim - 1;
                ++i;
            }
        }
        if (this.vclosed) {
            i = 0;
            while (i < udim) {
                from[k] = i;
                to[k++] = i + udim * (vdim - 1);
                ++i;
            }
        }
        this.cachedWire = new WireframeMesh(point, from, to);
        return this.cachedWire;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        int j;
        int vdim;
        int udim;
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        Object[] output = this.subdivideMesh(tol);
        MeshVertex[][] v = (MeshVertex[][])output[0];
        float[] us = (float[])output[1];
        float[] vs = (float[])output[2];
        this.cachedUSize = udim = v.length;
        this.cachedVSize = vdim = v[0].length;
        Vec3[] point = new Vec3[udim * vdim];
        int i = 0;
        while (i < udim) {
            j = 0;
            while (j < vdim) {
                point[i + udim * j] = v[i][j].r;
                ++j;
            }
            ++i;
        }
        Vector<Vec3> normal = new Vector<Vec3>(point.length);
        int[][][] normIndex = new int[udim][vdim][4];
        int k = 0;
        i = 0;
        while (i < udim) {
            j = 0;
            while (j < vdim) {
                int v2;
                int v1;
                int u2;
                int u1 = i - 1;
                if (u1 == -1) {
                    u1 = this.uclosed ? udim - 1 : 0;
                }
                if ((u2 = i + 1) == udim) {
                    u2 = this.uclosed ? 0 : i;
                }
                if ((v1 = j - 1) == -1) {
                    v1 = this.vclosed ? vdim - 1 : 0;
                }
                if ((v2 = j + 1) == vdim) {
                    v2 = this.vclosed ? 0 : j;
                }
                if (us[i] < 1.0f && vs[j] < 1.0f) {
                    normal.addElement(this.calcNormal(point, i, j, u1, i, v1, j, udim, vdim));
                    normal.addElement(this.calcNormal(point, i, j, i, u2, v1, j, udim, vdim));
                    normal.addElement(this.calcNormal(point, i, j, u1, i, j, v2, udim, vdim));
                    normal.addElement(this.calcNormal(point, i, j, i, u2, j, v2, udim, vdim));
                    normIndex[i][j][0] = k++;
                    normIndex[i][j][1] = k++;
                    normIndex[i][j][2] = k++;
                    normIndex[i][j][3] = k++;
                } else if (us[i] < 1.0f) {
                    normal.addElement(this.calcNormal(point, i, j, u1, i, v1, v2, udim, vdim));
                    normal.addElement(this.calcNormal(point, i, j, i, u2, v1, v2, udim, vdim));
                    int n = k++;
                    normIndex[i][j][2] = n;
                    normIndex[i][j][0] = n;
                    int n2 = k++;
                    normIndex[i][j][3] = n2;
                    normIndex[i][j][1] = n2;
                } else if (vs[j] < 1.0f) {
                    normal.addElement(this.calcNormal(point, i, j, u1, u2, v1, j, udim, vdim));
                    normal.addElement(this.calcNormal(point, i, j, u1, u2, j, v2, udim, vdim));
                    int n = k++;
                    normIndex[i][j][1] = n;
                    normIndex[i][j][0] = n;
                    int n3 = k++;
                    normIndex[i][j][3] = n3;
                    normIndex[i][j][2] = n3;
                } else {
                    normal.addElement(this.calcNormal(point, i, j, u1, u2, v1, v2, udim, vdim));
                    int n = k++;
                    normIndex[i][j][3] = n;
                    normIndex[i][j][2] = n;
                    normIndex[i][j][1] = n;
                    normIndex[i][j][0] = n;
                }
                ++j;
            }
            ++i;
        }
        Vec3[] norm = new Vec3[normal.size()];
        i = 0;
        while (i < norm.length) {
            norm[i] = (Vec3)normal.elementAt(i);
            ++i;
        }
        i = (udim - 1) * (vdim - 1);
        if (this.uclosed) {
            i += vdim - 1;
        }
        if (this.vclosed) {
            i += udim - 1;
        }
        if (this.uclosed && this.vclosed) {
            ++i;
        }
        RenderingTriangle[] tri = new RenderingTriangle[i *= 2];
        k = 0;
        i = 0;
        while (i < udim - 1) {
            j = 0;
            while (j < vdim - 1) {
                tri[k++] = this.texMapping.mapTriangle(i + udim * j, i + 1 + udim * j, i + 1 + udim * (j + 1), normIndex[i][j][3], normIndex[i + 1][j][2], normIndex[i + 1][j + 1][0], point);
                tri[k++] = this.texMapping.mapTriangle(i + udim * j, i + 1 + udim * (j + 1), i + udim * (j + 1), normIndex[i][j][3], normIndex[i + 1][j + 1][0], normIndex[i][j + 1][1], point);
                ++j;
            }
            ++i;
        }
        if (this.uclosed) {
            i = 0;
            while (i < vdim - 1) {
                tri[k++] = this.texMapping.mapTriangle((i + 1) * udim - 1, i * udim, (i + 1) * udim, normIndex[udim - 1][i][3], normIndex[0][i][2], normIndex[0][i + 1][0], point);
                tri[k++] = this.texMapping.mapTriangle((i + 1) * udim - 1, (i + 1) * udim, (i + 2) * udim - 1, normIndex[udim - 1][i][3], normIndex[0][i + 1][0], normIndex[udim - 1][i + 1][1], point);
                ++i;
            }
        }
        if (this.vclosed) {
            i = 0;
            while (i < udim - 1) {
                tri[k++] = this.texMapping.mapTriangle(i + udim * (vdim - 1), i + 1 + udim * (vdim - 1), i + 1, normIndex[i][vdim - 1][3], normIndex[i + 1][vdim - 1][2], normIndex[i + 1][0][0], point);
                tri[k++] = this.texMapping.mapTriangle(i + udim * (vdim - 1), i + 1, i, normIndex[i][vdim - 1][3], normIndex[i + 1][0][0], normIndex[i][0][1], point);
                ++i;
            }
        }
        if (this.uclosed && this.vclosed) {
            tri[k++] = this.texMapping.mapTriangle(udim * vdim - 1, udim * (vdim - 1), 0, normIndex[udim - 1][vdim - 1][3], normIndex[0][vdim - 1][2], normIndex[0][0][0], point);
            tri[k++] = this.texMapping.mapTriangle(udim * vdim - 1, 0, udim - 1, normIndex[udim - 1][vdim - 1][3], normIndex[0][0][0], normIndex[udim - 1][0][1], point);
        }
        RenderingMesh mesh = new RenderingMesh(point, norm, tri);
        if (v[0][0].param != null && v[0][0].param.length > 0) {
            double[][] param = new double[udim * vdim][info.texParam.length];
            k = 0;
            while (k < info.texParam.length) {
                if (info.texParamPerVertex[k]) {
                    i = 0;
                    while (i < udim) {
                        j = 0;
                        while (j < vdim) {
                            param[i + udim * j][k] = v[i][j].param[k];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    j = 0;
                    while (j < param.length) {
                        param[j][k] = info.texParamValue[k];
                        ++j;
                    }
                }
                ++k;
            }
            mesh.setParameters(param, this.texMapping);
        }
        if (interactive) {
            this.cachedMesh = mesh;
        }
        return mesh;
    }

    private Vec3 calcNormal(Vec3[] point, int u, int v, int u1, int u2, int v1, int v2, int udim, int vdim) {
        Vec3 vec2;
        double len2;
        Vec3 vec1 = point[u1 + udim * v].minus(point[u2 + udim * v]);
        double len1 = vec1.length2();
        if (len1 == 0.0) {
            vec1 = point[u1 + udim * v1].minus(point[u2 + udim * v1]);
            len1 = vec1.length2();
        }
        if (len1 == 0.0) {
            vec1 = point[u1 + udim * v2].minus(point[u2 + udim * v2]);
            len1 = vec1.length2();
        }
        if ((len2 = (vec2 = point[u + udim * v1].minus(point[u + udim * v2])).length2()) == 0.0) {
            vec2 = point[u1 + udim * v1].minus(point[u1 + udim * v2]);
            len2 = vec2.length2();
        }
        if (len2 == 0.0) {
            vec2 = point[u2 + udim * v1].minus(point[u2 + udim * v2]);
            len2 = vec2.length2();
        }
        if (len1 == 0.0 || len2 == 0.0) {
            return new Vec3();
        }
        Vec3 norm = vec1.cross(vec2);
        norm.normalize();
        return norm;
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        int j;
        Object[] output = this.subdivideMesh(tol);
        MeshVertex[][] v = (MeshVertex[][])output[0];
        float[] us = (float[])output[1];
        float[] vs = (float[])output[2];
        int udim = v.length;
        int vdim = v[0].length;
        Vec3[] point = new Vec3[udim * vdim];
        int i = 0;
        while (i < udim) {
            j = 0;
            while (j < vdim) {
                point[i + udim * j] = v[i][j].r;
                ++j;
            }
            ++i;
        }
        i = (udim - 1) * (vdim - 1);
        if (this.uclosed) {
            i += vdim - 1;
        }
        if (this.vclosed) {
            i += udim - 1;
        }
        if (this.uclosed && this.vclosed) {
            ++i;
        }
        int[][] faces = new int[i *= 2][];
        int k = 0;
        i = 0;
        while (i < udim - 1) {
            j = 0;
            while (j < vdim - 1) {
                faces[k++] = new int[]{i + udim * j, i + 1 + udim * j, i + 1 + udim * (j + 1)};
                faces[k++] = new int[]{i + udim * j, i + 1 + udim * (j + 1), i + udim * (j + 1)};
                ++j;
            }
            ++i;
        }
        if (this.uclosed) {
            i = 0;
            while (i < vdim - 1) {
                faces[k++] = new int[]{(i + 1) * udim - 1, i * udim, (i + 1) * udim};
                faces[k++] = new int[]{(i + 1) * udim - 1, (i + 1) * udim, (i + 2) * udim - 1};
                ++i;
            }
        }
        if (this.vclosed) {
            i = 0;
            while (i < udim - 1) {
                faces[k++] = new int[]{i + udim * (vdim - 1), i + 1 + udim * (vdim - 1), i + 1};
                faces[k++] = new int[]{i + udim * (vdim - 1), i + 1, i++};
            }
        }
        if (this.uclosed && this.vclosed) {
            faces[k++] = new int[]{udim * vdim - 1, udim * (vdim - 1), 0};
            faces[k++] = new int[]{udim * vdim - 1, 0, udim - 1};
        }
        TriangleMesh trimesh = new TriangleMesh(point, (int[][])faces);
        TriangleMesh.Edge[] ed = trimesh.getEdges();
        i = 0;
        while (i < ed.length) {
            j = ed[i].v1 / udim;
            k = ed[i].v2 / udim;
            if (j == k) {
                ed[i].smoothness = vs[j];
            } else {
                j = ed[i].v1 % udim;
                ed[i].smoothness = us[j];
            }
            ++i;
        }
        trimesh.setTexture(this.getTexture());
        if (this.getTexture() != null) {
            trimesh.setTextureMapping(this.getTextureMapping().duplicate());
        }
        trimesh.setMaterial(this.getMaterial());
        if (this.getMaterial() != null) {
            trimesh.setMaterialMapping(this.getMaterialMapping().duplicate());
        }
        return trimesh;
    }

    public void setTextureMapping(TextureMapping mapping) {
        int j2;
        super.setTextureMapping(mapping);
        TextureParameter[] texparam = mapping.getParameters();
        this.cachedMesh = null;
        this.cachedWire = null;
        if (texparam == null || texparam.length == 0) {
            this.parameter = null;
            if (this.vertex != null) {
                int i = 0;
                while (i < this.vertex.length) {
                    this.vertex[i].param = null;
                    ++i;
                }
            }
            return;
        }
        TextureParameter[] newparam = new TextureParameter[texparam.length];
        int i = 0;
        while (i < newparam.length) {
            newparam[i] = texparam[i].duplicate();
            ++i;
        }
        if (this.vertex == null) {
            this.parameter = newparam;
            return;
        }
        if (this.parameter == null || this.parameter.length == 0) {
            this.parameter = newparam;
            i = 0;
            while (i < this.vertex.length) {
                this.vertex[i].param = new double[newparam.length];
                int j2 = 0;
                while (j2 < newparam.length) {
                    if (newparam[j2].type == 0) {
                        this.vertex[i].param[j2] = newparam[j2].defaultVal;
                    } else if (newparam[j2].type == 1) {
                        this.vertex[i].param[j2] = this.vertex[i].r.x;
                    } else if (newparam[j2].type == 2) {
                        this.vertex[i].param[j2] = this.vertex[i].r.y;
                    } else if (newparam[j2].type == 3) {
                        this.vertex[i].param[j2] = this.vertex[i].r.z;
                    }
                    ++j2;
                }
                ++i;
            }
            return;
        }
        int[] index = new int[newparam.length];
        i = 0;
        while (i < newparam.length) {
            j2 = 0;
            while (j2 < this.parameter.length && !this.parameter[j2].equals(newparam[i])) {
                ++j2;
            }
            index[i] = j2;
            ++i;
        }
        i = 0;
        while (i < this.vertex.length) {
            double[] newval = new double[newparam.length];
            j2 = 0;
            while (j2 < newparam.length) {
                if (index[j2] == this.parameter.length) {
                    if (newparam[j2].type == 0) {
                        newval[j2] = newparam[j2].defaultVal;
                    } else if (newparam[j2].type == 1) {
                        newval[j2] = this.vertex[i].r.x;
                    } else if (newparam[j2].type == 2) {
                        newval[j2] = this.vertex[i].r.y;
                    } else if (newparam[j2].type == 3) {
                        newval[j2] = this.vertex[i].r.z;
                    }
                } else {
                    newval[j2] = this.vertex[i].param[index[j2]];
                }
                ++j2;
            }
            this.vertex[i].param = newval;
            ++i;
        }
        this.parameter = newparam;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(Skeleton s) {
        this.skeleton = s;
    }

    public SplineMesh(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.usize = in.readInt();
        this.vsize = in.readInt();
        this.vertex = new MeshVertex[this.usize * this.vsize];
        this.usmoothness = new float[this.usize];
        this.vsmoothness = new float[this.vsize];
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i] = new MeshVertex(new Vec3(in));
            this.vertex[i].ikJoint = in.readInt();
            this.vertex[i].ikWeight = in.readDouble();
            if (this.parameter != null) {
                this.vertex[i].param = new double[this.parameter.length];
                int j = 0;
                while (j < this.parameter.length) {
                    this.vertex[i].param[j] = in.readDouble();
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.usize) {
            this.usmoothness[i] = in.readFloat();
            ++i;
        }
        i = 0;
        while (i < this.vsize) {
            this.vsmoothness[i] = in.readFloat();
            ++i;
        }
        this.uclosed = in.readBoolean();
        this.vclosed = in.readBoolean();
        this.smoothingMethod = in.readInt();
        this.findBounds();
        this.skeleton = new Skeleton(in);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeInt(this.usize);
        out.writeInt(this.vsize);
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.writeToFile(out);
            out.writeInt(this.vertex[i].ikJoint);
            out.writeDouble(this.vertex[i].ikWeight);
            if (this.parameter != null) {
                int j = 0;
                while (j < this.parameter.length) {
                    out.writeDouble(this.vertex[i].param[j]);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.usize) {
            out.writeFloat(this.usmoothness[i]);
            ++i;
        }
        i = 0;
        while (i < this.vsize) {
            out.writeFloat(this.vsmoothness[i]);
            ++i;
        }
        out.writeBoolean(this.uclosed);
        out.writeBoolean(this.vclosed);
        out.writeInt(this.smoothingMethod);
        this.skeleton.writeToStream(out);
    }

    public void makeRightSideOut() {
        Vec3[] norm = this.getNormals();
        Vec3 result = new Vec3();
        int i = 0;
        while (i < norm.length) {
            result.x += this.vertex[i].r.x * norm[i].x;
            result.y += this.vertex[i].r.y * norm[i].y;
            result.z += this.vertex[i].r.z * norm[i].z;
            ++i;
        }
        if (result.x + result.y + result.z < 0.0) {
            this.reverseOrientation();
        }
    }

    public void reverseOrientation() {
        int i = 0;
        while (i < this.usize / 2) {
            int j = 0;
            while (j < this.vsize) {
                MeshVertex swapVert = this.vertex[i + this.usize * j];
                this.vertex[i + this.usize * j] = this.vertex[this.usize - 1 - i + this.usize * j];
                this.vertex[this.usize - 1 - i + this.usize * j] = swapVert;
                ++j;
            }
            float swapSmooth = this.usmoothness[i];
            this.usmoothness[i] = this.usmoothness[this.usize - 1 - i];
            this.usmoothness[this.usize - 1 - i] = swapSmooth;
            ++i;
        }
        this.cachedMesh = null;
    }

    public Vec3[] getNormals() {
        Vec3[] point = new Vec3[this.vertex.length];
        Vec3[] norm = new Vec3[this.vertex.length];
        int i = 0;
        while (i < this.vertex.length) {
            point[i] = this.vertex[i].r;
            ++i;
        }
        i = 0;
        while (i < this.usize) {
            int j = 0;
            while (j < this.vsize) {
                int v2;
                int v1;
                int u2;
                int u1 = i - 1;
                if (u1 == -1) {
                    u1 = this.uclosed ? this.usize - 1 : 0;
                }
                if ((u2 = i + 1) == this.usize) {
                    u2 = this.uclosed ? 0 : i;
                }
                if ((v1 = j - 1) == -1) {
                    v1 = this.vclosed ? this.vsize - 1 : 0;
                }
                if ((v2 = j + 1) == this.vsize) {
                    v2 = this.vclosed ? 0 : j;
                }
                norm[i + this.usize * j] = this.calcNormal(point, i, j, u1, u2, v1, v2, this.usize, this.vsize);
                ++j;
            }
            ++i;
        }
        return norm;
    }

    public Keyframe getPoseKeyframe() {
        return new SplineMeshKeyframe(this);
    }

    public void applyPoseKeyframe(Keyframe k) {
        SplineMeshKeyframe key = (SplineMeshKeyframe)k;
        int i = 0;
        while (i < this.vertex.length) {
            this.vertex[i].r.set(key.vertPos[i]);
            ++i;
        }
        System.arraycopy(key.usmoothness, 0, this.usmoothness, 0, this.usmoothness.length);
        System.arraycopy(key.vsmoothness, 0, this.vsmoothness, 0, this.vsmoothness.length);
        if (this.parameter != null && this.parameter.length > 0) {
            int i2 = 0;
            while (i2 < this.vertex.length) {
                int j = 0;
                while (j < this.vertex[i2].param.length) {
                    this.vertex[i2].param[j] = key.param[i2][j];
                    ++j;
                }
                ++i2;
            }
        }
        this.skeleton.copy(key.skeleton);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.findBounds();
    }

    public Object3D getPosableObject() {
        SplineMesh m = (SplineMesh)this.duplicate();
        return new Actor(m);
    }

    public static class SplineMeshKeyframe
    implements ActorPose {
        Vec3[] vertPos;
        float[] usmoothness;
        float[] vsmoothness;
        double[][] param;
        Skeleton skeleton;
        SplineMesh mesh;

        public SplineMeshKeyframe(SplineMesh mesh) {
            this.mesh = mesh;
            this.skeleton = mesh.getSkeleton().duplicate();
            this.vertPos = new Vec3[mesh.vertex.length];
            this.usmoothness = new float[mesh.usmoothness.length];
            this.vsmoothness = new float[mesh.vsmoothness.length];
            int i = 0;
            while (i < this.vertPos.length) {
                this.vertPos[i] = new Vec3(mesh.vertex[i].r);
                ++i;
            }
            System.arraycopy(mesh.usmoothness, 0, this.usmoothness, 0, this.usmoothness.length);
            System.arraycopy(mesh.vsmoothness, 0, this.vsmoothness, 0, this.vsmoothness.length);
            if (mesh.parameter != null && mesh.parameter.length > 0) {
                this.param = new double[mesh.vertex.length][mesh.parameter.length];
                int i2 = 0;
                while (i2 < this.vertPos.length) {
                    int j = 0;
                    while (j < mesh.parameter.length) {
                        this.param[i2][j] = mesh.vertex[i2].param[j];
                        ++j;
                    }
                    ++i2;
                }
            }
        }

        private SplineMeshKeyframe() {
        }

        public Skeleton getSkeleton() {
            return this.skeleton;
        }

        public void setSkeleton(Skeleton s) {
            this.skeleton = s;
        }

        public Keyframe duplicate() {
            return this.duplicate(this.mesh);
        }

        public Keyframe duplicate(Object owner) {
            SplineMeshKeyframe k = new SplineMeshKeyframe();
            k.mesh = (SplineMesh)owner;
            k.skeleton = this.skeleton.duplicate();
            k.vertPos = new Vec3[this.vertPos.length];
            k.usmoothness = new float[this.usmoothness.length];
            k.vsmoothness = new float[this.vsmoothness.length];
            int i = 0;
            while (i < this.vertPos.length) {
                k.vertPos[i] = new Vec3(this.vertPos[i]);
                ++i;
            }
            System.arraycopy(this.usmoothness, 0, k.usmoothness, 0, this.usmoothness.length);
            System.arraycopy(this.vsmoothness, 0, k.vsmoothness, 0, this.vsmoothness.length);
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                k.param = new double[this.param.length][this.mesh.parameter.length];
                int i2 = 0;
                while (i2 < this.param.length) {
                    int j = 0;
                    while (j < this.mesh.parameter.length) {
                        k.param[i2][j] = this.param[i2][j];
                        ++j;
                    }
                    ++i2;
                }
            }
            return k;
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return null;
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            return null;
        }

        public ActorPose blend(ActorPose[] p, double[] weight) {
            SplineMeshKeyframe total = (SplineMeshKeyframe)this.duplicate(this.mesh);
            Joint[] joint = this.skeleton.getJoints();
            Joint[] jt = total.skeleton.getJoints();
            Vec3[] root = new Vec3[joint.length];
            Vec3[] newroot = new Vec3[joint.length];
            double[][] rootangles = new double[joint.length][];
            int i = 0;
            while (i < jt.length) {
                if (jt[i].parent == null) {
                    root[i] = joint[i].coords.getOrigin();
                    newroot[i] = new Vec3(jt[i].coords.getOrigin());
                    rootangles[i] = joint[i].coords.getRotationAngles();
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < weight.length) {
                SplineMeshKeyframe key = (SplineMeshKeyframe)p[i2];
                Joint[] jt2 = key.skeleton.getJoints();
                int j = 0;
                while (j < jt.length) {
                    jt[j].angle1.pos += weight[i2] * this.findOffset(jt2[j].angle1, joint[j].angle1);
                    jt[j].angle2.pos += weight[i2] * this.findOffset(jt2[j].angle2, joint[j].angle2);
                    jt[j].twist.pos += weight[i2] * this.findOffset(jt2[j].twist, joint[j].twist);
                    jt[j].length.pos += weight[i2] * this.findOffset(jt2[j].length, joint[j].length);
                    if (jt[j].parent == null) {
                        newroot[j].add(jt2[j].coords.getOrigin().minus(root[j]).times(weight[i2]));
                        double[] angles = jt2[j].coords.getRotationAngles();
                        RotationKeyframe rot = new RotationKeyframe(angles[0] - rootangles[j][0], angles[1] - rootangles[j][1], angles[2] - rootangles[j][2]);
                        rot.applyToCoordinates(jt[j].coords, weight[i2], null, null, true, true, true, true);
                    }
                    ++j;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < jt.length) {
                jt[i3].angle1.set(jt[i3].angle1.pos);
                jt[i3].angle2.set(jt[i3].angle2.pos);
                jt[i3].twist.set(jt[i3].twist.pos);
                jt[i3].length.set(jt[i3].length.pos);
                ++i3;
            }
            int i4 = 0;
            while (i4 < jt.length) {
                if (jt[i4].parent == null) {
                    jt[i4].coords.setOrigin(newroot[i4]);
                    jt[i4].recalcCoords(true);
                }
                ++i4;
            }
            Vec3 temp = new Vec3();
            int j = 0;
            while (j < this.vertPos.length) {
                MeshVertex v = this.mesh.vertex[j];
                int index = this.skeleton.findJointIndex(v.ikJoint);
                if (index != -1) {
                    Joint j1 = joint[index];
                    Joint j2 = jt[index];
                    double wt = j2.parent == null ? 1.0 : v.ikWeight;
                    j1.coords.toLocal().transform(total.vertPos[j]);
                    j2.coords.fromLocal().transform(total.vertPos[j]);
                    if (wt < 1.0) {
                        total.vertPos[j].scale(wt);
                        temp.set(this.vertPos[j]);
                        j1.parent.coords.toLocal().transform(temp);
                        j2.parent.coords.fromLocal().transform(temp);
                        temp.scale(1.0 - wt);
                        total.vertPos[j].add(temp);
                    }
                }
                ++j;
            }
            Vec3 temp1 = new Vec3();
            Vec3 temp2 = new Vec3();
            int i5 = 0;
            while (i5 < weight.length) {
                SplineMeshKeyframe key = (SplineMeshKeyframe)p[i5];
                int j2 = 0;
                while (j2 < this.vertPos.length) {
                    MeshVertex v = this.mesh.vertex[j2];
                    int index = this.skeleton.findJointIndex(v.ikJoint);
                    if (index == -1) {
                        total.vertPos[j2].add(key.vertPos[j2].minus(this.vertPos[j2]).times(weight[i5]));
                    } else {
                        Joint j1 = joint[index];
                        Joint j22 = jt[index];
                        Joint j3 = key.skeleton.getJoint(j1.id);
                        double wt = j1.parent == null ? 1.0 : v.ikWeight;
                        temp1.set(key.vertPos[j2]);
                        temp2.set(this.vertPos[j2]);
                        j3.coords.toLocal().transform(temp1);
                        j1.coords.toLocal().transform(temp2);
                        temp1.subtract(temp2);
                        j22.coords.fromLocal().transformDirection(temp1);
                        temp1.scale(wt * weight[i5]);
                        total.vertPos[j2].add(temp1);
                        if (wt < 1.0) {
                            temp1.set(key.vertPos[j2]);
                            temp2.set(this.vertPos[j2]);
                            j3.parent.coords.toLocal().transform(temp1);
                            j1.parent.coords.toLocal().transform(temp2);
                            temp1.subtract(temp2);
                            j22.parent.coords.fromLocal().transformDirection(temp1);
                            temp1.scale((1.0 - wt) * weight[i5]);
                            total.vertPos[j2].add(temp1);
                        }
                    }
                    ++j2;
                }
                if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                    int j3 = 0;
                    while (j3 < this.param.length) {
                        int m = 0;
                        while (m < this.mesh.parameter.length) {
                            double[] dArray = total.param[j3];
                            int n = m;
                            dArray[n] = dArray[n] + weight[i5] * (key.param[j3][m] - this.param[j3][m]);
                            ++m;
                        }
                        ++j3;
                    }
                }
                int j4 = 0;
                while (j4 < this.usmoothness.length) {
                    int n = j4;
                    total.usmoothness[n] = (float)((double)total.usmoothness[n] + weight[i5] * (double)(key.usmoothness[j4] - this.usmoothness[j4]));
                    ++j4;
                }
                int j5 = 0;
                while (j5 < this.vsmoothness.length) {
                    int n = j5;
                    total.vsmoothness[n] = (float)((double)total.vsmoothness[n] + weight[i5] * (double)(key.vsmoothness[j5] - this.vsmoothness[j5]));
                    ++j5;
                }
                ++i5;
            }
            int i6 = 0;
            while (i6 < total.usmoothness.length) {
                if ((double)total.usmoothness[i6] < 0.0) {
                    total.usmoothness[i6] = 0.0f;
                }
                if ((double)total.usmoothness[i6] > 1.0) {
                    total.usmoothness[i6] = 1.0f;
                }
                ++i6;
            }
            int i7 = 0;
            while (i7 < total.vsmoothness.length) {
                if ((double)total.vsmoothness[i7] < 0.0) {
                    total.vsmoothness[i7] = 0.0f;
                }
                if ((double)total.vsmoothness[i7] > 1.0) {
                    total.vsmoothness[i7] = 1.0f;
                }
                ++i7;
            }
            return total;
        }

        private double findOffset(Joint.DOF gesture, Joint.DOF defaultPose) {
            double diff = gesture.pos - defaultPose.pos;
            if (gesture.loop) {
                double range = gesture.max - gesture.min;
                while (diff > gesture.max) {
                    diff -= range;
                }
                while (diff < gesture.min) {
                    diff += range;
                }
            }
            return diff;
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof SplineMeshKeyframe)) {
                return false;
            }
            SplineMeshKeyframe key = (SplineMeshKeyframe)k;
            int i = 0;
            while (i < this.vertPos.length) {
                if (!this.vertPos[i].equals(key.vertPos[i])) {
                    return false;
                }
                ++i;
            }
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                int i2 = 0;
                while (i2 < this.param.length) {
                    int j = 0;
                    while (j < this.mesh.parameter.length) {
                        if (this.param[i2][j] != key.param[i2][j]) {
                            return false;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.usmoothness.length) {
                if (this.usmoothness[i3] != key.usmoothness[i3]) {
                    return false;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.vsmoothness.length) {
                if (this.vsmoothness[i4] != key.vsmoothness[i4]) {
                    return false;
                }
                ++i4;
            }
            return this.skeleton.equals(key.skeleton);
        }

        public void textureChanged(TextureParameter[] oldParams, TextureParameter[] newParams) {
            double[][] newval = new double[this.vertPos.length][newParams.length];
            int i = 0;
            while (i < newParams.length) {
                int k;
                int j = 0;
                while (j < oldParams.length && !oldParams[j].equals(newParams[i])) {
                    ++j;
                }
                if (j == oldParams.length || this.param == null) {
                    k = 0;
                    while (k < this.mesh.parameter.length) {
                        if (this.mesh.parameter[k].equals(newParams[i])) {
                            j = 0;
                            while (j < newval.length) {
                                newval[j][i] = this.mesh.vertex[j].param[k];
                                ++j;
                            }
                            break;
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < newval.length) {
                        newval[k][i] = this.param[k][j];
                        ++k;
                    }
                }
                ++i;
            }
            this.param = newval;
        }

        public void setTextureParameter(TextureParameter p, double[] value) {
            int which = 0;
            while (which < this.mesh.parameter.length && !this.mesh.parameter[which].equals(p)) {
                ++which;
            }
            if (which == this.mesh.parameter.length) {
                return;
            }
            int i = 0;
            while (i < value.length) {
                this.param[i][which] = value[i];
                ++i;
            }
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeShort(0);
            out.writeInt(this.vertPos.length);
            int i = 0;
            while (i < this.vertPos.length) {
                this.vertPos[i].writeToFile(out);
                if (this.param != null) {
                    int j = 0;
                    while (j < this.param[i].length) {
                        out.writeDouble(this.param[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
            out.writeInt(this.usmoothness.length);
            int i2 = 0;
            while (i2 < this.usmoothness.length) {
                out.writeFloat(this.usmoothness[i2]);
                ++i2;
            }
            out.writeInt(this.vsmoothness.length);
            int i3 = 0;
            while (i3 < this.vsmoothness.length) {
                out.writeFloat(this.vsmoothness[i3]);
                ++i3;
            }
            Joint[] joint = this.skeleton.getJoints();
            int i4 = 0;
            while (i4 < joint.length) {
                joint[i4].coords.writeToFile(out);
                out.writeDouble(joint[i4].angle1.pos);
                out.writeDouble(joint[i4].angle2.pos);
                out.writeDouble(joint[i4].twist.pos);
                out.writeDouble(joint[i4].length.pos);
                ++i4;
            }
        }

        public SplineMeshKeyframe(DataInputStream in, Object parent) throws IOException, InvalidObjectException {
            this();
            short version = in.readShort();
            if (version != 0) {
                throw new InvalidObjectException("");
            }
            this.mesh = (SplineMesh)parent;
            int numVert = in.readInt();
            this.vertPos = new Vec3[numVert];
            if (this.mesh.parameter != null && this.mesh.parameter.length > 0) {
                this.param = new double[numVert][this.mesh.parameter.length];
            }
            int i = 0;
            while (i < numVert) {
                this.vertPos[i] = new Vec3(in);
                if (this.param != null) {
                    int j = 0;
                    while (j < this.param[i].length) {
                        this.param[i][j] = in.readDouble();
                        ++j;
                    }
                }
                ++i;
            }
            this.usmoothness = new float[in.readInt()];
            int i2 = 0;
            while (i2 < this.usmoothness.length) {
                this.usmoothness[i2] = in.readFloat();
                ++i2;
            }
            this.vsmoothness = new float[in.readInt()];
            int i3 = 0;
            while (i3 < this.vsmoothness.length) {
                this.vsmoothness[i3] = in.readFloat();
                ++i3;
            }
            this.skeleton = this.mesh.getSkeleton().duplicate();
            Joint[] joint = this.skeleton.getJoints();
            int i4 = 0;
            while (i4 < joint.length) {
                joint[i4].coords = new CoordinateSystem(in);
                joint[i4].angle1.pos = in.readDouble();
                joint[i4].angle2.pos = in.readDouble();
                joint[i4].twist.pos = in.readDouble();
                joint[i4].length.pos = in.readDouble();
                ++i4;
            }
        }
    }
}

