/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImagesDialog;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.ValueField;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ImageModule
extends Module {
    ImageMap map;
    boolean tilex = true;
    boolean tiley = true;
    boolean mirrorx;
    boolean mirrory;
    boolean wrapx;
    boolean wrapy;
    boolean pointOk;
    boolean colorOk;
    boolean[] valueOk;
    boolean[] gradOk;
    boolean outside;
    double xscale = 1.0;
    double yscale = 1.0;
    double xinv = 1.0;
    double yinv = 1.0;
    double x;
    double y;
    double xsize;
    double ysize;
    double lastBlur;
    PointInfo point;
    RGBColor color = new RGBColor(0.0f, 0.0f, 0.0f);
    Vec2 tempGrad = new Vec2();
    Vec3[] gradient = new Vec3[]{new Vec3(), new Vec3(), new Vec3()};

    public ImageModule(Point position) {
        super("(Image)", new IOPort[]{new IOPort(0, 0, 2, new String[]{"X", "(X)"}), new IOPort(0, 0, 2, new String[]{"Y", "(Y)"})}, new IOPort[]{new IOPort(1, 1, 3, new String[]{"Color"}), new IOPort(0, 1, 3, new String[]{"Red"}), new IOPort(0, 1, 3, new String[]{"Green"}), new IOPort(0, 1, 3, new String[]{"Blue"})}, position);
        this.valueOk = new boolean[3];
        this.gradOk = new boolean[3];
    }

    public void init(PointInfo p) {
        this.point = p;
        this.colorOk = false;
        this.pointOk = false;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
        this.gradOk[2] = false;
        this.gradOk[1] = false;
        this.gradOk[0] = false;
    }

    private void findPoint(double blur) {
        double f;
        this.pointOk = true;
        this.valueOk[2] = false;
        this.valueOk[1] = false;
        this.valueOk[0] = false;
        this.colorOk = false;
        this.x = this.linkFrom[0] == null ? this.point.x : this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur);
        this.y = this.linkFrom[1] == null ? this.point.y : this.linkFrom[1].getAverageValue(this.linkFromIndex[1], blur);
        this.x *= this.xinv;
        this.y *= this.yinv;
        boolean bl = this.outside = !this.tilex && (this.x < 0.0 || this.x > 1.0) || !this.tiley && (this.y < 0.0 || this.y > 1.0);
        if (this.outside) {
            return;
        }
        this.x = this.mirrorx ? (((int)(f = Math.floor(this.x)) & 1) == 0 ? 1.0 + f - this.x : (this.x -= f)) : (this.x -= Math.floor(this.x));
        this.y = this.mirrory ? (((int)(f = Math.floor(this.y)) & 1) == 0 ? 1.0 + f - this.y : (this.y -= f)) : (this.y -= Math.floor(this.y));
        this.xsize = this.linkFrom[0] == null ? 0.5 * this.point.xsize + blur : this.linkFrom[0].getValueError(this.linkFromIndex[0], blur);
        this.ysize = this.linkFrom[1] == null ? 0.5 * this.point.ysize + blur : this.linkFrom[1].getValueError(this.linkFromIndex[1], blur);
        this.xsize *= this.xinv;
        this.ysize *= this.yinv;
        this.wrapx = this.tilex && !this.mirrorx;
        this.wrapy = this.tiley && !this.mirrory;
    }

    public void getColor(int which, RGBColor c, double blur) {
        if (this.colorOk && blur == this.lastBlur) {
            c.copy(this.color);
            return;
        }
        if (this.map == null) {
            this.color.setRGB(0.0f, 0.0f, 0.0f);
            c.copy(this.color);
            return;
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        this.valueOk[2] = true;
        this.valueOk[1] = true;
        this.valueOk[0] = true;
        this.colorOk = true;
        this.lastBlur = blur;
        if (this.outside) {
            this.color.setRGB(0.0f, 0.0f, 0.0f);
            c.copy(this.color);
            return;
        }
        this.map.getColor(this.color, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        c.copy(this.color);
    }

    public double getAverageValue(int which, double blur) {
        int component = which - 1;
        if (this.valueOk[component] && blur == this.lastBlur) {
            if (which == 1) {
                return this.color.getRed();
            }
            if (which == 2) {
                return this.color.getGreen();
            }
            return this.color.getBlue();
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        if (this.outside) {
            return 0.0;
        }
        this.valueOk[component] = true;
        float value = this.map.getComponent(which - 1, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        if (which == 1) {
            this.color.setRGB(value, this.color.getGreen(), this.color.getBlue());
        } else if (which == 2) {
            this.color.setRGB(this.color.getRed(), value, this.color.getBlue());
        } else {
            this.color.setRGB(this.color.getRed(), this.color.getGreen(), value);
        }
        return value;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        int component = which - 1;
        if (this.gradOk[component] && blur == this.lastBlur) {
            grad.set(this.gradient[component]);
            return;
        }
        if (this.map == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        if (!this.pointOk || blur != this.lastBlur) {
            this.findPoint(blur);
        }
        if (this.outside) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        this.map.getGradient(this.tempGrad, component, this.wrapx, this.wrapy, this.x, this.y, this.xsize, this.ysize);
        double dx = this.tempGrad.x * this.xinv;
        double dy = this.tempGrad.y * this.yinv;
        Vec3 g = this.gradient[component];
        if (dx != 0.0) {
            if (this.linkFrom[0] == null) {
                g.set(dx, 0.0, 0.0);
            } else {
                this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
                g.x = dx * grad.x;
                g.y = dx * grad.y;
                g.z = dx * grad.z;
            }
        } else {
            g.set(0.0, 0.0, 0.0);
        }
        if (dy != 0.0) {
            if (this.linkFrom[1] == null) {
                g.y += dy;
            } else {
                this.linkFrom[1].getValueGradient(this.linkFromIndex[1], grad, blur);
                g.x += dy * grad.x;
                g.y += dy * grad.y;
                g.z += dy * grad.z;
            }
        }
        this.gradOk[component] = true;
        grad.set(g);
    }

    public void calcSize() {
        this.bounds.width = 60;
        this.bounds.height = 60;
    }

    protected void drawContents(Graphics g) {
        if (this.map == null) {
            super.drawContents(g);
            return;
        }
        g.drawImage(this.map.getPreview(), this.bounds.x + 5, this.bounds.y + 5, null);
    }

    public Module duplicate() {
        ImageModule mod = new ImageModule(new Point(this.bounds.x, this.bounds.y));
        mod.map = this.map;
        mod.color.copy(this.color);
        mod.tilex = this.tilex;
        mod.tiley = this.tiley;
        mod.mirrorx = this.mirrorx;
        mod.mirrory = this.mirrory;
        mod.wrapx = this.wrapx;
        mod.wrapy = this.wrapy;
        return mod;
    }

    public ImageMap getMap() {
        return this.map;
    }

    public boolean edit(final Frame fr, final Scene theScene) {
        ImageMap oldMap = this.map;
        final ValueField xField = new ValueField(this.xscale, 0, 10);
        final ValueField yField = new ValueField(this.yscale, 0, 10);
        Checkbox tilexBox = new Checkbox("X", this.tilex);
        Checkbox tileyBox = new Checkbox("Y", this.tiley);
        Checkbox mirrorxBox = new Checkbox("X", this.mirrorx);
        Checkbox mirroryBox = new Checkbox("Y", this.mirrory);
        final Canvas preview = new Canvas(){

            public Dimension getPreferredSize() {
                return new Dimension(50, 50);
            }

            public void paint(Graphics g) {
                if (ImageModule.this.map != null) {
                    g.drawImage(ImageModule.this.map.getPreview(), 0, 0, null);
                } else {
                    g.drawRect(1, 1, 48, 48);
                }
            }
        };
        preview.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                ImagesDialog dlg = new ImagesDialog(fr, theScene, ImageModule.this.map);
                if (dlg.getSelection() != ImageModule.this.map && dlg.getSelection() != null) {
                    int h;
                    int w = dlg.getSelection().getWidth();
                    if (w > (h = dlg.getSelection().getHeight())) {
                        xField.setValue(1.0);
                        yField.setValue((double)h / (double)w);
                    } else {
                        xField.setValue((double)w / (double)h);
                        yField.setValue(1.0);
                    }
                }
                ImageModule.this.map = dlg.getSelection();
                preview.repaint();
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(fr, "Click to Set Image:", new Component[]{preview, xField, yField, tilexBox, tileyBox, mirrorxBox, mirroryBox}, new String[]{"", "X Size", "Y Size", "Tile", "", "Mirror", ""});
        if (!dlg.clickedOk()) {
            this.map = oldMap;
            return false;
        }
        this.xscale = xField.getValue();
        this.yscale = yField.getValue();
        this.xinv = 1.0 / this.xscale;
        this.yinv = 1.0 / this.yscale;
        this.tilex = tilexBox.getState();
        this.tiley = tileyBox.getState();
        this.mirrorx = mirrorxBox.getState();
        this.mirrory = mirroryBox.getState();
        return true;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        if (this.map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(theScene.indexOf(this.map));
        }
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.tilex);
        out.writeBoolean(this.tiley);
        out.writeBoolean(this.mirrorx);
        out.writeBoolean(this.mirrory);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        int index = in.readInt();
        this.map = index > -1 ? theScene.getImage(index) : null;
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.xinv = 1.0 / this.xscale;
        this.yinv = 1.0 / this.yscale;
        this.tilex = in.readBoolean();
        this.tiley = in.readBoolean();
        this.mirrorx = in.readBoolean();
        this.mirrory = in.readBoolean();
    }
}

