/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.procedural.PointInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ParameterModule
extends Module {
    double minVal = 0.0;
    double maxVal = 1.0;
    double defaultVal = 0.0;
    int index;
    PointInfo point;

    public ParameterModule(Point position) {
        super("Parameter", new IOPort[0], new IOPort[]{new IOPort(0, 1, 3, new String[]{"Value"})}, position);
    }

    public void init(PointInfo p) {
        this.point = p;
    }

    public double getAverageValue(int which, double blur) {
        if (this.point.param == null || this.point.param.length <= which) {
            return this.defaultVal;
        }
        return this.point.param[this.index];
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public TextureParameter getParameter(Object owner) {
        return new TextureParameter(owner, this.name, this.minVal, this.maxVal, this.defaultVal);
    }

    public boolean edit(Frame fr, Scene theScene) {
        TextField nameField = new TextField(this.name);
        ValueField minField = new ValueField(this.minVal, 0);
        ValueField maxField = new ValueField(this.maxVal, 0);
        ValueField defaultField = new ValueField(this.defaultVal, 0);
        ComponentsDialog dlg = new ComponentsDialog(fr, "Set Parameter Properties:", new Component[]{nameField, minField, maxField, defaultField}, new String[]{Translate.text("Name"), "Minimum", "Maximum", "Default"});
        if (!dlg.clickedOk()) {
            return false;
        }
        this.name = nameField.getText();
        this.minVal = minField.getValue();
        this.maxVal = maxField.getValue();
        this.defaultVal = defaultField.getValue();
        if (this.minVal > this.maxVal) {
            new MessageDialog(fr, "The minimum value cannot be greater than then maximum value.");
            this.edit(fr, theScene);
        }
        if (this.minVal > this.defaultVal || this.maxVal < this.defaultVal) {
            new MessageDialog(fr, "The default value must be between the minimum and maximum values.");
            this.edit(fr, theScene);
        }
        return true;
    }

    public Module duplicate() {
        ParameterModule mod = new ParameterModule(new Point(this.bounds.x, this.bounds.y));
        mod.name = this.name;
        mod.minVal = this.minVal;
        mod.maxVal = this.maxVal;
        mod.defaultVal = this.defaultVal;
        mod.layout();
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeUTF(this.name);
        out.writeDouble(this.minVal);
        out.writeDouble(this.maxVal);
        out.writeDouble(this.defaultVal);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.name = in.readUTF();
        this.minVal = in.readDouble();
        this.maxVal = in.readDouble();
        this.defaultVal = in.readDouble();
        this.layout();
    }
}

