/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.PointInfo;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Procedure {
    OutputModule[] output;
    Module[] module;
    Link[] link;
    static /* synthetic */ Class class$java$awt$Point;

    public Procedure(OutputModule[] output) {
        this.output = output;
        this.module = new Module[0];
        this.link = new Link[0];
    }

    public OutputModule[] getOutputModules() {
        return this.output;
    }

    public Module[] getModules() {
        return this.module;
    }

    public int getModuleIndex(Module mod) {
        int i = 0;
        while (i < this.module.length) {
            if (this.module[i] == mod) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getOutputIndex(Module mod) {
        int i = 0;
        while (i < this.output.length) {
            if (this.output[i] == mod) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addModule(Module mod) {
        Module[] newmod = new Module[this.module.length + 1];
        int i = 0;
        while (i < this.module.length) {
            newmod[i] = this.module[i];
            ++i;
        }
        newmod[this.module.length] = mod;
        this.module = newmod;
    }

    public void deleteModule(int which) {
        Module[] newmod = new Module[this.module.length - 1];
        int i = 0;
        int j = 0;
        while (i < this.module.length) {
            if (i != which) {
                newmod[j++] = this.module[i];
            }
            ++i;
        }
        this.module = newmod;
    }

    public Link[] getLinks() {
        return this.link;
    }

    public void addLink(Link ln) {
        Link[] newlink = new Link[this.link.length + 1];
        int i = 0;
        while (i < this.link.length) {
            newlink[i] = this.link[i];
            ++i;
        }
        newlink[this.link.length] = ln;
        this.link = newlink;
    }

    public void deleteLink(int which) {
        Link[] newlink = new Link[this.link.length - 1];
        if (this.link[which].to.getType() == 0) {
            this.link[which].to.getModule().setInput(this.link[which].to, null);
        } else {
            this.link[which].from.getModule().setInput(this.link[which].from, null);
        }
        int i = 0;
        int j = 0;
        while (i < this.link.length) {
            if (i != which) {
                newlink[j++] = this.link[i];
            }
            ++i;
        }
        this.link = newlink;
    }

    public boolean checkFeedback() {
        int i = 0;
        while (i < this.output.length) {
            int j = 0;
            while (j < this.module.length) {
                this.module[j].checked = false;
                ++j;
            }
            if (this.output[i].checkFeedback()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initForPoint(PointInfo p) {
        int i = 0;
        while (i < this.module.length) {
            this.module[i].init(p);
            ++i;
        }
    }

    public double getOutputValue(int which) {
        return this.output[which].getAverageValue(0, 0.0);
    }

    public void getOutputGradient(int which, Vec3 grad) {
        this.output[which].getValueGradient(0, grad, 0.0);
    }

    public void getOutputColor(int which, RGBColor color) {
        this.output[which].getColor(0, color, 0.0);
    }

    public void copy(Procedure proc) {
        this.module = new Module[proc.module.length];
        int i = 0;
        while (i < this.module.length) {
            this.module[i] = proc.module[i].duplicate();
            ++i;
        }
        this.link = new Link[proc.link.length];
        int i2 = 0;
        while (i2 < this.link.length) {
            Module fromModule = proc.link[i2].from.getModule();
            Module toModule = proc.link[i2].to.getModule();
            int fromIndex = proc.getModuleIndex(fromModule);
            int toIndex = toModule instanceof OutputModule ? proc.getOutputIndex(toModule) : proc.getModuleIndex(toModule);
            IOPort from = this.module[fromIndex].getOutputPorts()[proc.module[fromIndex].getOutputIndex(proc.link[i2].from)];
            IOPort to = toModule instanceof OutputModule ? this.output[toIndex].getInputPorts()[proc.output[toIndex].getInputIndex(proc.link[i2].to)] : this.module[toIndex].getInputPorts()[proc.module[toIndex].getInputIndex(proc.link[i2].to)];
            this.link[i2] = new Link(from, to);
            to.getModule().setInput(to, from);
            ++i2;
        }
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeInt(this.module.length);
        int i = 0;
        while (i < this.module.length) {
            out.writeUTF(this.module[i].getClass().getName());
            out.writeInt(this.module[i].getBounds().x);
            out.writeInt(this.module[i].getBounds().y);
            this.module[i].writeToStream(out, theScene);
            ++i;
        }
        out.writeInt(this.link.length);
        int i2 = 0;
        while (i2 < this.link.length) {
            out.writeInt(this.getModuleIndex(this.link[i2].from.getModule()));
            out.writeInt(this.link[i2].from.getModule().getOutputIndex(this.link[i2].from));
            if (this.link[i2].to.getModule() instanceof OutputModule) {
                out.writeInt(-this.getOutputIndex(this.link[i2].to.getModule()) - 1);
            } else {
                out.writeInt(this.getModuleIndex(this.link[i2].to.getModule()));
                out.writeInt(this.link[i2].to.getModule().getInputIndex(this.link[i2].to));
            }
            ++i2;
        }
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        int i;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        int i2 = 0;
        while (i2 < this.output.length) {
            this.output[i2].setInput(this.output[i2].getInputPorts()[0], null);
            ++i2;
        }
        this.module = new Module[in.readInt()];
        try {
            i = 0;
            while (i < this.module.length) {
                String classname = in.readUTF();
                Point p = new Point(in.readInt(), in.readInt());
                Class cls = ModellingApp.getClass(classname);
                Constructor con = cls.getConstructor(class$java$awt$Point == null ? Procedure.class$("java.awt.Point") : class$java$awt$Point);
                this.module[i] = (Module)con.newInstance(p);
                this.module[i].readFromStream(in, theScene);
                ++i;
            }
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        this.link = new Link[in.readInt()];
        i = 0;
        while (i < this.link.length) {
            IOPort from = this.module[in.readInt()].getOutputPorts()[in.readInt()];
            int j = in.readInt();
            IOPort to = j < 0 ? this.output[-j - 1].getInputPorts()[0] : this.module[j].getInputPorts()[in.readInt()];
            this.link[i] = new Link(from, to);
            to.getModule().setInput(to, from);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

