/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.ModellingApp;
import artofillusion.object.ObjectInfo;
import artofillusion.script.ScriptedObject;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class ScriptedObjectEditorWindow
extends Frame
implements ActionListener,
KeyListener {
    private EditingWindow window;
    private ObjectInfo info;
    private TextArea scriptText;
    private String scriptName;
    private static String scriptDir;

    public ScriptedObjectEditorWindow(EditingWindow parent, ObjectInfo obj) {
        super("Script '" + obj.name + "'");
        this.window = parent;
        this.info = obj;
        this.scriptName = "Untitled.bsh";
        if (scriptDir == null) {
            scriptDir = ModellingApp.OBJECT_SCRIPT_DIRECTORY;
        }
        this.scriptText = new TextArea(((ScriptedObject)this.info.object).getScript(), 10, 60);
        this.scriptText.setFont(ModellingApp.defaultFont);
        this.add((Component)this.scriptText, "Center");
        Panel p = new Panel();
        this.add((Component)p, "South");
        Button b = new Button("OK");
        p.add(b);
        b.setActionCommand("execute");
        b.addActionListener(this);
        b = new Button("Load...");
        p.add(b);
        b.setActionCommand("load");
        b.addActionListener(this);
        b = new Button("Save...");
        p.add(b);
        b.setActionCommand("save");
        b.addActionListener(this);
        b = new Button("Parameters...");
        p.add(b);
        b.setActionCommand("parameters");
        b.addActionListener(this);
        b = new Button("Cancel");
        p.add(b);
        b.setActionCommand("close");
        b.addActionListener(this);
        this.pack();
        ModellingApp.centerWindow(this);
        this.show();
    }

    public void actionPerformed(ActionEvent ev) {
        String command = ev.getActionCommand();
        if ("execute".equals(command)) {
            this.commitChanges();
        }
        if ("load".equals(command)) {
            this.loadScript();
        }
        if ("save".equals(command)) {
            this.saveScript();
        }
        if ("parameters".equals(command)) {
            new ParametersDialog();
        }
        if ("close".equals(command)) {
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadScript() {
        FileDialog dlg = new FileDialog((Frame)this, "Select Script to Load", 0);
        dlg.setDirectory(scriptDir);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        scriptDir = dlg.getDirectory();
        this.setCursor(3);
        File f = new File(dlg.getDirectory(), dlg.getFile());
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(f));
            StringBuffer buf = new StringBuffer();
            while ((c = in.read()) != -1) {
                void var5_6;
                buf.append((char)var5_6);
            }
            in.close();
            this.scriptText.setText(buf.toString());
        }
        catch (Exception ex) {
            new MessageDialog((Frame)this, new String[]{"An error occurred while reading the script:", ex.getMessage()});
        }
        this.scriptName = dlg.getFile();
        this.setCursor(0);
    }

    private void saveScript() {
        FileDialog dlg = new FileDialog((Frame)this, "Save Script to File", 1);
        dlg.setFile(this.scriptName);
        dlg.setDirectory(scriptDir);
        dlg.show();
        if (dlg.getFile() == null) {
            return;
        }
        scriptDir = dlg.getDirectory();
        this.setCursor(3);
        File f = new File(dlg.getDirectory(), dlg.getFile());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(this.scriptText.getText().toCharArray());
            out.close();
        }
        catch (Exception ex) {
            new MessageDialog((Frame)this, new String[]{"An error occurred while writing the script:", ex.getMessage()});
        }
        this.scriptName = dlg.getFile();
        this.setCursor(0);
    }

    private void commitChanges() {
        ScriptedObject so = (ScriptedObject)this.info.object;
        this.setCursor(3);
        so.setScript(this.scriptText.getText());
        so.sceneChanged(this.info, this.window.getScene());
        this.window.updateImage();
        this.setCursor(0);
        this.dispose();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() != '\r' && e.getKeyChar() != '\n') {
            return;
        }
        String text = this.scriptText.getText();
        int pos = this.scriptText.getCaretPosition();
        int endWhiteSpace = pos - 1;
        int startLine = pos - 1;
        boolean extraIndent = startLine > 0 && text.charAt(startLine - 1) == '{';
        while (startLine > 0) {
            char c = text.charAt(startLine - 1);
            if (c == '\r' || c == '\n') break;
            --startLine;
            if (Character.isWhitespace(c)) continue;
            endWhiteSpace = startLine;
        }
    }

    private class ParametersDialog
    extends Dialog
    implements ActionListener,
    ItemListener,
    TextListener {
        private ScriptedObject script;
        private List paramList;
        private TextField nameField;
        private ValueField valueField;
        private String[] name;
        private double[] value;
        private int current;

        public ParametersDialog() {
            super(ScriptedObjectEditorWindow.this, "Object Parameters", true);
            this.script = (ScriptedObject)((ScriptedObjectEditorWindow)ScriptedObjectEditorWindow.this).info.object;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.fill = 1;
            gc.weighty = 1.0;
            this.name = new String[this.script.getNumParameters()];
            this.value = new double[this.script.getNumParameters()];
            int i = 0;
            while (i < this.name.length) {
                this.name[i] = this.script.getParameterName(i);
                this.value[i] = this.script.getParameterValue(i);
                ++i;
            }
            this.paramList = new List();
            this.add((Component)this.paramList, gc);
            this.buildParameterList();
            this.paramList.addItemListener(this);
            gc.fill = 2;
            gc.weighty = 0.0;
            gc.gridwidth = 1;
            this.add((Component)new Label(Translate.text("Name")), gc);
            this.add((Component)new Label("Value"), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.nameField = new TextField();
            this.add((Component)this.nameField, gc);
            this.nameField.addTextListener(this);
            this.nameField.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ ParametersDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusLost(FocusEvent ev) {
                    ParametersDialog.access$300(this.this$1).replaceItem(ParametersDialog.access$100(this.this$1)[ParametersDialog.access$200(this.this$1)], ParametersDialog.access$200(this.this$1));
                }
            });
            this.valueField = new ValueField(0.0, 0);
            this.add((Component)this.valueField, gc);
            this.valueField.addTextListener(this);
            gc.gridx = 0;
            gc.gridwidth = 2;
            Panel p = new Panel();
            this.add((Component)p, gc);
            Button b = new Button("Add");
            p.add(b);
            b.setActionCommand("add");
            b.addActionListener(this);
            b = new Button("Remove");
            p.add(b);
            b.setActionCommand("remove");
            b.addActionListener(this);
            p.add(Translate.button("ok", this));
            p.add(Translate.button("cancel", this));
            this.setSelectedParameter(this.name.length == 0 ? -1 : 0);
            this.pack();
            this.show();
        }

        private void buildParameterList() {
            this.paramList.removeAll();
            int i = 0;
            while (i < this.name.length) {
                this.paramList.add(this.name[i]);
                ++i;
            }
            if (this.name.length == 0) {
                this.paramList.add("(no parameters)");
            }
        }

        private void setSelectedParameter(int which) {
            if (which != this.paramList.getSelectedIndex()) {
                this.paramList.select(which);
            }
            this.current = which;
            if (which == -1) {
                this.nameField.setEnabled(false);
                this.valueField.setEnabled(false);
            } else {
                this.nameField.setEnabled(true);
                this.valueField.setEnabled(true);
                this.nameField.setText(this.name[which]);
                this.valueField.setValue(this.value[which]);
            }
        }

        public void textValueChanged(TextEvent ev) {
            if (this.current < 0 || this.current > this.name.length) {
                return;
            }
            if (ev.getSource() == this.nameField) {
                this.name[this.current] = this.nameField.getText();
            } else {
                this.value[this.current] = this.valueField.getValue();
            }
        }

        public void itemStateChanged(ItemEvent ev) {
            this.setSelectedParameter(this.paramList.getSelectedIndex());
        }

        public void actionPerformed(ActionEvent ev) {
            String command = ev.getActionCommand();
            if ("add".equals(command)) {
                String[] newName = new String[this.name.length + 1];
                double[] newValue = new double[this.value.length + 1];
                System.arraycopy(this.name, 0, newName, 0, this.name.length);
                System.arraycopy(this.value, 0, newValue, 0, this.value.length);
                newName[this.name.length] = "";
                newValue[this.value.length] = 0.0;
                this.name = newName;
                this.value = newValue;
                this.buildParameterList();
                this.setSelectedParameter(this.name.length - 1);
                this.nameField.requestFocus();
            }
            if ("remove".equals(command)) {
                int which = this.paramList.getSelectedIndex();
                String[] newName = new String[this.name.length - 1];
                double[] newValue = new double[this.value.length - 1];
                int i = 0;
                int j = 0;
                while (i < this.name.length) {
                    if (i != which) {
                        newName[j] = this.name[i];
                        newValue[j] = this.value[i];
                        ++j;
                    }
                    ++i;
                }
                this.name = newName;
                this.value = newValue;
                this.buildParameterList();
                this.setSelectedParameter(-1);
            }
            if ("ok".equals(command)) {
                this.script.setParameters(this.name, this.value);
                this.dispose();
            }
            if ("cancel".equals(command)) {
                this.dispose();
            }
        }

        static /* synthetic */ String[] access$100(ParametersDialog x0) {
            return x0.name;
        }

        static /* synthetic */ int access$200(ParametersDialog x0) {
            return x0.current;
        }

        static /* synthetic */ List access$300(ParametersDialog x0) {
            return x0.paramList;
        }
    }
}

