/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureParameter;
import artofillusion.animation.Actor;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Linear2DTriangle;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMappedTriangle;
import artofillusion.ui.ValueField;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ProjectionMapping
extends Mapping2D {
    CoordinateSystem coords;
    double ax;
    double bx;
    double cx;
    double dx;
    double ay;
    double by;
    double cy;
    double dy;
    double xscale;
    double yscale;
    double matScaleX;
    double matScaleY;
    boolean coordsFromParams;
    int numTextureParams;
    TextureParameter xparam;
    TextureParameter yparam;
    TextureParameter zparam;

    public ProjectionMapping(Texture theTexture) {
        super(theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dy = 0.5;
        this.dx = 0.5;
        this.findCoefficients();
    }

    public static String getName() {
        return "Projection";
    }

    private void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.matScaleX = Math.abs(1.0 / this.xscale);
        this.matScaleY = Math.abs(1.0 / this.yscale);
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = vert[v1];
        Vec3 c2 = vert[v2];
        Vec3 c3 = vert[v3];
        if (this.coordsFromParams) {
            return new UVMappedTriangle(v1, v2, v3, n1, n2, n3, this);
        }
        return new Linear2DTriangle(v1, v2, v3, n1, n2, n3, c1.x * this.ax + c1.y * this.bx + c1.z * this.cx - this.dx, c1.x * this.ay + c1.y * this.by + c1.z * this.cy - this.dy, c2.x * this.ax + c2.y * this.bx + c2.z * this.cx - this.dx, c2.x * this.ay + c2.y * this.by + c2.z * this.cy - this.dy, c3.x * this.ax + c3.y * this.bx + c3.z * this.cx - this.dx, c3.x * this.ay + c3.y * this.by + c3.z * this.cy - this.dy, this);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        if (!(tri instanceof UVMappedTriangle)) {
            return;
        }
        UVMappedTriangle uv = (UVMappedTriangle)tri;
        double x1 = p1[this.numTextureParams];
        double y1 = p1[this.numTextureParams + 1];
        double z1 = p1[this.numTextureParams + 2];
        double x2 = p2[this.numTextureParams];
        double y2 = p2[this.numTextureParams + 1];
        double z2 = p2[this.numTextureParams + 2];
        double x3 = p3[this.numTextureParams];
        double y3 = p3[this.numTextureParams + 1];
        double z3 = p3[this.numTextureParams + 2];
        uv.setTextureCoordinates((float)(x1 * this.ax + y1 * this.bx + z1 * this.cx - this.dx), (float)(x1 * this.ay + y1 * this.by + z1 * this.cy - this.dy), (float)(x2 * this.ax + y2 * this.bx + z2 * this.cx - this.dx), (float)(x2 * this.ay + y2 * this.by + z2 * this.cy - this.dy), (float)(x3 * this.ax + y3 * this.bx + z3 * this.cx - this.dx), (float)(x3 * this.ay + y3 * this.by + z3 * this.cy - this.dy), mesh.vert[uv.v1], mesh.vert[uv.v2], mesh.vert[uv.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.coordsFromParams && param.length > this.numTextureParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTextureSpec(spec, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
        } else {
            this.texture.getTextureSpec(spec, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
        }
        if (this.texture.bumpMapped()) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s * this.ax + t * this.ay, s * this.bx + t * this.by, s * this.cx + t * this.cy);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, boolean front, double size, double time, double[] param) {
        if (!this.appliesToFace(front)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.coordsFromParams && param.length > this.numTextureParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTransparency(trans, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
        } else {
            this.texture.getTransparency(trans, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        if (this.coordsFromParams && param.length > this.numTextureParams && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            return this.texture.getDisplacement(x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
        }
        return this.texture.getDisplacement(pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, size * this.matScaleX, size * this.matScaleY, time, param);
    }

    public Vec2[] findTextureCoordinates(Mesh mesh, TextureParameter[] param) {
        int ix = -1;
        int iy = -1;
        int iz = -1;
        if (this.coordsFromParams) {
            int i = 0;
            while (i < param.length) {
                if (param[i].equals(this.xparam)) {
                    ix = i;
                } else if (param[i].equals(this.yparam)) {
                    iy = i;
                } else if (param[i].equals(this.zparam)) {
                    iz = i;
                }
                ++i;
            }
        }
        MeshVertex[] vert = mesh.getVertices();
        Vec2[] uv = new Vec2[vert.length];
        int i = 0;
        while (i < vert.length) {
            double z;
            double y;
            double x;
            if (ix == -1) {
                x = vert[i].r.x;
                y = vert[i].r.y;
                z = vert[i].r.z;
            } else {
                x = vert[i].param[ix];
                y = vert[i].param[iy];
                z = vert[i].param[iz];
            }
            uv[i] = new Vec2(x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy);
            ++i;
        }
        return uv;
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        ProjectionMapping map = new ProjectionMapping(tex);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.setAppliesTo(this.appliesTo());
        map.xparam = this.xparam;
        map.yparam = this.yparam;
        map.zparam = this.zparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        ProjectionMapping map = (ProjectionMapping)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.setAppliesTo(map.appliesTo());
        this.xparam = map.xparam;
        this.yparam = map.yparam;
        this.zparam = map.zparam;
    }

    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.xparam == null) {
            this.xparam = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.yparam = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.zparam = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.xparam.type = 1;
            this.yparam.type = 2;
            this.zparam.type = 3;
            this.xparam.assignNewID();
            this.yparam.assignNewID();
            this.zparam.assignNewID();
        }
        p[this.numTextureParams] = this.xparam;
        p[this.numTextureParams + 1] = this.yparam;
        p[this.numTextureParams + 2] = this.zparam;
        return p;
    }

    public Panel getEditingPanel(ObjectInfo obj, MaterialPreviewer preview) {
        return new Editor(obj.object, preview);
    }

    public ProjectionMapping(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends Panel
    implements ItemListener,
    TextListener {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField xtransField;
        ValueField ytransField;
        Checkbox coordsFromParamsBox;
        Choice applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            this.theObject = obj;
            this.preview = preview;
            GridBagConstraints gc = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            gc.gridwidth = 6;
            gc.insets = new Insets(0, 0, 0, 5);
            gc.gridy = 0;
            this.add((Component)new Label("Scale:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 1;
            this.add((Component)new Label("X"), gc);
            this.xscaleField = new ValueField((double)Math.round(ProjectionMapping.this.xscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.xscaleField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yscaleField = new ValueField((double)Math.round(ProjectionMapping.this.yscale * 1000.0) / 1000.0, 2, 5);
            this.add((Component)this.yscaleField, gc);
            gc.gridwidth = 6;
            gc.gridy = 2;
            this.add((Component)new Label("Center:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 3;
            this.add((Component)new Label("X"), gc);
            this.xtransField = new ValueField((double)Math.round(ProjectionMapping.this.dx * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xtransField, gc);
            this.add((Component)new Label("Y"), gc);
            this.ytransField = new ValueField((double)Math.round(ProjectionMapping.this.dy * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.ytransField, gc);
            gc.gridwidth = 6;
            gc.gridy = 4;
            this.add((Component)new Label("Rotation:"), gc);
            gc.gridwidth = 1;
            gc.gridy = 5;
            double[] angles = ProjectionMapping.this.coords.getRotationAngles();
            this.add((Component)new Label("X"), gc);
            this.xrotField = new ValueField((double)Math.round(angles[0] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.xrotField, gc);
            this.add((Component)new Label("Y"), gc);
            this.yrotField = new ValueField((double)Math.round(angles[1] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.yrotField, gc);
            this.add((Component)new Label("Z"), gc);
            this.zrotField = new ValueField((double)Math.round(angles[2] * 1000.0) / 1000.0, 0, 5);
            this.add((Component)this.zrotField, gc);
            gc.gridwidth = 6;
            gc.gridy = 6;
            Panel p = new Panel();
            this.add((Component)p, gc);
            p.add(new Label("Apply To:"));
            this.applyToChoice = new Choice();
            p.add(this.applyToChoice);
            this.applyToChoice.add("Front and Back Faces");
            this.applyToChoice.add("Front Faces Only");
            this.applyToChoice.add("Back Faces Only");
            this.applyToChoice.select(ProjectionMapping.this.appliesTo());
            gc.gridy = 7;
            this.coordsFromParamsBox = new Checkbox("Bind Texture Coordinates to Surface", ProjectionMapping.this.coordsFromParams);
            this.add((Component)this.coordsFromParamsBox, gc);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof TriangleMesh || this.theObject instanceof SplineMesh || this.theObject instanceof Actor);
            this.xscaleField.addTextListener(this);
            this.yscaleField.addTextListener(this);
            this.xtransField.addTextListener(this);
            this.ytransField.addTextListener(this);
            this.xrotField.addTextListener(this);
            this.yrotField.addTextListener(this);
            this.zrotField.addTextListener(this);
            this.coordsFromParamsBox.addItemListener(this);
            this.applyToChoice.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            ProjectionMapping.this.coordsFromParams = this.coordsFromParamsBox.getState();
            ProjectionMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(ProjectionMapping.this.getTexture(), ProjectionMapping.this);
            this.preview.render();
        }

        public void textValueChanged(TextEvent e) {
            ProjectionMapping.this.xscale = this.xscaleField.getValue();
            ProjectionMapping.this.yscale = this.yscaleField.getValue();
            ProjectionMapping.this.dx = this.xtransField.getValue();
            ProjectionMapping.this.dy = this.ytransField.getValue();
            ProjectionMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            ProjectionMapping.this.findCoefficients();
            this.preview.render();
        }
    }
}

