/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DividedPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    Component child1;
    Component child2;
    float weight;
    boolean vertical;
    boolean revalidate1;
    boolean revalidate2;
    boolean hide1;
    boolean hide2;
    boolean initialized;
    int offset;
    static final int BAR_WIDTH = 8;

    public DividedPanel(Component c1, Component c2, float weight1, float weight2, boolean isVertical) {
        this.child1 = c1;
        this.child2 = c2;
        this.weight = weight1 + weight2 == 0.0f ? 0.5f : weight1 / (weight1 + weight2);
        this.vertical = isVertical;
        this.add(this.child1);
        this.add(this.child2);
        this.child1.setCursor(this.child1.getCursor());
        this.child2.setCursor(this.child2.getCursor());
        this.setCursor(Cursor.getPredefinedCursor(this.vertical ? 8 : 11));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void doLayout() {
        Dimension dim = this.getSize();
        Dimension prefSize1 = this.child1.getPreferredSize();
        Dimension prefSize2 = this.child2.getPreferredSize();
        Rectangle bounds1 = new Rectangle();
        Rectangle bounds2 = new Rectangle();
        if (this.hide1) {
            bounds1.height = 0;
            bounds1.width = 0;
            bounds1.y = 0;
            bounds1.x = 0;
            bounds2.y = 0;
            bounds2.x = 0;
            bounds2.width = dim.width;
            bounds2.height = dim.height;
        } else if (this.hide2) {
            bounds2.height = 0;
            bounds2.width = 0;
            bounds2.y = 0;
            bounds2.x = 0;
            bounds1.y = 0;
            bounds1.x = 0;
            bounds1.width = dim.width;
            bounds1.height = dim.height;
        } else if (this.vertical) {
            if (!this.initialized) {
                int available = dim.height - prefSize1.height - prefSize2.height - 8;
                this.weight = ((float)prefSize1.height + (float)available * this.weight) / (float)dim.height;
                this.initialized = true;
            }
            bounds2.x = 0;
            bounds1.x = 0;
            bounds1.width = bounds2.width = dim.width;
            bounds1.y = 0;
            bounds1.height = (int)((float)dim.height * this.weight);
            bounds2.y = bounds1.height + 8;
            bounds2.height = dim.height - bounds2.y;
        } else {
            int available;
            if (!this.initialized) {
                available = dim.width - prefSize1.width - prefSize2.width - 8;
                this.weight = ((float)prefSize1.width + (float)available * this.weight) / (float)dim.width;
                this.initialized = true;
            }
            bounds2.y = 0;
            bounds1.y = 0;
            bounds1.height = bounds2.height = dim.height;
            bounds1.x = 0;
            available = dim.width - prefSize1.width - prefSize2.width - 8;
            bounds1.width = (int)((float)dim.width * this.weight);
            bounds2.x = bounds1.width + 8;
            bounds2.width = dim.width - bounds2.x;
        }
        this.child1.setBounds(bounds1);
        this.child2.setBounds(bounds2);
    }

    public void setHidden(boolean hide1, boolean hide2) {
        this.hide1 = hide1;
        this.hide2 = hide2;
        this.doLayout();
        this.child1.validate();
        this.child2.validate();
    }

    public void setLiveValidate(boolean validate1, boolean validate2) {
        this.revalidate1 = validate1;
        this.revalidate2 = validate2;
    }

    public void mousePressed(MouseEvent ev) {
        this.offset = this.vertical ? ev.getY() - this.child1.getSize().height : ev.getX() - this.child1.getSize().width;
    }

    public void mouseReleased(MouseEvent ev) {
        this.child1.validate();
        this.child2.validate();
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }

    public void mouseDragged(MouseEvent ev) {
        Rectangle bounds1 = this.child1.getBounds();
        Rectangle bounds2 = this.child2.getBounds();
        Dimension dim = this.getSize();
        Point pos = ev.getPoint();
        if (this.vertical) {
            if (pos.y < 0) {
                pos.y = 0;
            }
            if (pos.y > dim.height - 8) {
                pos.y = dim.height - 8;
            }
            bounds1.height = pos.y - this.offset;
            bounds2.y = bounds1.height + 8;
            bounds2.height = dim.height - bounds2.y;
            this.weight = (float)bounds1.height / (float)dim.height;
        } else {
            if (pos.x < 0) {
                pos.x = 0;
            }
            if (pos.x > dim.width - 8) {
                pos.x = dim.width - 8;
            }
            bounds1.width = pos.x - this.offset;
            bounds2.x = bounds1.width + 8;
            bounds2.width = dim.width - bounds2.x;
            this.weight = (float)bounds1.width / (float)dim.width;
        }
        this.child1.setBounds(bounds1);
        this.child2.setBounds(bounds2);
        if (this.revalidate1) {
            this.child1.validate();
        }
        if (this.revalidate2) {
            this.child2.validate();
        }
        this.repaint();
    }
}

