/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.Callback;

public class EventProcessor
extends Thread {
    private Callback nextEvent;

    public EventProcessor() {
        this.start();
    }

    public void run() {
        try {
            while (true) {
                Callback c = this.getNextEvent();
                c.execute();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void addEvent(Callback event) {
        this.nextEvent = event;
        this.notify();
    }

    public void stopProcessing() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized Callback getNextEvent() throws InterruptedException {
        if (this.nextEvent == null) {
            this.wait();
        }
        Callback c = this.nextEvent;
        this.nextEvent = null;
        return c;
    }
}

