/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.ValueChecker;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class ValueField
extends TextField
implements TextListener,
FocusListener {
    double value;
    int constraints;
    TextListener listener = null;
    boolean processEvents;
    boolean validEventsOnly = true;
    boolean clicked;
    ValueChecker check;
    public static final int NONE = 0;
    public static final int NONNEGATIVE = 1;
    public static final int NONZERO = 2;
    public static final int POSITIVE = 3;
    public static final int INTEGER = 4;

    public ValueField(double value, int constraints) {
        this.constraints = constraints;
        this.setValue(value);
        super.addTextListener(this);
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                ValueField.this.processEvents = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                ValueField.this.clicked = true;
            }
        });
    }

    public ValueField(float value, int constraints) {
        this((double)value, constraints);
    }

    public ValueField(double value, int constraints, int columns) {
        super(columns);
        this.constraints = constraints;
        this.setValue(value);
        super.addTextListener(this);
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                ValueField.this.processEvents = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                ValueField.this.clicked = true;
            }
        });
    }

    public ValueField(float value, int constraints, int columns) {
        this((double)value, constraints, columns);
    }

    public void setValueChecker(ValueChecker vc) {
        this.check = vc;
    }

    public ValueChecker getValueChecker() {
        return this.check;
    }

    public boolean isTextValid() {
        double val = this.value;
        try {
            val = (this.constraints & 4) != 0 ? (double)Integer.parseInt(this.getText()) : new Double(this.getText());
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return this.isValid(val);
    }

    public boolean isValid(double val) {
        if (val < 0.0 && (this.constraints & 1) != 0) {
            return false;
        }
        if (val == 0.0 && (this.constraints & 2) != 0) {
            return false;
        }
        return this.check == null || this.check.isValid(val);
    }

    public void checkIfValid() {
        if (!this.isValid(this.value)) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(Color.black);
        }
    }

    public void textValueChanged(TextEvent e) {
        double val = this.value;
        double oldVal = this.value;
        try {
            if (this.processEvents) {
                val = (this.constraints & 4) != 0 ? (double)Integer.parseInt(this.getText()) : new Double(this.getText());
            }
        }
        catch (NumberFormatException ex) {
            this.setForeground(Color.red);
            return;
        }
        this.processEvents = false;
        if (!this.isTextValid()) {
            this.setForeground(Color.red);
            if (!this.validEventsOnly) {
                this.listener.textValueChanged(e);
            }
        } else {
            this.value = val;
            this.setForeground(Color.black);
            if (this.listener != null && val != oldVal) {
                this.listener.textValueChanged(e);
            }
        }
    }

    public void focusGained(FocusEvent e) {
        if (!this.clicked) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
        this.clicked = false;
    }

    public void focusLost(FocusEvent e) {
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double val) {
        String text;
        if (Double.isNaN(val)) {
            text = "";
        } else if ((this.constraints & 4) != 0) {
            text = Integer.toString((int)val);
        } else if (val == 0.0 || val == -0.0) {
            text = "0.0";
        } else {
            int digits = (int)Math.floor(Math.log(Math.abs(val)) / Math.log(10.0));
            double scale = Math.pow(10.0, digits < 0 ? (double)(2 - digits) : 3.0);
            text = Double.toString((double)Math.round(val * scale) / scale);
        }
        this.value = val;
        this.setText(text);
    }

    public void addTextListener(TextListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public void removeTextListener(TextListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public void sendValidEventsOnly(boolean validOnly) {
        this.validEventsOnly = validOnly;
    }
}

