/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raster;

import artofillusion.Camera;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.material.MaterialSpec;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SpotLight;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.ValueField;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

public class Raster
implements Runnable {
    ObjectInfo[] light;
    Panel configPanel;
    Checkbox transparentBox;
    Checkbox adaptiveBox;
    Checkbox hideBackfaceBox;
    Choice shadeChoice;
    Choice aliasChoice;
    Choice sampleChoice;
    ValueField errorField;
    ValueField smoothField;
    int[] pixel;
    int[] imagePixel;
    int width;
    int height;
    int envMode;
    int imageWidth;
    int imageHeight;
    int shadingMode;
    int samplesPerPixel;
    int subsample;
    float[] zbuffer;
    long updateTime;
    MemoryImageSource imageSource;
    Scene theScene;
    Camera theCamera;
    ImageObserver observer;
    Image img;
    Thread renderThread;
    Vec3[] tempVec;
    Vec3[] lightPosition;
    Vec3[] lightDirection;
    RGBColor color;
    RGBColor[] tempColor;
    RGBColor ambColor;
    RGBColor envColor;
    RGBColor fogColor;
    TextureMapping envMapping;
    TextureSpec surfSpec;
    TextureSpec surfSpec2;
    MaterialSpec matSpec;
    double time;
    double smoothing;
    double smoothScale;
    double depthOfField;
    double focalDist;
    double surfaceError;
    double fogDist;
    boolean fog;
    boolean transparentBackground;
    boolean adaptive;
    boolean hideBackfaces;
    boolean positionNeeded;
    public static final int GOURAUD = 0;
    public static final int HYBRID = 1;
    public static final int PHONG = 2;
    public static final double TOL = 1.0E-12;

    public synchronized void renderScene(Scene theScene, Camera camera, ImageObserver obs, double depthOfField, double focalDist) {
        Dimension dim = camera.getSize();
        this.observer = obs;
        this.theScene = theScene;
        this.theCamera = camera.duplicate();
        this.depthOfField = depthOfField;
        this.focalDist = focalDist;
        this.time = theScene.getTime();
        if (this.imagePixel == null || this.imageWidth != dim.width || this.imageHeight != dim.height) {
            this.imageWidth = dim.width;
            this.imageHeight = dim.height;
            this.imagePixel = new int[this.imageWidth * this.imageHeight];
            this.imageSource = new MemoryImageSource(this.imageWidth, this.imageHeight, this.imagePixel, 0, this.imageWidth);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        }
        this.width = this.imageWidth * this.samplesPerPixel;
        this.height = this.imageHeight * this.samplesPerPixel;
        if (this.samplesPerPixel == 1) {
            this.pixel = this.imagePixel;
            if (this.zbuffer == null || this.zbuffer.length != this.width * this.height) {
                this.zbuffer = new float[this.width * this.height];
            }
        } else if (this.pixel == null || this.pixel.length != this.width * this.height) {
            this.pixel = new int[this.width * this.height];
            this.zbuffer = new float[this.width * this.height];
        }
        this.theCamera.setSize(this.width, this.height);
        this.theCamera.setDistToScreen(this.theCamera.getDistToScreen() * (double)this.samplesPerPixel);
        this.color = new RGBColor();
        this.surfSpec = new TextureSpec();
        this.surfSpec2 = new TextureSpec();
        this.matSpec = new MaterialSpec();
        this.tempColor = new RGBColor[3];
        int i = 0;
        while (i < this.tempColor.length) {
            this.tempColor[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            ++i;
        }
        this.tempVec = new Vec3[4];
        int i2 = 0;
        while (i2 < this.tempVec.length) {
            this.tempVec[i2] = new Vec3();
            ++i2;
        }
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public synchronized void cancelRendering(Scene sc) {
        Thread t = this.renderThread;
        if (this.theScene != sc) {
            return;
        }
        this.renderThread = null;
        if (t == null) {
            return;
        }
        try {
            while (t.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finish();
    }

    public Panel getConfigPanel() {
        if (this.configPanel == null) {
            GridBagConstraints c = new GridBagConstraints();
            this.configPanel = new Panel();
            this.configPanel.setLayout(new GridBagLayout());
            c.gridx = 0;
            c.anchor = 13;
            this.configPanel.add((Component)new Label("Surface Accuracy:"), c);
            this.configPanel.add((Component)new Label("Shading Method:"), c);
            this.configPanel.add((Component)new Label("Supersampling:"), c);
            c.gridx = 1;
            c.gridwidth = 2;
            c.anchor = 17;
            c.insets = new Insets(0, 5, 0, 0);
            this.errorField = new ValueField(0.02, 3, 6);
            this.configPanel.add((Component)this.errorField, c);
            this.shadeChoice = new Choice();
            this.configPanel.add((Component)this.shadeChoice, c);
            this.shadeChoice.add("Gouraud");
            this.shadeChoice.add("Hybrid");
            this.shadeChoice.add("Phong");
            this.shadeChoice.select(1);
            c.gridwidth = 1;
            c.gridx = -1;
            c.gridy = 2;
            this.aliasChoice = new Choice();
            this.configPanel.add((Component)this.aliasChoice, c);
            this.aliasChoice.add("None");
            this.aliasChoice.add("Edges");
            this.aliasChoice.add("Everything");
            this.sampleChoice = new Choice();
            this.configPanel.add((Component)this.sampleChoice, c);
            this.sampleChoice.add("2x2");
            this.sampleChoice.add("3x3");
            this.sampleChoice.setEnabled(false);
            c.gridx = 0;
            c.gridwidth = 3;
            c.gridy = -1;
            c.anchor = 10;
            this.transparentBox = new Checkbox("Transparent Background", false);
            this.configPanel.add((Component)this.transparentBox, c);
            Button b = new Button("Advanced...");
            this.configPanel.add((Component)b, c);
            this.smoothField = new ValueField(1.0, 1);
            this.adaptiveBox = new Checkbox("Reduce Accuracy for Distant Objects", true);
            this.hideBackfaceBox = new Checkbox("Eliminate Backfaces", true);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Container parent = Raster.this.configPanel.getParent();
                    while (!(parent instanceof Frame)) {
                        parent = parent.getParent();
                    }
                    Raster.this.showAdvancedWindow((Frame)parent);
                }
            });
            this.aliasChoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Raster.this.sampleChoice.setEnabled(Raster.this.aliasChoice.getSelectedIndex() > 0);
                }
            });
        }
        return this.configPanel;
    }

    private void showAdvancedWindow(Frame parent) {
        Panel p = new Panel();
        GridBagConstraints c = new GridBagConstraints();
        p.setLayout(new GridBagLayout());
        c.gridx = 0;
        c.anchor = 13;
        c.insets = new Insets(0, 0, 0, 5);
        p.add((Component)new Label("Texture Smoothing:"), c);
        c.gridx = 1;
        c.fill = 2;
        p.add((Component)this.smoothField, c);
        c.gridx = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        p.add((Component)this.adaptiveBox, c);
        p.add((Component)this.hideBackfaceBox, c);
        this.smoothing = this.smoothField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.hideBackfaces = this.hideBackfaceBox.getState();
        PanelDialog dlg = new PanelDialog(parent, "Advanced Options", p);
        if (!dlg.clickedOk()) {
            this.smoothField.setValue(this.smoothing);
            this.adaptiveBox.setState(this.adaptive);
            this.hideBackfaceBox.setState(this.hideBackfaces);
        }
    }

    public boolean recordConfiguration() {
        this.smoothing = this.smoothField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.hideBackfaces = this.hideBackfaceBox.getState();
        this.surfaceError = this.errorField.getValue();
        this.shadingMode = this.shadeChoice.getSelectedIndex();
        this.transparentBackground = this.transparentBox.getState();
        if (this.aliasChoice.getSelectedIndex() == 0) {
            this.subsample = 1;
            this.samplesPerPixel = 1;
        } else if (this.aliasChoice.getSelectedIndex() == 1) {
            this.samplesPerPixel = this.subsample = this.sampleChoice.getSelectedIndex() + 2;
        } else {
            this.samplesPerPixel = this.sampleChoice.getSelectedIndex() + 2;
            this.subsample = 1;
        }
        return true;
    }

    public void configurePreview() {
        this.transparentBackground = false;
        this.smoothing = 1.0;
        this.hideBackfaces = true;
        this.adaptive = true;
        this.surfaceError = 0.02;
        this.shadingMode = 1;
        this.subsample = 1;
        this.samplesPerPixel = 1;
    }

    void findLights() {
        Vector<ObjectInfo> lt = new Vector<ObjectInfo>();
        Mat4 trans = this.theCamera.getWorldToView();
        this.positionNeeded = false;
        int i = 0;
        while (i < this.theScene.getNumObjects()) {
            ObjectInfo info = this.theScene.getObject(i);
            if (info.object instanceof Light && info.visible) {
                lt.addElement(info);
            }
            ++i;
        }
        this.light = new ObjectInfo[lt.size()];
        i = 0;
        while (i < this.light.length) {
            this.light[i] = (ObjectInfo)lt.elementAt(i);
            if (!(this.light[i].object instanceof DirectionalLight)) {
                this.positionNeeded = true;
            }
            ++i;
        }
        this.lightPosition = new Vec3[this.light.length];
        this.lightDirection = new Vec3[this.light.length];
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        boolean done = false;
        if (this.renderThread != thisThread) {
            return;
        }
        this.updateTime = System.currentTimeMillis();
        this.findLights();
        this.ambColor = this.theScene.getAmbientColor();
        this.envColor = this.theScene.getEnvironmentColor();
        this.envMapping = this.theScene.getEnvironmentMapping();
        this.envMode = this.theScene.getEnvironmentMode();
        this.fogColor = this.theScene.getFogColor();
        this.fog = this.theScene.getFogState();
        this.fogDist = this.theScene.getFogDistance();
        int i = this.pixel.length - 1;
        while (i >= 0) {
            this.pixel[i] = 0;
            this.zbuffer[i] = Float.MAX_VALUE;
            --i;
        }
        Vec3 viewdir = this.theCamera.getViewToWorld().timesDirection(Vec3.vz());
        Point p = new Point(this.width / 2, this.height / 2);
        Vec3 orig = this.theCamera.getCameraCoordinates().getOrigin();
        Vec3 center = this.theCamera.convertScreenToWorld(p, this.focalDist);
        ++p.x;
        Vec3 hvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(center);
        --p.x;
        ++p.y;
        Vec3 vvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(center);
        --p.y;
        this.smoothScale = this.smoothing * hvec.length() / this.focalDist;
        i = this.theScene.getNumObjects() - 1;
        while (i >= 0) {
            ObjectInfo obj = this.theScene.getObject(i);
            this.theCamera.setObjectTransform(obj.coords.fromLocal());
            this.renderObject(obj, orig, viewdir, obj.coords.toLocal());
            if (thisThread != this.renderThread) {
                this.finish();
                return;
            }
            if (System.currentTimeMillis() - this.updateTime > 5000L) {
                this.updateImage();
            }
            --i;
        }
        Vec3 dir = this.tempVec[1];
        if (this.fog || !this.transparentBackground) {
            i = this.pixel.length - 1;
            while (i >= 0) {
                float transparency = 1.0f - (float)(this.pixel[i] >> 24 & 0xFF) / 255.0f;
                this.tempColor[0].setARGB(this.pixel[i]);
                if (this.fog && transparency < 1.0f) {
                    float fract1 = (float)Math.exp((double)(-this.zbuffer[i]) / this.fogDist);
                    float fract2 = 1.0f - fract1;
                    this.tempColor[0].setRGB(fract1 * this.tempColor[0].getRed() + fract2 * this.fogColor.getRed(), fract1 * this.tempColor[0].getGreen() + fract2 * this.fogColor.getGreen(), fract1 * this.tempColor[0].getBlue() + fract2 * this.fogColor.getBlue());
                    transparency *= fract1;
                }
                if (!this.transparentBackground && transparency > 0.0f) {
                    float fract = 1.0f - transparency;
                    if (this.envMode == 0) {
                        this.tempColor[0].setRGB(fract * this.tempColor[0].getRed() + transparency * this.envColor.getRed(), fract * this.tempColor[0].getGreen() + transparency * this.envColor.getGreen(), fract * this.tempColor[0].getBlue() + transparency * this.envColor.getBlue());
                    } else {
                        double h = (double)(i % this.width) - (double)this.width / 2.0;
                        double v = (double)(i / this.width) - (double)this.height / 2.0;
                        dir.x = center.x + h * hvec.x + v * vvec.x;
                        dir.y = center.y + h * hvec.y + v * vvec.y;
                        dir.z = center.z + h * hvec.z + v * vvec.z;
                        dir.subtract(orig);
                        dir.normalize();
                        this.envMapping.getTextureSpec(dir, this.surfSpec, true, this.smoothScale, this.time, null);
                        if (this.envMode == 1) {
                            this.tempColor[0].setRGB(fract * this.tempColor[0].getRed() + transparency * this.surfSpec.diffuse.getRed(), fract * this.tempColor[0].getGreen() + transparency * this.surfSpec.diffuse.getGreen(), fract * this.tempColor[0].getBlue() + transparency * this.surfSpec.diffuse.getBlue());
                        } else {
                            this.tempColor[0].setRGB(fract * this.tempColor[0].getRed() + transparency * this.surfSpec.emissive.getRed(), fract * this.tempColor[0].getGreen() + transparency * this.surfSpec.emissive.getGreen(), fract * this.tempColor[0].getBlue() + transparency * this.surfSpec.emissive.getBlue());
                        }
                        transparency = 0.0f;
                    }
                }
                this.pixel[i] = this.calcARGB(this.tempColor[0], transparency);
                --i;
            }
        }
        this.createFinalImage();
        this.finish();
    }

    private void updateImage() {
        if (this.imagePixel != this.pixel) {
            int i1 = 0;
            int i2 = 0;
            while (i1 < this.imageHeight) {
                int j1 = 0;
                int j2 = 0;
                while (j1 < this.imageWidth) {
                    this.imagePixel[i1 * this.imageWidth + j1] = this.pixel[i2 * this.width + j2];
                    ++j1;
                    j2 += this.samplesPerPixel;
                }
                ++i1;
                i2 += this.samplesPerPixel;
            }
        }
        this.imageSource.newPixels();
        this.observer.imageUpdate(this.img, 8, 0, 0, this.imageWidth, this.imageHeight);
        this.updateTime = System.currentTimeMillis();
    }

    private void createFinalImage() {
        int n = this.samplesPerPixel * this.samplesPerPixel;
        if (this.imagePixel != this.pixel) {
            int i1 = 0;
            int i2 = 0;
            while (i1 < this.imageHeight) {
                int j1 = 0;
                int j2 = 0;
                while (j1 < this.imageWidth) {
                    int a = 0;
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    int k = 0;
                    while (k < this.samplesPerPixel) {
                        int base = this.width * (i2 + k) + j2;
                        int m = 0;
                        while (m < this.samplesPerPixel) {
                            int color = this.pixel[base + m];
                            a += color >> 24 & 0xFF;
                            r += color >> 16 & 0xFF;
                            g += color >> 8 & 0xFF;
                            b += color & 0xFF;
                            ++m;
                        }
                        ++k;
                    }
                    this.imagePixel[i1 * this.imageWidth + j1] = ((a /= n) << 24) + ((r /= n) << 16) + ((g /= n) << 8) + (b /= n);
                    ++j1;
                    j2 += this.samplesPerPixel;
                }
                ++i1;
                i2 += this.samplesPerPixel;
            }
        }
        this.imageSource.newPixels();
    }

    private void finish() {
        this.light = null;
        this.theScene = null;
        this.theCamera = null;
        this.envMapping = null;
        this.renderThread = null;
        ImageObserver obs = this.observer;
        this.observer = null;
        if (obs != null) {
            obs.imageUpdate(this.img, 32, 0, 0, this.imageWidth, this.imageHeight);
        }
        System.gc();
    }

    private int calcARGB(RGBColor color, double t) {
        if (!this.transparentBackground || t <= 0.0) {
            return color.getARGB();
        }
        if (t >= 1.0) {
            return 0;
        }
        double scale = 255.0 / (1.0 - t);
        int a = (int)(255.0 * (1.0 - t));
        int r = (int)((double)color.getRed() * scale);
        int g = (int)((double)color.getGreen() * scale);
        int b = (int)((double)color.getBlue() * scale);
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    private void renderObject(ObjectInfo obj, Vec3 orig, Vec3 viewdir, Mat4 toLocal) {
        double distToScreen;
        double dist;
        if (Thread.currentThread() != this.renderThread) {
            return;
        }
        if (!obj.visible) {
            return;
        }
        Object3D theObject = obj.object;
        if (this.theCamera.visibility(obj.getBounds()) == 0) {
            return;
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration enumeration = ((ObjectCollection)theObject).getObjects(obj, false, this.theScene);
            Mat4 fromLocal = this.theCamera.getObjectToWorld();
            while (enumeration.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)enumeration.nextElement();
                CoordinateSystem coords = elem.coords.duplicate();
                coords.transformCoordinates(fromLocal);
                this.theCamera.setObjectTransform(coords.fromLocal());
                this.renderObject(elem, orig, viewdir, coords.toLocal());
            }
            return;
        }
        double tol = this.adaptive ? ((dist = obj.getBounds().distanceToPoint(toLocal.times(orig))) < (distToScreen = this.theCamera.getDistToScreen()) ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        RenderingMesh mesh = obj.getRenderingMesh(tol);
        if (mesh == null) {
            return;
        }
        if (Thread.currentThread() != this.renderThread) {
            return;
        }
        viewdir = toLocal.timesDirection(viewdir);
        int i = this.light.length - 1;
        while (i >= 0) {
            this.lightPosition[i] = toLocal.times(this.light[i].coords.getOrigin());
            if (!(this.light[i].object instanceof PointLight)) {
                this.lightDirection[i] = toLocal.timesDirection(this.light[i].coords.getZDirection());
            }
            --i;
        }
        boolean bumpMap = theObject.getTexture().bumpMapped();
        if (theObject.getTexture().displacementMapped()) {
            this.renderMeshDisplaced(mesh, viewdir, tol, theObject.isClosed(), bumpMap);
        } else if (this.shadingMode == 0) {
            this.renderMeshGouraud(mesh, viewdir, theObject.isClosed());
        } else if (this.shadingMode == 1 && !bumpMap) {
            this.renderMeshHybrid(mesh, viewdir, theObject.isClosed());
        } else {
            this.renderMeshPhong(mesh, viewdir, theObject.isClosed(), bumpMap);
        }
    }

    private void calcLight(Vec3 pos, Vec3 norm, Vec3 viewdir, Vec3 faceNorm, double roughness, RGBColor diffuse, RGBColor specular) {
        Vec3 reflectDir = this.tempVec[0];
        Vec3 lightDir = this.tempVec[1];
        double viewDot = viewdir.dot(norm);
        double faceDot = viewdir.dot(faceNorm);
        RGBColor outputColor = this.tempColor[0];
        if (diffuse != null) {
            diffuse.copy(this.ambColor);
        }
        if (specular != null) {
            if (this.envMode == 0) {
                specular.copy(this.envColor);
            } else {
                reflectDir.set(norm);
                reflectDir.scale(-2.0 * viewDot);
                reflectDir.add(viewdir);
                this.theCamera.getViewToWorld().transformDirection(reflectDir);
                this.envMapping.getTextureSpec(reflectDir, this.surfSpec2, true, this.smoothScale, this.time, null);
                if (this.envMode == 1) {
                    specular.copy(this.surfSpec2.diffuse);
                } else {
                    specular.copy(this.surfSpec2.emissive);
                }
            }
        }
        if (viewDot < 0.0 && faceDot > 0.0) {
            viewDot = 1.0E-12;
        } else if (viewDot > 0.0 && faceDot < 0.0) {
            viewDot = -1.0E-12;
        }
        int i = this.light.length - 1;
        while (i >= 0) {
            block21: {
                double lightDot;
                double fatt;
                double distToLight;
                Light lt;
                block19: {
                    block20: {
                        Vec3 lightPos;
                        block18: {
                            lt = (Light)this.light[i].object;
                            lightPos = this.lightPosition[i];
                            distToLight = 0.0;
                            fatt = 0.0;
                            lightDot = 0.0;
                            if (!(lt instanceof PointLight)) break block18;
                            lightDir.set(pos);
                            lightDir.subtract(lightPos);
                            distToLight = lightDir.length();
                            lightDir.normalize();
                            break block19;
                        }
                        if (!(lt instanceof SpotLight)) break block20;
                        lightDir.set(pos);
                        lightDir.subtract(lightPos);
                        distToLight = lightDir.length();
                        lightDir.normalize();
                        fatt = lightDir.dot(this.lightDirection[i]);
                        if (!(fatt < ((SpotLight)lt).getAngleCosine())) break block19;
                        break block21;
                    }
                    if (lt instanceof DirectionalLight) {
                        lightDir.set(this.lightDirection[i]);
                    }
                }
                lt.getLight(outputColor, (float)distToLight);
                if (lt instanceof SpotLight) {
                    outputColor.scale(Math.pow(fatt, ((SpotLight)lt).getExponent()));
                }
                if (lt.isAmbient()) {
                    if (diffuse != null) {
                        diffuse.add(outputColor.getRed(), outputColor.getGreen(), outputColor.getBlue());
                    }
                } else {
                    lightDot = lightDir.dot(norm);
                    if (!(lightDot >= 0.0 && viewDot <= 0.0 || lightDot <= 0.0 && viewDot >= 0.0)) {
                        if (diffuse != null) {
                            float dot = lightDot < 0.0 ? (float)(-lightDot) : (float)lightDot;
                            diffuse.add(outputColor.getRed() * dot, outputColor.getGreen() * dot, outputColor.getBlue() * dot);
                        }
                        if (specular != null) {
                            lightDir.add(viewdir);
                            lightDir.normalize();
                            double dot = lightDir.dot(norm);
                            dot = dot < 0.0 ? -dot : dot;
                            outputColor.scale(Math.pow(dot, (1.0 - roughness) * 128.0 + 1.0));
                            specular.add(outputColor);
                        }
                    }
                }
            }
            --i;
        }
    }

    private Vec3[] clipTriangle(Vec3 v1, Vec3 v2, Vec3 v3, float z1, float z2, float z3, float[] newz, double[] newu, double[] newv) {
        Vec3 u4;
        Vec3 u32;
        Vec3 u22;
        Vec3 u12;
        double clip = this.theCamera.getClipDistance();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        boolean c1 = (double)z1 < clip;
        boolean c2 = (double)z2 < clip;
        boolean c3 = (double)z3 < clip;
        int clipCount = 0;
        if (c1) {
            ++clipCount;
        }
        if (c2) {
            ++clipCount;
        }
        if (c3) {
            ++clipCount;
        }
        if (clipCount == 2) {
            Vec3 u32;
            Vec3 u22;
            Vec3 u12;
            if (!c1) {
                u12 = v1;
                newz[0] = z1;
                newu[0] = 1.0;
                newv[0] = 0.0;
                double f2 = ((double)z1 - clip) / (double)(z1 - z2);
                double f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
                newz[1] = (float)(f1 * (double)z1 + f2 * (double)z2);
                newu[1] = f1;
                newv[1] = f2;
                f2 = ((double)z1 - clip) / (double)(z1 - z3);
                f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
                newz[2] = (float)(f1 * (double)z1 + f2 * (double)z3);
                newu[2] = f1;
                newv[2] = 0.0;
            } else if (!c2) {
                u22 = v2;
                newz[1] = z2;
                newu[1] = 0.0;
                newv[1] = 1.0;
                double f2 = ((double)z2 - clip) / (double)(z2 - z3);
                double f1 = 1.0 - f2;
                u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
                newz[2] = (float)(f1 * (double)z2 + f2 * (double)z3);
                newu[2] = 0.0;
                newv[2] = f1;
                f2 = ((double)z2 - clip) / (double)(z2 - z1);
                f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
                newz[0] = (float)(f1 * (double)z2 + f2 * (double)z1);
                newu[0] = f2;
                newv[0] = f1;
            } else {
                u32 = v3;
                newz[2] = z3;
                newu[2] = 0.0;
                newv[2] = 0.0;
                double f2 = ((double)z3 - clip) / (double)(z3 - z1);
                double f1 = 1.0 - f2;
                u12 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
                newz[0] = (float)(f1 * (double)z3 + f2 * (double)z1);
                newu[0] = f2;
                newv[0] = 0.0;
                f2 = ((double)z3 - clip) / (double)(z3 - z2);
                f1 = 1.0 - f2;
                u22 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
                newz[1] = (float)(f1 * (double)z3 + f2 * (double)z2);
                newu[1] = 0.0;
                newv[1] = f2;
            }
            return new Vec3[]{u12, u22, u32};
        }
        if (c1) {
            u12 = v2;
            newz[0] = z2;
            newu[0] = 0.0;
            newv[0] = 1.0;
            u22 = v3;
            newz[1] = z3;
            newu[1] = 0.0;
            newv[1] = 0.0;
            double f1 = ((double)z2 - clip) / (double)(z2 - z1);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v1.x + f2 * v2.x, f1 * v1.y + f2 * v2.y, f1 * v1.z + f2 * v2.z);
            newz[2] = (float)(f1 * (double)z1 + f2 * (double)z2);
            newu[2] = f1;
            newv[2] = f2;
            f1 = ((double)z3 - clip) / (double)(z3 - z1);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v1.x + f2 * v3.x, f1 * v1.y + f2 * v3.y, f1 * v1.z + f2 * v3.z);
            newz[3] = (float)(f1 * (double)z1 + f2 * (double)z3);
            newu[3] = f1;
            newv[3] = 0.0;
        } else if (c2) {
            u12 = v3;
            newz[0] = z3;
            newu[0] = 0.0;
            newv[0] = 0.0;
            u22 = v1;
            newz[1] = z1;
            newu[1] = 1.0;
            newv[1] = 0.0;
            double f1 = ((double)z3 - clip) / (double)(z3 - z2);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v2.x + f2 * v3.x, f1 * v2.y + f2 * v3.y, f1 * v2.z + f2 * v3.z);
            newz[2] = (float)(f1 * (double)z2 + f2 * (double)z3);
            newu[2] = 0.0;
            newv[2] = f1;
            f1 = ((double)z1 - clip) / (double)(z1 - z2);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v2.x + f2 * v1.x, f1 * v2.y + f2 * v1.y, f1 * v2.z + f2 * v1.z);
            newz[3] = (float)(f1 * (double)z2 + f2 * (double)z1);
            newu[3] = f2;
            newv[3] = f1;
        } else {
            u12 = v1;
            newz[0] = z1;
            newu[0] = 1.0;
            newv[0] = 0.0;
            u22 = v2;
            newz[1] = z2;
            newu[1] = 0.0;
            newv[1] = 1.0;
            double f1 = ((double)z1 - clip) / (double)(z1 - z3);
            double f2 = 1.0 - f1;
            u32 = new Vec3(f1 * v3.x + f2 * v1.x, f1 * v3.y + f2 * v1.y, f1 * v3.z + f2 * v1.z);
            newz[2] = (float)(f1 * (double)z3 + f2 * (double)z1);
            newu[2] = f2;
            newv[2] = 0.0;
            f1 = ((double)z2 - clip) / (double)(z2 - z3);
            f2 = 1.0 - f1;
            u4 = new Vec3(f1 * v3.x + f2 * v2.x, f1 * v3.y + f2 * v2.y, f1 * v3.z + f2 * v2.z);
            newz[3] = (float)(f1 * (double)z3 + f2 * (double)z2);
            newu[3] = 0.0;
            newv[3] = f2;
        }
        return new Vec3[]{u12, u22, u32, u4};
    }

    private void renderMeshGouraud(RenderingMesh mesh, Vec3 viewdir, boolean isClosed) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)this.theCamera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        double distToScreen = this.theCamera.getDistToScreen();
        double tol = this.smoothScale;
        RGBColor[] diffuse = new RGBColor[4];
        RGBColor[] specular = new RGBColor[4];
        Mat4 toView = this.theCamera.getObjectToView();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        boolean hide = this.hideBackfaces && isClosed;
        int i = 0;
        while (i < 4) {
            diffuse[i] = new RGBColor();
            specular[i] = new RGBColor();
            ++i;
        }
        i = vert.length - 1;
        while (i >= 0) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
            --i;
        }
        i = mesh.triangle.length - 1;
        while (i >= 0) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                boolean backface;
                boolean bl = backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
                if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                    Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv);
                    Vec2[] clipPos2D = new Vec2[clipPos.length];
                    int j = clipPos.length - 1;
                    while (j >= 0) {
                        clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                        double u = clipu[j];
                        double v = clipv[j];
                        double w = 1.0 - u - v;
                        tri.getTextureSpec(this.surfSpec, !backface, u, v, 1.0 - u - v, tol, this.time);
                        this.tempVec[2].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                        this.tempVec[2].normalize();
                        this.calcLight(clipPos[j], this.tempVec[2], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[j], specular[j]);
                        --j;
                    }
                    this.renderTriangleGouraud(clipPos2D[0], clipz[0], clipu[0], clipv[0], diffuse[0], specular[0], clipPos2D[1], clipz[1], clipu[1], clipv[1], diffuse[1], specular[1], clipPos2D[2], clipz[2], clipu[2], clipv[2], diffuse[2], specular[2], tri, clip, !backface);
                    if (clipPos.length == 4) {
                        this.renderTriangleGouraud(clipPos2D[1], clipz[1], clipu[1], clipv[1], diffuse[1], specular[1], clipPos2D[2], clipz[2], clipu[2], clipv[2], diffuse[2], specular[2], clipPos2D[3], clipz[3], clipu[3], clipv[3], diffuse[3], specular[3], tri, clip, !backface);
                    }
                } else if (!hide || !backface) {
                    if ((double)z[v1] > distToScreen) {
                        tol = this.smoothScale * (double)z[v1];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 1.0, 0.0, 0.0, tol, this.time);
                    this.calcLight(vert[v1], norm[n1], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[0], specular[0]);
                    if ((double)z[v2] > distToScreen) {
                        tol = this.smoothScale * (double)z[v2];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 0.0, 1.0, 0.0, tol, this.time);
                    this.calcLight(vert[v2], norm[n2], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[1], specular[1]);
                    if ((double)z[v3] > distToScreen) {
                        tol = this.smoothScale * (double)z[v3];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 0.0, 0.0, 1.0, tol, this.time);
                    this.calcLight(vert[v3], norm[n3], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[2], specular[2]);
                    this.renderTriangleGouraud(pos[v1], z[v1], 1.0, 0.0, diffuse[0], specular[0], pos[v2], z[v2], 0.0, 1.0, diffuse[1], specular[1], pos[v3], z[v3], 0.0, 0.0, diffuse[2], specular[2], tri, clip, !backface);
                }
            }
            --i;
        }
    }

    private void renderTriangleGouraud(Vec2 pos1, float zf1, double uf1, double vf1, RGBColor diffuse1, RGBColor specular1, Vec2 pos2, float zf2, double uf2, double vf2, RGBColor diffuse2, RGBColor specular2, Vec2 pos3, float zf3, double uf3, double vf3, RGBColor diffuse3, RGBColor specular3, RenderingTriangle tri, double clip, boolean front) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        float dspecblue;
        float specblue;
        float dspecgreen;
        float specgreen;
        float dspecred;
        float specred;
        float ddifblue;
        float difblue;
        float ddifgreen;
        float difgreen;
        float ddifred;
        float difred;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        double delta;
        int right;
        int left;
        int index;
        int yend;
        float mspecblue2;
        float mspecgreen2;
        float mspecred2;
        float mdifblue2;
        float mdifgreen2;
        float mdifred2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        float specblueend;
        float specgreenend;
        float specredend;
        float difblueend;
        float difgreenend;
        float difredend;
        double vend;
        double uend;
        float zend;
        double xend;
        RGBColor spec3;
        RGBColor dif3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        RGBColor spec2;
        RGBColor dif2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        RGBColor spec1;
        RGBColor dif1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        boolean doSubsample;
        double distToScreen = this.theCamera.getDistToScreen();
        int prevLeft = this.width;
        int prevRight = -1;
        boolean bl = doSubsample = this.subsample > 1;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            dif1 = diffuse1;
            spec1 = specular1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                spec2 = specular2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                spec3 = specular3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                spec2 = specular3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                spec3 = specular2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            dif1 = diffuse2;
            spec1 = specular2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                spec2 = specular1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                spec3 = specular3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                spec2 = specular3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                spec3 = specular1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            dif1 = diffuse3;
            spec1 = specular3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                spec2 = specular1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                spec3 = specular2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                spec2 = specular2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                spec3 = specular1;
            }
        }
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        float ddifred1 = dif3.getRed() - dif1.getRed();
        float ddifgreen1 = dif3.getGreen() - dif1.getGreen();
        float ddifblue1 = dif3.getBlue() - dif1.getBlue();
        float dspecred1 = spec3.getRed() - spec1.getRed();
        float dspecgreen1 = spec3.getGreen() - spec1.getGreen();
        float dspecblue1 = spec3.getBlue() - spec1.getBlue();
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        float ddifred2 = dif2.getRed() - dif1.getRed();
        float ddifgreen2 = dif2.getGreen() - dif1.getGreen();
        float ddifblue2 = dif2.getBlue() - dif1.getBlue();
        float dspecred2 = spec2.getRed() - spec1.getRed();
        float dspecgreen2 = spec2.getGreen() - spec1.getGreen();
        float dspecblue2 = spec2.getBlue() - spec1.getBlue();
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        float mdifred1 = ddifred1 * denom;
        float mdifgreen1 = ddifgreen1 * denom;
        float mdifblue1 = ddifblue1 * denom;
        float mspecred1 = dspecred1 * denom;
        float mspecgreen1 = dspecgreen1 * denom;
        float mspecblue1 = dspecblue1 * denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        float difredstart = difredend = dif1.getRed();
        float difgreenstart = difgreenend = dif1.getGreen();
        float difbluestart = difblueend = dif1.getBlue();
        float specredstart = specredend = spec1.getRed();
        float specgreenstart = specgreenend = spec1.getGreen();
        float specbluestart = specblueend = spec1.getBlue();
        int y = (int)Math.round(y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mspecred2 = dspecred2 * denom;
            mspecgreen2 = dspecgreen2 * denom;
            mspecblue2 = dspecblue2 * denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                difredstart = (float)((double)difredstart + (double)mdifred1 * dy2);
                difredend = (float)((double)difredend + (double)mdifred2 * dy2);
                difgreenstart = (float)((double)difgreenstart + (double)mdifgreen1 * dy2);
                difgreenend = (float)((double)difgreenend + (double)mdifgreen2 * dy2);
                difbluestart = (float)((double)difbluestart + (double)mdifblue1 * dy2);
                difblueend = (float)((double)difblueend + (double)mdifblue2 * dy2);
                specredstart = (float)((double)specredstart + (double)mspecred1 * dy2);
                specredend = (float)((double)specredend + (double)mspecred2 * dy2);
                specgreenstart = (float)((double)specgreenstart + (double)mspecgreen1 * dy2);
                specgreenend = (float)((double)specgreenend + (double)mspecgreen2 * dy2);
                specbluestart = (float)((double)specbluestart + (double)mspecblue1 * dy2);
                specblueend = (float)((double)specblueend + (double)mspecblue2 * dy2);
                y = (int)Math.round(y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                specredstart -= mspecred1 * (float)y;
                specredend -= mspecred2 * (float)y;
                specgreenstart -= mspecgreen1 * (float)y;
                specgreenend -= mspecgreen2 * (float)y;
                specbluestart -= mspecblue1 * (float)y;
                specblueend -= mspecblue2 * (float)y;
                y = 0;
            }
            yend = (int)Math.round(y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    specred = specredstart;
                    dspecred = specredend - specredstart;
                    specgreen = specgreenstart;
                    dspecgreen = specgreenend - specgreenstart;
                    specblue = specbluestart;
                    dspecblue = specblueend - specbluestart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    specred = specredend;
                    dspecred = specredstart - specredend;
                    specgreen = specgreenend;
                    dspecgreen = specgreenstart - specgreenend;
                    specblue = specblueend;
                    dspecblue = specbluestart - specblueend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dspecred *= denom;
                    dspecgreen *= denom;
                    dspecblue *= denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    difred = (float)((double)difred - (double)ddifred * delta);
                    difgreen = (float)((double)difgreen - (double)ddifgreen * delta);
                    difblue = (float)((double)difblue - (double)ddifblue * delta);
                    specred = (float)((double)specred - (double)dspecred * delta);
                    specgreen = (float)((double)specgreen - (double)dspecgreen * delta);
                    specblue = (float)((double)specblue - (double)dspecblue * delta);
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.hilight.getRed() * specred + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.hilight.getGreen() * specgreen + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.hilight.getBlue() * specblue + this.surfSpec.emissive.getBlue());
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        specred += dspecred;
                        specgreen += dspecgreen;
                        specblue += dspecblue;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                specredstart += mspecred1;
                specgreenstart += mspecgreen1;
                specbluestart += mspecblue1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                specredend += mspecred2;
                specgreenend += mspecgreen2;
                specblueend += mspecblue2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        ddifred2 = dif3.getRed() - dif2.getRed();
        ddifgreen2 = dif3.getGreen() - dif2.getGreen();
        ddifblue2 = dif3.getBlue() - dif2.getBlue();
        dspecred2 = spec3.getRed() - spec2.getRed();
        dspecgreen2 = spec3.getGreen() - spec2.getGreen();
        dspecblue2 = spec3.getBlue() - spec2.getBlue();
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mspecred2 = dspecred2 * denom;
            mspecgreen2 = dspecgreen2 * denom;
            mspecblue2 = dspecblue2 * denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            difredend = dif2.getRed();
            difgreenend = dif2.getGreen();
            difblueend = dif2.getBlue();
            specredend = spec2.getRed();
            specgreenend = spec2.getGreen();
            specblueend = spec2.getBlue();
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                specredstart -= mspecred1 * (float)y;
                specredend -= mspecred2 * (float)y;
                specgreenstart -= mspecgreen1 * (float)y;
                specgreenend -= mspecgreen2 * (float)y;
                specbluestart -= mspecblue1 * (float)y;
                specblueend -= mspecblue2 * (float)y;
                y = 0;
            }
            yend = (int)Math.round(y3 < (double)this.height ? y3 : (double)this.height);
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    specred = specredstart;
                    dspecred = specredend - specredstart;
                    specgreen = specgreenstart;
                    dspecgreen = specgreenend - specgreenstart;
                    specblue = specbluestart;
                    dspecblue = specblueend - specbluestart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    specred = specredend;
                    dspecred = specredstart - specredend;
                    specgreen = specgreenend;
                    dspecgreen = specgreenstart - specgreenend;
                    specblue = specblueend;
                    dspecblue = specbluestart - specblueend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dspecred *= denom;
                    dspecgreen *= denom;
                    dspecblue *= denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    difred = (float)((double)difred - (double)ddifred * delta);
                    difgreen = (float)((double)difgreen - (double)ddifgreen * delta);
                    difblue = (float)((double)difblue - (double)ddifblue * delta);
                    specred = (float)((double)specred - (double)dspecred * delta);
                    specgreen = (float)((double)specgreen - (double)dspecgreen * delta);
                    specblue = (float)((double)specblue - (double)dspecblue * delta);
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.hilight.getRed() * specred + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.hilight.getGreen() * specgreen + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.hilight.getBlue() * specblue + this.surfSpec.emissive.getBlue());
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        specred += dspecred;
                        specgreen += dspecgreen;
                        specblue += dspecblue;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                specredstart += mspecred1;
                specgreenstart += mspecgreen1;
                specbluestart += mspecblue1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                specredend += mspecred2;
                specgreenend += mspecgreen2;
                specblueend += mspecblue2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshHybrid(RenderingMesh mesh, Vec3 viewdir, boolean isClosed) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec3[] clipNorm = new Vec3[4];
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)this.theCamera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        double distToScreen = this.theCamera.getDistToScreen();
        double tol = this.smoothScale;
        RGBColor[] diffuse = new RGBColor[4];
        Mat4 toView = this.theCamera.getObjectToView();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        boolean hide = this.hideBackfaces && isClosed;
        int i = 0;
        while (i < 4) {
            diffuse[i] = new RGBColor();
            clipNorm[i] = new Vec3();
            ++i;
        }
        i = vert.length - 1;
        while (i >= 0) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
            --i;
        }
        i = mesh.triangle.length - 1;
        while (i >= 0) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                boolean backface;
                boolean bl = backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
                if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                    Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv);
                    Vec2[] clipPos2D = new Vec2[clipPos.length];
                    int j = clipPos.length - 1;
                    while (j >= 0) {
                        clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                        double u = clipu[j];
                        double v = clipv[j];
                        double w = 1.0 - u - v;
                        tri.getTextureSpec(this.surfSpec, !backface, u, v, 1.0 - u - v, tol, this.time);
                        clipNorm[j].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                        clipNorm[j].normalize();
                        this.calcLight(clipPos[j], this.tempVec[2], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[j], null);
                        --j;
                    }
                    this.renderTriangleHybrid(clipPos2D[0], clipz[0], clipPos[0], clipNorm[0], clipu[0], clipv[0], diffuse[0], clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], diffuse[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], diffuse[2], tri, viewdir, mesh.faceNorm[i], clip, !backface);
                    if (clipPos.length == 4) {
                        this.renderTriangleHybrid(clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], diffuse[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], diffuse[2], clipPos2D[3], clipz[3], clipPos[3], clipNorm[3], clipu[3], clipv[3], diffuse[3], tri, viewdir, mesh.faceNorm[i], clip, !backface);
                    }
                } else if (!hide || !backface) {
                    if ((double)z[v1] > distToScreen) {
                        tol = this.smoothScale * (double)z[v1];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 1.0, 0.0, 0.0, tol, this.time);
                    this.calcLight(vert[v1], norm[n1], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[0], null);
                    if ((double)z[v2] > distToScreen) {
                        tol = this.smoothScale * (double)z[v2];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 0.0, 1.0, 0.0, tol, this.time);
                    this.calcLight(vert[v2], norm[n2], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[1], null);
                    if ((double)z[v3] > distToScreen) {
                        tol = this.smoothScale * (double)z[v3];
                    }
                    tri.getTextureSpec(this.surfSpec, !backface, 0.0, 0.0, 1.0, tol, this.time);
                    this.calcLight(vert[v3], norm[n3], viewdir, mesh.faceNorm[i], this.surfSpec.roughness, diffuse[2], null);
                    this.renderTriangleHybrid(pos[v1], z[v1], vert[v1], norm[n1], 1.0, 0.0, diffuse[0], pos[v2], z[v2], vert[v2], norm[n2], 0.0, 1.0, diffuse[1], pos[v3], z[v3], vert[v3], norm[n3], 0.0, 0.0, diffuse[2], tri, viewdir, mesh.faceNorm[i], clip, !backface);
                }
            }
            --i;
        }
    }

    private void renderTriangleHybrid(Vec2 pos1, float zf1, Vec3 vert1, Vec3 normf1, double uf1, double vf1, RGBColor diffuse1, Vec2 pos2, float zf2, Vec3 vert2, Vec3 normf2, double uf2, double vf2, RGBColor diffuse2, Vec2 pos3, float zf3, Vec3 vert3, Vec3 normf3, double uf3, double vf3, RGBColor diffuse3, RenderingTriangle tri, Vec3 viewdir, Vec3 faceNorm, double clip, boolean front) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        double dnormz;
        double normz;
        double dnormy;
        double normy;
        double dnormx;
        double normx;
        float ddifblue;
        float difblue;
        float ddifgreen;
        float difgreen;
        float ddifred;
        float difred;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        double delta;
        int right;
        int left;
        int index;
        int yend;
        double mnormz2;
        double mnormy2;
        double mnormx2;
        float mdifblue2;
        float mdifgreen2;
        float mdifred2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        double normzend;
        double normyend;
        double normxend;
        float difblueend;
        float difgreenend;
        float difredend;
        double vend;
        double uend;
        float zend;
        double xend;
        Vec3 norm3;
        RGBColor dif3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        Vec3 norm2;
        RGBColor dif2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        Vec3 norm1;
        RGBColor dif1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        boolean doSubsample;
        RGBColor specular = this.tempColor[1];
        double distToScreen = this.theCamera.getDistToScreen();
        int prevLeft = this.width;
        int prevRight = -1;
        boolean bl = doSubsample = this.subsample > 1;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            dif1 = diffuse1;
            norm1 = normf1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                norm2 = normf2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                norm2 = normf3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                norm3 = normf2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            dif1 = diffuse2;
            norm1 = normf2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                norm2 = normf1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                dif3 = diffuse3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                dif2 = diffuse3;
                norm2 = normf3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                norm3 = normf1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            dif1 = diffuse3;
            norm1 = normf3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                dif2 = diffuse1;
                norm2 = normf1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                dif3 = diffuse2;
                norm3 = normf2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                dif2 = diffuse2;
                norm2 = normf2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                dif3 = diffuse1;
                norm3 = normf1;
            }
        }
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        float ddifred1 = dif3.getRed() - dif1.getRed();
        float ddifgreen1 = dif3.getGreen() - dif1.getGreen();
        float ddifblue1 = dif3.getBlue() - dif1.getBlue();
        double dnormx1 = norm3.x - norm1.x;
        double dnormy1 = norm3.y - norm1.y;
        double dnormz1 = norm3.z - norm1.z;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        float ddifred2 = dif2.getRed() - dif1.getRed();
        float ddifgreen2 = dif2.getGreen() - dif1.getGreen();
        float ddifblue2 = dif2.getBlue() - dif1.getBlue();
        double dnormx2 = norm2.x - norm1.x;
        double dnormy2 = norm2.y - norm1.y;
        double dnormz2 = norm2.z - norm1.z;
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        float mdifred1 = ddifred1 * denom;
        float mdifgreen1 = ddifgreen1 * denom;
        float mdifblue1 = ddifblue1 * denom;
        double mnormx1 = dnormx1 * (double)denom;
        double mnormy1 = dnormy1 * (double)denom;
        double mnormz1 = dnormz1 * (double)denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        float difredstart = difredend = dif1.getRed();
        float difgreenstart = difgreenend = dif1.getGreen();
        float difbluestart = difblueend = dif1.getBlue();
        double normxstart = normxend = norm1.x;
        double normystart = normyend = norm1.y;
        double normzstart = normzend = norm1.z;
        int y = (int)Math.round(y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                difredstart = (float)((double)difredstart + (double)mdifred1 * dy2);
                difredend = (float)((double)difredend + (double)mdifred2 * dy2);
                difgreenstart = (float)((double)difgreenstart + (double)mdifgreen1 * dy2);
                difgreenend = (float)((double)difgreenend + (double)mdifgreen2 * dy2);
                difbluestart = (float)((double)difbluestart + (double)mdifblue1 * dy2);
                difblueend = (float)((double)difblueend + (double)mdifblue2 * dy2);
                normxstart += mnormx1 * dy2;
                normxend += mnormx2 * dy2;
                normystart += mnormy1 * dy2;
                normyend += mnormy2 * dy2;
                normzstart += mnormz1 * dy2;
                normzend += mnormz2 * dy2;
                y = (int)Math.round(y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = (int)Math.round(y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    difred = (float)((double)difred - (double)ddifred * delta);
                    difgreen = (float)((double)difgreen - (double)ddifgreen * delta);
                    difblue = (float)((double)difblue - (double)ddifblue * delta);
                    normx -= dnormx * delta;
                    normy -= dnormy * delta;
                    normz -= dnormz * delta;
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (this.surfSpec.hilight.getRed() == 0.0f && this.surfSpec.hilight.getGreen() == 0.0f && this.surfSpec.hilight.getBlue() == 0.0f) {
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.emissive.getBlue());
                                } else {
                                    if (this.positionNeeded) {
                                        this.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                    }
                                    this.tempVec[3].set(normx, normy, normz);
                                    this.tempVec[3].normalize();
                                    this.calcLight(this.tempVec[2], this.tempVec[3], viewdir, faceNorm, this.surfSpec.roughness, null, specular);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.hilight.getRed() * specular.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.hilight.getGreen() * specular.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.hilight.getBlue() * specular.getBlue() + this.surfSpec.emissive.getBlue());
                                }
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        ddifred2 = dif3.getRed() - dif2.getRed();
        ddifgreen2 = dif3.getGreen() - dif2.getGreen();
        ddifblue2 = dif3.getBlue() - dif2.getBlue();
        dnormx2 = norm3.x - norm2.x;
        dnormy2 = norm3.y - norm2.y;
        dnormz2 = norm3.z - norm2.z;
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mdifred2 = ddifred2 * denom;
            mdifgreen2 = ddifgreen2 * denom;
            mdifblue2 = ddifblue2 * denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            difredend = dif2.getRed();
            difgreenend = dif2.getGreen();
            difblueend = dif2.getBlue();
            normxend = norm2.x;
            normyend = norm2.y;
            normzend = norm2.z;
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                difredstart -= mdifred1 * (float)y;
                difredend -= mdifred2 * (float)y;
                difgreenstart -= mdifgreen1 * (float)y;
                difgreenend -= mdifgreen2 * (float)y;
                difbluestart -= mdifblue1 * (float)y;
                difblueend -= mdifblue2 * (float)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = (int)Math.round(y3 < (double)this.height ? y3 : (double)this.height);
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    difred = difredstart;
                    ddifred = difredend - difredstart;
                    difgreen = difgreenstart;
                    ddifgreen = difgreenend - difgreenstart;
                    difblue = difbluestart;
                    ddifblue = difblueend - difbluestart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    difred = difredend;
                    ddifred = difredstart - difredend;
                    difgreen = difgreenend;
                    ddifgreen = difgreenstart - difgreenend;
                    difblue = difblueend;
                    ddifblue = difbluestart - difblueend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    ddifred *= denom;
                    ddifgreen *= denom;
                    ddifblue *= denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    difred = (float)((double)difred - (double)ddifred * delta);
                    difgreen = (float)((double)difgreen - (double)ddifgreen * delta);
                    difblue = (float)((double)difblue - (double)ddifblue * delta);
                    normx -= dnormx * delta;
                    normy -= dnormy * delta;
                    normz -= dnormz * delta;
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (this.surfSpec.hilight.getRed() == 0.0f && this.surfSpec.hilight.getGreen() == 0.0f && this.surfSpec.hilight.getBlue() == 0.0f) {
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.emissive.getBlue());
                                } else {
                                    if (this.positionNeeded) {
                                        this.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                    }
                                    this.tempVec[3].set(normx, normy, normz);
                                    this.tempVec[3].normalize();
                                    this.calcLight(this.tempVec[2], this.tempVec[3], viewdir, faceNorm, this.surfSpec.roughness, null, specular);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * difred + this.surfSpec.hilight.getRed() * specular.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * difgreen + this.surfSpec.hilight.getGreen() * specular.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * difblue + this.surfSpec.hilight.getBlue() * specular.getBlue() + this.surfSpec.emissive.getBlue());
                                }
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        difred += ddifred;
                        difgreen += ddifgreen;
                        difblue += ddifblue;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                difredstart += mdifred1;
                difgreenstart += mdifgreen1;
                difbluestart += mdifblue1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                difredend += mdifred2;
                difgreenend += mdifgreen2;
                difblueend += mdifblue2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshPhong(RenderingMesh mesh, Vec3 viewdir, boolean isClosed, boolean bumpMap) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Vec3[] clipNorm = new Vec3[4];
        Vec2[] pos = new Vec2[vert.length];
        float[] z = new float[vert.length];
        float clip = (float)this.theCamera.getClipDistance();
        float[] clipz = new float[4];
        double[] clipu = new double[4];
        double[] clipv = new double[4];
        double distToScreen = this.theCamera.getDistToScreen();
        double tol = this.smoothScale;
        Mat4 toView = this.theCamera.getObjectToView();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        boolean hide = this.hideBackfaces && isClosed;
        int i = 0;
        while (i < 4) {
            clipNorm[i] = new Vec3();
            ++i;
        }
        i = vert.length - 1;
        while (i >= 0) {
            pos[i] = toScreen.timesXY(vert[i]);
            z[i] = (float)toView.timesZ(vert[i]);
            --i;
        }
        i = mesh.triangle.length - 1;
        while (i >= 0) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            if (!(z[v1] < clip && z[v2] < clip && z[v3] < clip)) {
                boolean backface;
                boolean bl = backface = (pos[v2].x - pos[v1].x) * (pos[v3].y - pos[v1].y) - (pos[v2].y - pos[v1].y) * (pos[v3].x - pos[v1].x) > 0.0;
                if (z[v1] < clip || z[v2] < clip || z[v3] < clip) {
                    Vec3[] clipPos = this.clipTriangle(vert[v1], vert[v2], vert[v3], z[v1], z[v2], z[v3], clipz, clipu, clipv);
                    Vec2[] clipPos2D = new Vec2[clipPos.length];
                    int j = clipPos.length - 1;
                    while (j >= 0) {
                        clipPos2D[j] = toScreen.timesXY(clipPos[j]);
                        double u = clipu[j];
                        double v = clipv[j];
                        double w = 1.0 - u - v;
                        clipNorm[j].set(norm[n1].x * u + norm[n2].x * v + norm[n3].x * w, norm[n1].y * u + norm[n2].y * v + norm[n3].y * w, norm[n1].z * u + norm[n2].z * v + norm[n3].z * w);
                        clipNorm[j].normalize();
                        --j;
                    }
                    this.renderTrianglePhong(clipPos2D[0], clipz[0], clipPos[0], clipNorm[0], clipu[0], clipv[0], clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], tri, viewdir, mesh.faceNorm[i], clip, bumpMap, !backface);
                    if (clipPos.length == 4) {
                        this.renderTrianglePhong(clipPos2D[1], clipz[1], clipPos[1], clipNorm[1], clipu[1], clipv[1], clipPos2D[2], clipz[2], clipPos[2], clipNorm[2], clipu[2], clipv[2], clipPos2D[3], clipz[3], clipPos[3], clipNorm[3], clipu[3], clipv[3], tri, viewdir, mesh.faceNorm[i], clip, bumpMap, !backface);
                    }
                } else if (!hide || !backface) {
                    this.renderTrianglePhong(pos[v1], z[v1], vert[v1], norm[n1], 1.0, 0.0, pos[v2], z[v2], vert[v2], norm[n2], 0.0, 1.0, pos[v3], z[v3], vert[v3], norm[n3], 0.0, 0.0, tri, viewdir, mesh.faceNorm[i], clip, bumpMap, !backface);
                }
            }
            --i;
        }
    }

    private void renderTrianglePhong(Vec2 pos1, float zf1, Vec3 vert1, Vec3 normf1, double uf1, double vf1, Vec2 pos2, float zf2, Vec3 vert2, Vec3 normf2, double uf2, double vf2, Vec2 pos3, float zf3, Vec3 vert3, Vec3 normf3, double uf3, double vf3, RenderingTriangle tri, Vec3 viewdir, Vec3 faceNorm, double clip, boolean bumpMap, boolean front) {
        double wl;
        double vl;
        double ul;
        float zl;
        int i;
        boolean repeat;
        double dnormz;
        double normz;
        double dnormy;
        double normy;
        double dnormx;
        double normx;
        double dv;
        double v;
        double du;
        double u;
        float dz;
        float z;
        double delta;
        int right;
        int left;
        int index;
        int yend;
        double mnormz2;
        double mnormy2;
        double mnormx2;
        double mv2;
        double mu2;
        float mz2;
        double mx2;
        double normzend;
        double normyend;
        double normxend;
        double vend;
        double uend;
        float zend;
        double xend;
        Vec3 norm3;
        double v3;
        double u3;
        float z3;
        double y3;
        double x3;
        Vec3 norm2;
        double v2;
        double u2;
        float z2;
        double y2;
        double x2;
        Vec3 norm1;
        double v1;
        double u1;
        float z1;
        double y1;
        double x1;
        boolean doSubsample;
        RGBColor diffuse = this.tempColor[1];
        RGBColor specular = this.tempColor[2];
        Vec3 normal = this.tempVec[3];
        double distToScreen = this.theCamera.getDistToScreen();
        int prevLeft = this.width;
        int prevRight = -1;
        boolean bl = doSubsample = this.subsample > 1;
        if (pos1.y <= pos2.y && pos1.y <= pos3.y) {
            x1 = pos1.x;
            y1 = pos1.y;
            z1 = zf1;
            u1 = uf1;
            v1 = vf1;
            norm1 = normf1;
            if (pos2.y < pos3.y) {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                norm2 = normf2;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                norm2 = normf3;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                norm3 = normf2;
            }
        } else if (pos2.y <= pos1.y && pos2.y <= pos3.y) {
            x1 = pos2.x;
            y1 = pos2.y;
            z1 = zf2;
            u1 = uf2;
            v1 = vf2;
            norm1 = normf2;
            if (pos1.y < pos3.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                norm2 = normf1;
                x3 = pos3.x;
                y3 = pos3.y;
                z3 = zf3;
                u3 = uf3;
                v3 = vf3;
                norm3 = normf3;
            } else {
                x2 = pos3.x;
                y2 = pos3.y;
                z2 = zf3;
                u2 = uf3;
                v2 = vf3;
                norm2 = normf3;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                norm3 = normf1;
            }
        } else {
            x1 = pos3.x;
            y1 = pos3.y;
            z1 = zf3;
            u1 = uf3;
            v1 = vf3;
            norm1 = normf3;
            if (pos1.y < pos2.y) {
                x2 = pos1.x;
                y2 = pos1.y;
                z2 = zf1;
                u2 = uf1;
                v2 = vf1;
                norm2 = normf1;
                x3 = pos2.x;
                y3 = pos2.y;
                z3 = zf2;
                u3 = uf2;
                v3 = vf2;
                norm3 = normf2;
            } else {
                x2 = pos2.x;
                y2 = pos2.y;
                z2 = zf2;
                u2 = uf2;
                v2 = vf2;
                norm2 = normf2;
                x3 = pos1.x;
                y3 = pos1.y;
                z3 = zf1;
                u3 = uf1;
                v3 = vf1;
                norm3 = normf1;
            }
        }
        z1 = 1.0f / z1;
        u1 *= (double)z1;
        v1 *= (double)z1;
        z2 = 1.0f / z2;
        u2 *= (double)z2;
        v2 *= (double)z2;
        z3 = 1.0f / z3;
        u3 *= (double)z3;
        v3 *= (double)z3;
        double dx1 = x3 - x1;
        double dy1 = y3 - y1;
        float dz1 = z3 - z1;
        if (dy1 == 0.0) {
            return;
        }
        double du1 = u3 - u1;
        double dv1 = v3 - v1;
        double dnormx1 = norm3.x - norm1.x;
        double dnormy1 = norm3.y - norm1.y;
        double dnormz1 = norm3.z - norm1.z;
        double dx2 = x2 - x1;
        double dy2 = y2 - y1;
        float dz2 = z2 - z1;
        double du2 = u2 - u1;
        double dv2 = v2 - v1;
        double dnormx2 = norm2.x - norm1.x;
        double dnormy2 = norm2.y - norm1.y;
        double dnormz2 = norm2.z - norm1.z;
        float denom = (float)(1.0 / dy1);
        double mx1 = dx1 * (double)denom;
        float mz1 = dz1 * denom;
        double mu1 = du1 * (double)denom;
        double mv1 = dv1 * (double)denom;
        double mnormx1 = dnormx1 * (double)denom;
        double mnormy1 = dnormy1 * (double)denom;
        double mnormz1 = dnormz1 * (double)denom;
        double xstart = xend = x1;
        float zstart = zend = z1;
        double ustart = uend = u1;
        double vstart = vend = v1;
        double normxstart = normxend = norm1.x;
        double normystart = normyend = norm1.y;
        double normzstart = normzend = norm1.z;
        int y = (int)Math.round(y1);
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            if (y2 < 0.0) {
                xstart += mx1 * dy2;
                xend += mx2 * dy2;
                zstart = (float)((double)zstart + (double)mz1 * dy2);
                zend = (float)((double)zend + (double)mz2 * dy2);
                ustart += mu1 * dy2;
                uend += mu2 * dy2;
                vstart += mv1 * dy2;
                vend += mv2 * dy2;
                normxstart += mnormx1 * dy2;
                normxend += mnormx2 * dy2;
                normystart += mnormy1 * dy2;
                normyend += mnormy2 * dy2;
                normzstart += mnormz1 * dy2;
                normzend += mnormz2 * dy2;
                y = (int)Math.round(y2);
            } else if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = (int)Math.round(y2);
            if (yend > this.height) {
                yend = this.height;
            }
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    normx -= dnormx * delta;
                    normy -= dnormy * delta;
                    normz -= dnormz * delta;
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (this.positionNeeded) {
                                    this.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                }
                                normal.set(normx, normy, normz);
                                normal.normalize();
                                if (bumpMap) {
                                    normal.scale(this.surfSpec.bumpGrad.dot(normal) + 1.0);
                                    normal.subtract(this.surfSpec.bumpGrad);
                                    normal.normalize();
                                }
                                if (this.surfSpec.hilight.getRed() == 0.0f && this.surfSpec.hilight.getGreen() == 0.0f && this.surfSpec.hilight.getBlue() == 0.0f) {
                                    this.calcLight(this.tempVec[2], normal, viewdir, faceNorm, this.surfSpec.roughness, diffuse, null);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * diffuse.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * diffuse.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * diffuse.getBlue() + this.surfSpec.emissive.getBlue());
                                } else {
                                    this.calcLight(this.tempVec[2], normal, viewdir, faceNorm, this.surfSpec.roughness, diffuse, specular);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * diffuse.getRed() + this.surfSpec.hilight.getRed() * specular.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * diffuse.getGreen() + this.surfSpec.hilight.getGreen() * specular.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * diffuse.getBlue() + this.surfSpec.hilight.getBlue() * specular.getBlue() + this.surfSpec.emissive.getBlue());
                                }
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
        dx2 = x3 - x2;
        dy2 = y3 - y2;
        dz2 = z3 - z2;
        du2 = u3 - u2;
        dv2 = v3 - v2;
        dnormx2 = norm3.x - norm2.x;
        dnormy2 = norm3.y - norm2.y;
        dnormz2 = norm3.z - norm2.z;
        if (dy2 > 0.0) {
            denom = (float)(1.0 / dy2);
            mx2 = dx2 * (double)denom;
            mz2 = dz2 * denom;
            mu2 = du2 * (double)denom;
            mv2 = dv2 * (double)denom;
            mnormx2 = dnormx2 * (double)denom;
            mnormy2 = dnormy2 * (double)denom;
            mnormz2 = dnormz2 * (double)denom;
            xend = x2;
            zend = z2;
            uend = u2;
            vend = v2;
            normxend = norm2.x;
            normyend = norm2.y;
            normzend = norm2.z;
            if (y < 0) {
                xstart -= mx1 * (double)y;
                xend -= mx2 * (double)y;
                zstart -= mz1 * (float)y;
                zend -= mz2 * (float)y;
                ustart -= mu1 * (double)y;
                uend -= mu2 * (double)y;
                vstart -= mv1 * (double)y;
                vend -= mv2 * (double)y;
                normxstart -= mnormx1 * (double)y;
                normxend -= mnormx2 * (double)y;
                normystart -= mnormy1 * (double)y;
                normyend -= mnormy2 * (double)y;
                normzstart -= mnormz1 * (double)y;
                normzend -= mnormz2 * (double)y;
                y = 0;
            }
            yend = (int)Math.round(y3 < (double)this.height ? y3 : (double)this.height);
            index = y * this.width;
            while (y < yend) {
                if (xstart < xend) {
                    left = (int)Math.floor(xstart);
                    right = (int)Math.ceil(xend);
                    delta = xstart - (double)left;
                    z = zstart;
                    dz = zend - zstart;
                    u = ustart;
                    du = uend - ustart;
                    v = vstart;
                    dv = vend - vstart;
                    normx = normxstart;
                    dnormx = normxend - normxstart;
                    normy = normystart;
                    dnormy = normyend - normystart;
                    normz = normzstart;
                    dnormz = normzend - normzstart;
                } else {
                    left = (int)Math.floor(xend);
                    right = (int)Math.ceil(xstart);
                    delta = xend - (double)left;
                    z = zend;
                    dz = zstart - zend;
                    u = uend;
                    du = ustart - uend;
                    v = vend;
                    dv = vstart - vend;
                    normx = normxend;
                    dnormx = normxstart - normxend;
                    normy = normyend;
                    dnormy = normystart - normyend;
                    normz = normzend;
                    dnormz = normzstart - normzend;
                }
                if (left != right) {
                    denom = xend == xstart ? 1.0f : (xend > xstart ? (float)(1.0 / (xend - xstart)) : (float)(1.0 / (xstart - xend)));
                    dz *= denom;
                    du *= (double)denom;
                    dv *= (double)denom;
                    dnormx *= (double)denom;
                    dnormy *= (double)denom;
                    dnormz *= (double)denom;
                    if (left < 0) {
                        delta += (double)left;
                        left = 0;
                    }
                    u -= du * delta;
                    v -= dv * delta;
                    z = (float)((double)z - (double)dz * delta);
                    normx -= dnormx * delta;
                    normy -= dnormy * delta;
                    normz -= dnormz * delta;
                    if (right > this.width) {
                        right = this.width;
                    }
                    repeat = false;
                    i = left;
                    while (i < right) {
                        zl = 1.0f / z;
                        if (zl < this.zbuffer[index + i] && (double)zl > clip) {
                            if (repeat && i % this.subsample != 0) {
                                this.pixel[index + i] = this.pixel[index + i - 1];
                                this.zbuffer[index + i] = zl;
                            } else if (repeat && y % this.subsample != 0 && i >= prevLeft && i < prevRight) {
                                this.pixel[index + i] = this.pixel[index + i - this.width];
                                this.zbuffer[index + i] = zl;
                            } else {
                                ul = u * (double)zl;
                                vl = v * (double)zl;
                                wl = 1.0 - ul - vl;
                                tri.getTextureSpec(this.surfSpec, front, ul, vl, wl, this.smoothScale * (double)z, this.time);
                                if (this.positionNeeded) {
                                    this.tempVec[2].set(ul * vert1.x + vl * vert2.x + wl * vert3.x, ul * vert1.y + vl * vert2.y + wl * vert3.y, ul * vert1.z + vl * vert2.z + wl * vert3.z);
                                }
                                normal.set(normx, normy, normz);
                                normal.normalize();
                                if (bumpMap) {
                                    normal.scale(this.surfSpec.bumpGrad.dot(normal) + 1.0);
                                    normal.subtract(this.surfSpec.bumpGrad);
                                    normal.normalize();
                                }
                                if (this.surfSpec.hilight.getRed() == 0.0f && this.surfSpec.hilight.getGreen() == 0.0f && this.surfSpec.hilight.getBlue() == 0.0f) {
                                    this.calcLight(this.tempVec[2], normal, viewdir, faceNorm, this.surfSpec.roughness, diffuse, null);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * diffuse.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * diffuse.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * diffuse.getBlue() + this.surfSpec.emissive.getBlue());
                                } else {
                                    this.calcLight(this.tempVec[2], normal, viewdir, faceNorm, this.surfSpec.roughness, diffuse, specular);
                                    this.tempColor[0].setRGB(this.surfSpec.diffuse.getRed() * diffuse.getRed() + this.surfSpec.hilight.getRed() * specular.getRed() + this.surfSpec.emissive.getRed(), this.surfSpec.diffuse.getGreen() * diffuse.getGreen() + this.surfSpec.hilight.getGreen() * specular.getGreen() + this.surfSpec.emissive.getGreen(), this.surfSpec.diffuse.getBlue() * diffuse.getBlue() + this.surfSpec.hilight.getBlue() * specular.getBlue() + this.surfSpec.emissive.getBlue());
                                }
                                this.pixel[index + i] = this.calcARGB(this.tempColor[0], 0.0);
                                this.zbuffer[index + i] = zl;
                            }
                            repeat = doSubsample;
                        } else {
                            repeat = false;
                        }
                        z += dz;
                        u += du;
                        v += dv;
                        normx += dnormx;
                        normy += dnormy;
                        normz += dnormz;
                        ++i;
                    }
                    prevLeft = left;
                    prevRight = right;
                }
                xstart += mx1;
                zstart += mz1;
                ustart += mu1;
                vstart += mv1;
                normxstart += mnormx1;
                normystart += mnormy1;
                normzstart += mnormz1;
                xend += mx2;
                zend += mz2;
                uend += mu2;
                vend += mv2;
                normxend += mnormx2;
                normyend += mnormy2;
                normzend += mnormz2;
                index += this.width;
                ++y;
            }
        }
    }

    private void renderMeshDisplaced(RenderingMesh mesh, Vec3 viewdir, double tol, boolean isClosed, boolean bumpMap) {
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        Mat4 toView = this.theCamera.getObjectToView();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        int shading = bumpMap ? 2 : this.shadingMode;
        int i = mesh.triangle.length - 1;
        while (i >= 0) {
            RenderingTriangle tri = mesh.triangle[i];
            int v1 = tri.v1;
            int v2 = tri.v2;
            int v3 = tri.v3;
            int n1 = tri.n1;
            int n2 = tri.n2;
            int n3 = tri.n3;
            double dist1 = vert[v1].distance(vert[v2]);
            double dist2 = vert[v2].distance(vert[v3]);
            double dist3 = vert[v3].distance(vert[v1]);
            this.tempVec[0].set(vert[v1].x - vert[v3].x, vert[v1].y - vert[v3].y, vert[v1].z - vert[v3].z);
            this.tempVec[1].set(vert[v3].x - vert[v2].x, vert[v3].y - vert[v2].y, vert[v3].z - vert[v2].z);
            Vec3 vgrad = this.tempVec[0].cross(mesh.faceNorm[i]);
            Vec3 ugrad = this.tempVec[1].cross(mesh.faceNorm[i]);
            vgrad.scale(-1.0 / vgrad.dot(this.tempVec[1]));
            ugrad.scale(1.0 / ugrad.dot(this.tempVec[0]));
            DisplacedVertex dv1 = new DisplacedVertex(tri, vert[v1], norm[n1], 1.0, 0.0, toView, toScreen);
            DisplacedVertex dv2 = new DisplacedVertex(tri, vert[v2], norm[n2], 0.0, 1.0, toView, toScreen);
            DisplacedVertex dv3 = new DisplacedVertex(tri, vert[v3], norm[n3], 0.0, 0.0, toView, toScreen);
            this.renderDisplacedTriangle(tri, dv1, dist1, dv2, dist2, dv3, dist3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            --i;
        }
    }

    private void renderDisplacedTriangle(RenderingTriangle tri, DisplacedVertex dv1, double dist1, DisplacedVertex dv2, double dist2, DisplacedVertex dv3, double dist3, Vec3 viewdir, Vec3 ugrad, Vec3 vgrad, double tol, boolean isClosed, boolean bumpMap) {
        boolean backface;
        Mat4 toView = this.theCamera.getObjectToView();
        Mat4 toScreen = this.theCamera.getObjectToScreen();
        DisplacedVertex midv1 = null;
        DisplacedVertex midv2 = null;
        DisplacedVertex midv3 = null;
        double halfdist1 = 0.0;
        double halfdist2 = 0.0;
        double halfdist3 = 0.0;
        boolean split1 = dist1 > tol;
        boolean split2 = dist2 > tol;
        boolean split3 = dist3 > tol;
        int shading = bumpMap ? 2 : this.shadingMode;
        int count = 0;
        if (split1) {
            midv1 = new DisplacedVertex(tri, new Vec3(0.5 * (dv1.vert.x + dv2.vert.x), 0.5 * (dv1.vert.y + dv2.vert.y), 0.5 * (dv1.vert.z + dv2.vert.z)), new Vec3(0.5 * (dv1.norm.x + dv2.norm.x), 0.5 * (dv1.norm.y + dv2.norm.y), 0.5 * (dv1.norm.z + dv2.norm.z)), 0.5 * (dv1.u + dv2.u), 0.5 * (dv1.v + dv2.v), toView, toScreen);
            halfdist1 = 0.5 * dist1;
            ++count;
        }
        if (split2) {
            midv2 = new DisplacedVertex(tri, new Vec3(0.5 * (dv2.vert.x + dv3.vert.x), 0.5 * (dv2.vert.y + dv3.vert.y), 0.5 * (dv2.vert.z + dv3.vert.z)), new Vec3(0.5 * (dv2.norm.x + dv3.norm.x), 0.5 * (dv2.norm.y + dv3.norm.y), 0.5 * (dv2.norm.z + dv3.norm.z)), 0.5 * (dv2.u + dv3.u), 0.5 * (dv2.v + dv3.v), toView, toScreen);
            halfdist2 = 0.5 * dist2;
            ++count;
        }
        if (split3) {
            midv3 = new DisplacedVertex(tri, new Vec3(0.5 * (dv3.vert.x + dv1.vert.x), 0.5 * (dv3.vert.y + dv1.vert.y), 0.5 * (dv3.vert.z + dv1.vert.z)), new Vec3(0.5 * (dv3.norm.x + dv1.norm.x), 0.5 * (dv3.norm.y + dv1.norm.y), 0.5 * (dv3.norm.z + dv1.norm.z)), 0.5 * (dv3.u + dv1.u), 0.5 * (dv3.v + dv1.v), toView, toScreen);
            halfdist3 = 0.5 * dist3;
            ++count;
        }
        if (count == 1) {
            if (split1) {
                double d = dv3.vert.distance(midv1.vert);
                this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d, dv3, dist3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, midv1, halfdist1, dv2, dist2, dv3, d, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            } else if (split2) {
                double d = dv1.vert.distance(midv2.vert);
                this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d, dv1, dist1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, midv2, halfdist2, dv3, dist3, dv1, d, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            } else {
                double d = dv1.vert.distance(midv3.vert);
                this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d, dv2, dist2, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, midv3, halfdist3, dv1, dist1, dv2, d, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            }
            return;
        }
        if (count == 2) {
            if (!split1) {
                double d1 = midv2.vert.distance(dv1.vert);
                double d2 = midv2.vert.distance(midv3.vert);
                this.renderDisplacedTriangle(tri, dv1, dist1, dv2, halfdist2, midv2, d1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv1, d1, midv2, d2, midv3, halfdist3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            } else if (!split2) {
                double d1 = midv3.vert.distance(dv2.vert);
                double d2 = midv3.vert.distance(midv1.vert);
                this.renderDisplacedTriangle(tri, dv2, dist2, dv3, halfdist3, midv3, d1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv2, d1, midv3, d2, midv1, halfdist1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d2, midv3, halfdist3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            } else {
                double d1 = midv1.vert.distance(dv3.vert);
                double d2 = midv1.vert.distance(midv2.vert);
                this.renderDisplacedTriangle(tri, dv3, dist3, dv1, halfdist1, midv1, d1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv3, d1, midv1, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
                this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d2, midv1, halfdist1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            }
            return;
        }
        if (count == 3) {
            double d1 = midv1.vert.distance(midv2.vert);
            double d2 = midv2.vert.distance(midv3.vert);
            double d3 = midv3.vert.distance(midv1.vert);
            this.renderDisplacedTriangle(tri, dv1, halfdist1, midv1, d3, midv3, halfdist3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            this.renderDisplacedTriangle(tri, dv2, halfdist2, midv2, d1, midv1, halfdist1, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            this.renderDisplacedTriangle(tri, dv3, halfdist3, midv3, d2, midv2, halfdist2, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            this.renderDisplacedTriangle(tri, midv1, d1, midv2, d2, midv3, d3, viewdir, ugrad, vgrad, tol, isClosed, bumpMap);
            return;
        }
        float clip = (float)this.theCamera.getClipDistance();
        if (dv1.z < clip && dv2.z < clip && dv3.z < clip) {
            return;
        }
        if (dv1.z <= 0.0f || dv2.z < 0.0f || dv3.z < 0.0f) {
            return;
        }
        boolean bl = backface = (dv2.pos.x - dv1.pos.x) * (dv3.pos.y - dv1.pos.y) - (dv2.pos.y - dv1.pos.y) * (dv3.pos.x - dv1.pos.x) > 0.0;
        if (this.hideBackfaces && isClosed && backface) {
            return;
        }
        if (dv1.dispnorm == null) {
            dv1.prepareToRender(tri, viewdir, ugrad, vgrad, shading, !backface);
        }
        if (dv2.dispnorm == null) {
            dv2.prepareToRender(tri, viewdir, ugrad, vgrad, shading, !backface);
        }
        if (dv3.dispnorm == null) {
            dv3.prepareToRender(tri, viewdir, ugrad, vgrad, shading, !backface);
        }
        Vec3 closestNorm = null;
        closestNorm = dv1.z < dv2.z && dv1.z < dv3.z ? dv1.dispnorm : (dv2.z < dv1.z && dv2.z < dv3.z ? dv2.dispnorm : dv3.dispnorm);
        if (shading == 0) {
            this.renderTriangleGouraud(dv1.pos, dv1.z, dv1.u, dv1.v, dv1.diffuse, dv1.specular, dv2.pos, dv2.z, dv2.u, dv2.v, dv2.diffuse, dv2.specular, dv3.pos, dv3.z, dv3.u, dv3.v, dv3.diffuse, dv3.specular, tri, (float)this.theCamera.getClipDistance(), !backface);
        } else if (shading == 1) {
            this.renderTriangleHybrid(dv1.pos, dv1.z, dv1.dispvert, dv1.dispnorm, dv1.u, dv1.v, dv1.diffuse, dv2.pos, dv2.z, dv2.dispvert, dv2.dispnorm, dv2.u, dv2.v, dv2.diffuse, dv3.pos, dv3.z, dv3.dispvert, dv3.dispnorm, dv3.u, dv3.v, dv3.diffuse, tri, viewdir, closestNorm, (float)this.theCamera.getClipDistance(), !backface);
        } else {
            this.renderTrianglePhong(dv1.pos, dv1.z, dv1.dispvert, dv1.dispnorm, dv1.u, dv1.v, dv2.pos, dv2.z, dv2.dispvert, dv2.dispnorm, dv2.u, dv2.v, dv3.pos, dv3.z, dv3.dispvert, dv3.dispnorm, dv3.u, dv3.v, tri, viewdir, closestNorm, (float)this.theCamera.getClipDistance(), bumpMap, !backface);
        }
    }

    private class DisplacedVertex {
        public Vec3 vert;
        public Vec3 norm;
        public Vec3 dispvert;
        public Vec3 dispnorm;
        public Vec2 pos;
        public double u;
        public double v;
        public double disp;
        public double tol;
        public float z;
        public float basez;
        public RGBColor diffuse;
        public RGBColor specular;

        public DisplacedVertex(RenderingTriangle tri, Vec3 vert, Vec3 norm, double u, double v, Mat4 toView, Mat4 toScreen) {
            this.vert = vert;
            this.norm = norm;
            this.u = u;
            this.v = v;
            this.basez = (float)toView.timesZ(vert);
            this.tol = (double)this.basez > Raster.this.theCamera.getDistToScreen() ? Raster.this.smoothScale * (double)this.basez : Raster.this.smoothScale;
            this.disp = tri.getDisplacement(u, v, 1.0 - u - v, this.tol, 0.0);
            this.dispvert = new Vec3(vert.x + this.disp * norm.x, vert.y + this.disp * norm.y, vert.z + this.disp * norm.z);
            this.z = (float)toView.timesZ(this.dispvert);
            this.pos = toScreen.timesXY(this.dispvert);
        }

        public final void prepareToRender(RenderingTriangle tri, Vec3 viewdir, Vec3 ugrad, Vec3 vgrad, int shading, boolean front) {
            double w = 1.0 - this.u - this.v;
            double dhdu = (tri.getDisplacement(this.u + 1.0E-5, this.v, w - 1.0E-5, this.tol, 0.0) - this.disp) * 100000.0;
            double dhdv = (tri.getDisplacement(this.u, this.v + 1.0E-5, w - 1.0E-5, this.tol, 0.0) - this.disp) * 100000.0;
            this.dispnorm = new Vec3(this.norm);
            Raster.this.tempVec[0].set(dhdu * ugrad.x + dhdv * vgrad.x, dhdu * ugrad.y + dhdv * vgrad.y, dhdu * ugrad.z + dhdv * vgrad.z);
            this.dispnorm.scale(Raster.this.tempVec[0].dot(this.dispnorm) + 1.0);
            this.dispnorm.subtract(Raster.this.tempVec[0]);
            this.dispnorm.normalize();
            double d = this.tol = (double)this.z > Raster.this.theCamera.getDistToScreen() ? Raster.this.smoothScale * (double)this.z : Raster.this.smoothScale;
            if (shading == 0) {
                this.specular = new RGBColor();
            }
            if (shading != 2) {
                this.diffuse = new RGBColor();
                tri.getTextureSpec(Raster.this.surfSpec, front, this.u, this.v, w, this.tol, Raster.this.time);
                Raster.this.calcLight(this.dispvert, this.dispnorm, viewdir, this.dispnorm, Raster.this.surfSpec.roughness, this.diffuse, this.specular);
            }
        }
    }
}

