/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.MessageDialog;
import artofillusion.ui.ValueField;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class OBJExporter {
    public static void exportFile(Frame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        Choice exportChoice = new Choice();
        exportChoice.add("Export Whole Scene");
        exportChoice.add("Selected Objects Only");
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog(parent, "Export to Wavefront .obj File:", new Component[]{exportChoice, new Label("Maximum Surface Error:"), errorField}, new String[]{"", "", ""}) : new ComponentsDialog(parent, "Export to Wavefront .obj File:", new Component[]{new Label("Maximum Surface Error:"), errorField}, new String[]{"", ""});
        if (!dlg.clickedOk()) {
            return;
        }
        FileDialog fd = new FileDialog(parent, "Export as OBJ", 1);
        String sep = System.getProperty("file.separator");
        fd.setFile("Untitled.obj");
        if (ModellingApp.currentDirectory != null) {
            fd.setDirectory(ModellingApp.currentDirectory);
        }
        fd.show();
        if (fd.getFile() == null) {
            return;
        }
        File f = new File(fd.getDirectory(), fd.getFile());
        ModellingApp.currentDirectory = fd.getDirectory();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            OBJExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue());
            out.close();
        }
        catch (IOException ex) {
            new MessageDialog(parent, new String[]{"An error occurred while exporting the scene.", ex.getMessage()});
        }
    }

    static void writeScene(Scene theScene, PrintWriter out, boolean wholeScene, double tol) {
        out.println("#Produced by Art of Illusion 1.3, " + new Date().toString());
        int numVert = 0;
        int numNorm = 0;
        Hashtable<String, String> groupNames = new Hashtable<String, String>();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        int i = 0;
        while (i < theScene.getNumObjects()) {
            RenderingMesh mesh;
            ObjectInfo info = theScene.getObject(i);
            if ((wholeScene || info.selected) && (mesh = info.getRenderingMesh(tol)) != null) {
                String baseName;
                String name = baseName = info.name.replace(' ', '_');
                int append = 1;
                while (groupNames.get(name) != null) {
                    name = baseName + "_" + append++;
                }
                groupNames.put(name, "");
                out.println("g " + name);
                Mat4 trans = info.coords.fromLocal();
                int j = 0;
                while (j < mesh.vert.length) {
                    Vec3 v = trans.times(mesh.vert[j]);
                    out.println("v " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    ++j;
                }
                int j2 = 0;
                while (j2 < mesh.norm.length) {
                    if (mesh.norm[j2] == null) {
                        out.println("vn 1 0 0");
                    } else {
                        Vec3 v = trans.timesDirection(mesh.norm[j2]);
                        out.println("vn " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    }
                    ++j2;
                }
                int j3 = 0;
                while (j3 < mesh.triangle.length) {
                    out.println("f " + (mesh.triangle[j3].v1 + numVert + 1) + "//" + (mesh.triangle[j3].n1 + numNorm + 1) + " " + (mesh.triangle[j3].v2 + numVert + 1) + "//" + (mesh.triangle[j3].n2 + numNorm + 1) + " " + (mesh.triangle[j3].v3 + numVert + 1) + "//" + (mesh.triangle[j3].n3 + numNorm + 1));
                    ++j3;
                }
                numVert += mesh.vert.length;
                numNorm += mesh.norm.length;
            }
            ++i;
        }
    }
}

