/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb;

import jacorb.orb.CloseConnectionException;
import jacorb.orb.Connection;
import jacorb.util.Debug;
import java.io.IOException;
import java.io.InterruptedIOException;

public class ReplyReceptor
extends Thread {
    private Boolean stopped = new Boolean(false);
    private Boolean onceOnly = new Boolean(false);
    Connection master;

    public ReplyReceptor(Connection connection) {
        this.master = connection;
        try {
            this.setDaemon(true);
        }
        catch (SecurityException securityException) {
            Debug.output(3, "Could not start reply receptor as daemon, running as a regular thread.");
        }
        this.setName("JacORB ReplyReceptor Thread for connection " + this.master.getInfo());
        this.start();
    }

    public ReplyReceptor(Connection connection, boolean bl) {
        this(connection);
        this.oneRun(bl);
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void oneRun(boolean bl) {
        Boolean bl2 = this.onceOnly;
        synchronized (bl2) {
            this.onceOnly = new Boolean(bl);
        }
    }

    public void run() {
        while (!this.stopped.booleanValue()) {
            try {
                this.master.receiveReply();
            }
            catch (CloseConnectionException closeConnectionException) {
                Debug.output(3, "ReplyReceptor: CloseConnectionException");
                this.master.closeConnection();
                break;
            }
            catch (InterruptedIOException interruptedIOException) {
                Debug.output(3, interruptedIOException);
                break;
            }
            catch (IOException iOException) {
                Debug.output(3, iOException);
                if (this.stopped.booleanValue()) break;
                this.master.closeConnection();
                break;
            }
            catch (Exception exception) {
                Debug.output(3, exception);
            }
            if (this.onceOnly.booleanValue()) break;
        }
    }

    public void stopReceptor() {
        Boolean bl = this.stopped;
        synchronized (bl) {
            this.stopped = new Boolean(true);
            this.interrupt();
        }
    }
}

