/* Diana.java
 *
 * created: Fri Oct  9 1998
 *
 * This file is part of Artemis
 *
 * Copyright (C) 1998,1999,2000  Genome Research Limited
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/Diana.java,v 1.98 2000/09/22 10:18:09 kmr Exp $
 *
 *  A physicist, an engineer, and a computer scientist were
 *  discussing the nature of God.  Surely a Physicist, said the
 *  physicist, because early in the Creation, God made Light; and you
 *  know, Maxwell's equations, the dual nature of electro-magnetic
 *  waves, the relativist consequences... An Engineer!, said the
 *  engineer, because before making Light, God split the Chaos into
 *  Land and Water; it takes a hell of an engineer to handle that big
 *  amount of mud, and orderly separation of solids from
 *  liquids... The computer scientist shouted: And the Chaos,
 *  where do you think it was coming from, hmm?
 *
 *  ---Anonymous
 *
 */

import diana.components.*;

/**
 *  This class contains the method main () for running Artemis as a standalone
 *  program.
 *
 *  @author Kim Rutherford
 *  @version $Id: Diana.java,v 1.98 2000/09/22 10:18:09 kmr Exp $
 * */

public class Diana {
  /**
   *  Version String use for banner messages and title bars.
   **/
  public static final String version = "Release 4";

  /**
   *  Main entry point for the stand-alone version of Artemis.
   **/
  public static void main (final String [] args) {
    final ArtemisMain main_window = new ArtemisMain ();

    main_window.setVisible (true);

    // read the entries given on the command line and in the diana.ini file
    main_window.readArgsAndOptions (args);
  }
}
