/*************************************************
* CBC Mode Header File                           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_CBC_H__
#define BOTAN_CBC_H__

#include <botan/modebase.h>
#include <botan/mode_pad.h>

namespace Botan {

/*************************************************
* CBC Encryption                                 *
*************************************************/
class CBC_Encryption : public BlockCipherMode
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();

      CBC_Encryption(const std::string&, const std::string&,
                     const SymmetricKey&, const BlockCipherModeIV&);
   private:
      const BlockCipherModePaddingMethod* padder;
   };

/*************************************************
* CBC Decryption                                 *
*************************************************/
class CBC_Decryption : public BlockCipherMode
   {
   public:
      void write(const byte[], u32bit);
      void end_msg();

      CBC_Decryption(const std::string&, const std::string&,
                     const SymmetricKey&, const BlockCipherModeIV&);
   private:
      const BlockCipherModePaddingMethod* padder;
      SecureVector<byte> temp;
   };

}

#endif
