/*************************************************
* Diffie-Hellman Header File                     *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_DIFFIE_HELLMAN_H__
#define BOTAN_DIFFIE_HELLMAN_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>
#include <botan/dl_parm.h>

namespace Botan {

/*************************************************
* Diffie-Hellman Public Key                      *
*************************************************/
class DH_PublicKey
   {
   public:
      virtual bool check_params() const;
      const BigInt& get_p() const { return p; }
      const BigInt& get_g() const { return g; }
      const BigInt& get_y() const { return y; }

      SecureVector<byte> public_value() const;

      DH_PublicKey(const DL_Group&, const BigInt&);
      DH_PublicKey(const DH_PublicKey&);
      virtual ~DH_PublicKey() {}
   protected:
      const DL_Group group;
      const BigInt &p, &g;
      BigInt y;
   };

/*************************************************
* Diffie-Hellman Private Key                     *
*************************************************/
class DH_PrivateKey : public DH_PublicKey,
                      public PK_Key_Agreement_Key
   {
   public:
      SecureVector<byte> derive_key(const byte[], u32bit) const;
      SecureVector<byte> derive_key(const DH_PublicKey&) const;
      SecureVector<byte> derive_key(const BigInt&) const;

      SecureVector<byte> public_value() const;
      bool check_params() const;
      const BigInt& get_x() const { return x; }

      DH_PrivateKey(const DL_Group&);
      DH_PrivateKey(const DL_Group&, const BigInt&, const BigInt& = 0);
   private:
      BigInt x;
      FixedExponent_Exp powermod_x_p;
   };

}

#endif
