/*************************************************
* EMSA3 Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EMSA3_H__
#define BOTAN_EMSA3_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* EMSA3                                          *
*************************************************/
class EMSA3 : public EMSA
   {
   public:
      EMSA3(const std::string&);
      ~EMSA3() { delete hash; }
   private:
      void update(const byte[], u32bit);
      SecureVector<byte> encoding_of(const SecureVector<byte>&, u32bit);
      SecureVector<byte> raw_data();
      HashFunction* hash;
      SecureVector<byte> hash_id;
   };

}

#endif
