/*************************************************
* File EntropySource Header File                 *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_ENTROPY_SRC_FILE_H__
#define BOTAN_ENTROPY_SRC_FILE_H__

#include <botan/base.h>
#include <vector>
#include <string>

namespace Botan {

/*************************************************
* File Based Entropy Source                      *
*************************************************/
class File_EntropySource : public EntropySource
   {
   public:
      u32bit slow_poll(byte[], u32bit);
      void add_source(const std::string&);
      File_EntropySource(bool = true, const std::string& = "");
   private:
      std::vector<std::string> sources;
   };

}

#endif
