/*************************************************
* HAVAL Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_HAVAL_H__
#define BOTAN_HAVAL_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* HAVAL Base Class                               *
*************************************************/
class HAVAL : public MDx_HashFunction
   {
   public:
      static const u32bit VERSION = 1, PASS = 5;
      void clear() throw();
      std::string name() const;
      HashFunction* clone() const { return new HAVAL(OUTPUT_LENGTH); }
      HAVAL(u32bit);
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      void tailor_digest(u32bit);
      static void H1(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H2(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H3(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H4(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      static void H5(u32bit&, u32bit, u32bit, u32bit, u32bit,
                     u32bit,  u32bit, u32bit, u32bit, u32bit);
      SecureBuffer<u32bit, 32> M;
      SecureBuffer<u32bit, 8> digest;
   };

}

#endif

