/*************************************************
* MD2 Header File                                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MD2_H__
#define BOTAN_MD2_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* MD2                                            *
*************************************************/
class MD2 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "MD2"; }
      HashFunction* clone() const { return new MD2; }
      MD2() : MDx_HashFunction(16, 16) { position = 0; }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static const byte SBOX[256];
      SecureBuffer<byte, 48> X;
      SecureBuffer<byte, 16> checksum;
   };

}

#endif
