/*************************************************
* Cipher Mode Base Header File                   *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MODEBASE_H__
#define BOTAN_MODEBASE_H__

#include <botan/key_filt.h>

namespace Botan {

/*************************************************
* Block Cipher Mode Base Class                   *
*************************************************/
class BlockCipherMode : public Keyed_Filter
   {
   public:
      std::string name() const;
      void reset_key(const SymmetricKey&);
      void reset_iv(const BlockCipherModeIV&);

      BlockCipherMode(const std::string&, const std::string&,
                      const SymmetricKey&, const BlockCipherModeIV&,
                      u32bit = 1);
      virtual ~BlockCipherMode() { delete cipher; }
   protected:
      virtual bool valid_iv_length(u32bit) const;
      const u32bit BLOCK_SIZE, BUFFER_SIZE;
      const std::string mode_name;
      BlockCipher* cipher;
      SecureVector<byte> buffer, state;
      u32bit position;
   };

}

#endif
