/*************************************************
* Number Theory Header File                      *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_NUMBTHRY_H__
#define BOTAN_NUMBTHRY_H__

#include <botan/bigint.h>
#include <botan/reducer.h>

namespace Botan {

/*************************************************
* Fused Arithmetic Operations                    *
*************************************************/
BigInt mul_add(const BigInt&, const BigInt&, const BigInt&);
BigInt sub_mul(const BigInt&, const BigInt&, const BigInt&);

/*************************************************
* Number Theory Functions                        *
*************************************************/
inline BigInt abs(const BigInt& n) { return n.abs(); }

BigInt gcd(const BigInt&, const BigInt&);
BigInt lcm(const BigInt&, const BigInt&);

BigInt square(const BigInt&);
BigInt inverse_mod(const BigInt&, const BigInt&);
s32bit jacobi(const BigInt&, const BigInt&);

BigInt power(const BigInt&, u32bit);
BigInt power_mod(const BigInt&, const BigInt&, const BigInt&);
BigInt power_mod(const BigInt&, const BigInt&, ModularReducer*);

void divide(const BigInt&, const BigInt&, BigInt&, BigInt&);
void positive_divide(const BigInt&, const BigInt&, BigInt&, BigInt&);
void modifying_divide(BigInt&, BigInt&, BigInt&);

/*************************************************
* Primality Testing                              *
*************************************************/
bool is_prime(const BigInt&);
bool verify_prime(const BigInt&);

s32bit simple_primality_tests(const BigInt&);
bool passes_mr_tests(const BigInt&, bool = false);

/*************************************************
* Random Number Generation                       *
*************************************************/
BigInt random_integer(u32bit);
BigInt random_integer(const BigInt&, const BigInt&);
BigInt random_prime(u32bit, const BigInt& = BigInt::one());
BigInt random_safe_prime(u32bit);

SecureVector<byte> generate_dsa_primes(BigInt&, BigInt&, u32bit);
bool generate_dsa_primes(BigInt&, BigInt&, const byte[], u32bit, u32bit,
                         u32bit = 0);

/*************************************************
* Various Utility Functions                      *
*************************************************/
u32bit low_zero_bits(const BigInt&);

}

#endif
