/*************************************************
* OpenPGP S2K Header File                        *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_OPENPGP_S2K_H__
#define BOTAN_OPENPGP_S2K_H__

#include <botan/s2k.h>

namespace Botan {

/*************************************************
* OpenPGP S2K                                    *
*************************************************/
class OpenPGP_S2K : public S2K
   {
   public:
      SymmetricKey derive_key(const std::string&, u32bit) const;

      OpenPGP_S2K(const std::string&, u32bit = 0, u32bit = 0);
      ~OpenPGP_S2K() { delete hash; }
   private:
      HashFunction* hash;
   };

}

#endif
