/*************************************************
* RIPEMD-160 Header File                         *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_RIPEMD_160_H__
#define BOTAN_RIPEMD_160_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* RIPEMD-160                                     *
*************************************************/
class RIPEMD_160 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "RIPEMD-160"; }
      HashFunction* clone() const { return new RIPEMD_160; }
      RIPEMD_160() : MDx_HashFunction(20, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F2(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F3(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F4(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      static void F5(u32bit&, u32bit, u32bit&, u32bit,
                     u32bit, u32bit, byte, u32bit);
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 5> digest;
   };

}

#endif
