/*************************************************
* Rabin-Williams Header File                     *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_RW_H__
#define BOTAN_RW_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>

namespace Botan {

/*************************************************
* Rabin-Williams Public Key                      *
*************************************************/
class RW_PublicKey : public PK_Verifying_with_MR_Key
   {
   public:
      SecureVector<byte> verify(const byte[], u32bit) const;

      u32bit max_input_bits() const { return (n.bits() - 1); }

      const BigInt& get_n() const { return n; }
      const BigInt& get_e() const { return e; }

      RW_PublicKey(const BigInt&, const BigInt&);
   protected:
      RW_PublicKey() { }
      BigInt public_op(const BigInt&) const;
      BigInt n, e;
      FixedExponent_Exp powermod_e_n;
   };

/*************************************************
* Rabin-Williams Private Key                     *
*************************************************/
class RW_PrivateKey : public RW_PublicKey, public PK_Signing_Key
   {
   public:
      SecureVector<byte> sign(const byte[], u32bit) const;

      bool check_params() const;
      const BigInt& get_p() const { return p; }
      const BigInt& get_q() const { return q; }
      const BigInt& get_d() const { return d; }

      RW_PrivateKey(const BigInt&, const BigInt&, const BigInt&,
                    const BigInt& = 0, const BigInt& = 0);
      RW_PrivateKey(u32bit, const BigInt& = 2);
   private:
      BigInt private_op(const BigInt&) const;
      BigInt if_key_private_op(const BigInt&) const;
      void precompute();
      BigInt d, p, q, d1, d2, c;
      FixedExponent_Exp powermod_d1_p, powermod_d2_q;
   };

}

#endif
