/*************************************************
* SHA1 Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SHA1_H__
#define BOTAN_SHA1_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* SHA-1                                          *
*************************************************/
class SHA1 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "SHA-1"; }
      HashFunction* clone() const { return new SHA1; }
      SHA1() : MDx_HashFunction(20, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void F1(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F2(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F3(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      static void F4(u32bit, u32bit&, u32bit, u32bit, u32bit&, u32bit);
      SecureBuffer<u32bit, 80> W;
      SecureBuffer<u32bit, 5> digest;
      friend class Gamma;
   };

}

#endif
