/*************************************************
* SHARK Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_SHARK_H__
#define BOTAN_SHARK_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* SHARK                                          *
*************************************************/
class SHARK : public BlockCipher
   {
   public:
      void clear() throw() { EK.clear(); DK.clear(); }
      std::string name() const { return "SHARK"; }
      BlockCipher* clone() const { return new SHARK; }
      SHARK() : BlockCipher(8, 1, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static u64bit transform(u64bit);
      static byte mul(byte, byte);
      static const byte SE[256], SD[256], Log[256], ALog[255];
      static const u64bit TE0[256], TE1[256], TE2[256], TE3[256],
                          TE4[256], TE5[256], TE6[256], TE7[256],
                          TD0[256], TD1[256], TD2[256], TD3[256],
                          TD4[256], TD5[256], TD6[256], TD7[256];
      SecureBuffer<u64bit, 7> EK, DK;
   };

}

#endif
