/*************************************************
* XTEA Header File                               *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_XTEA_H__
#define BOTAN_XTEA_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* XTEA                                           *
*************************************************/
class XTEA : public BlockCipher
   {
   public:
      void clear() throw() { EK.clear(); }
      std::string name() const { return "XTEA"; }
      BlockCipher* clone() const { return new XTEA; }
      XTEA() : BlockCipher(8, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static const u32bit ROUNDS = 32;
      static const u32bit DELTAS[2*ROUNDS];
      static const byte KEY_INDEX[2*ROUNDS];
      SecureBuffer<u32bit, 2*ROUNDS> EK;
   };

}

#endif
