/*************************************************
* CS-Cipher Header File                          *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_CS_CIPHER_H__
#define BOTAN_CS_CIPHER_H__

#include <botan/base.h>

namespace Botan {

/*************************************************
* CS-Cipher                                      *
*************************************************/
class CS_Cipher : public BlockCipher
   {
   public:
      void clear() throw() { EK.clear(); }
      std::string name() const { return "CS-Cipher"; }
      BlockCipher* clone() const { return new CS_Cipher; }
      CS_Cipher() : BlockCipher(8, 16) {}
   private:
      void enc(const byte[], byte[]) const;
      void dec(const byte[], byte[]) const;
      void key(const byte[], u32bit);
      static const byte P[256], TE1[256], TD1[256], TD2[256], ROT[256];
      SecureBuffer<byte, 200> EK;
   };

}

#endif
