/*************************************************
* Default Allocator Header File                  *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_DEF_ALLOC_H__
#define BOTAN_DEF_ALLOC_H__

#include <botan/manalloc.h>

namespace Botan {

/*************************************************
* Default Allocator                              *
*************************************************/
class Default_Allocator : public ManagedAllocator
   {
   public:
      SecureAllocator* clone() { return this; }

      Default_Allocator();
      ~Default_Allocator();
   private:
      static const u32bit PREF_SIZE = 64*1024, CACHE_SIZE = 4;
      void* alloc_block(u32bit) const;
      void dealloc_block(void*, u32bit) const;
      mutable void* cache[CACHE_SIZE];
   };

}

#endif
