/*************************************************
* Discrete Logarithm Group Header File           *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_DL_PARM_H__
#define BOTAN_DL_PARM_H__

#include <botan/bigint.h>

namespace Botan {

/*************************************************
* Discrete Logarithm Group                       *
*************************************************/
class DL_Group
   {
   public:
      const BigInt& get_p() const;
      const BigInt& get_q() const;
      const BigInt& get_g() const;

      enum GroupType { DH_Group, DSA_Group };
      enum PrimeType { Strong, Prime_Subgroup, DSA_Kosherizer };

      GroupType type() const;
      bool prime_is_safe() const;
      bool verify() const;

      DL_Group(u32bit, PrimeType = Strong);
      DL_Group(const SecureVector<byte>&, u32bit = 1024, u32bit = 0);
      DL_Group(const BigInt&, const BigInt&);
      DL_Group(const BigInt&, const BigInt&, const BigInt&);
   private:
      BigInt p, q, g;
      GroupType group_type;
   };

/*************************************************
* Retrieve a DL group by name                    *
*************************************************/
const DL_Group& get_dl_group(const std::string&);

/*************************************************
* Register a named DL group                      *
*************************************************/
void add_dl_group(const std::string&, const DL_Group&);

}

#endif
