/*************************************************
* ElGamal Header File                            *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_ELGAMAL_H__
#define BOTAN_ELGAMAL_H__

#include <botan/bigint.h>
#include <botan/pk_keys.h>
#include <botan/mod_exp.h>
#include <botan/dl_parm.h>

namespace Botan {

/*************************************************
* ElGamal Public Key                             *
*************************************************/
class ElGamal_PublicKey : public PK_Encrypting_Key
   {
   public:
      SecureVector<byte> encrypt(const byte[], u32bit) const;

      u32bit max_input_bits() const { return (p.bits()-1); }

      bool check_params() const;
      BigInt get_p() const { return p; }
      BigInt get_g() const { return g; }
      BigInt get_y() const { return y; }

      ElGamal_PublicKey(const DL_Group&, const BigInt&);
      ElGamal_PublicKey(const ElGamal_PublicKey&);
   protected:
      DL_Group group;
      const BigInt &p, &g;
      BigInt y;
      FixedBase_Exp powermod_g_p, powermod_y_p;
   };

/*************************************************
* ElGamal Private Key                            *
*************************************************/
class ElGamal_PrivateKey : public ElGamal_PublicKey, public PK_Decrypting_Key
   {
   public:
      SecureVector<byte> decrypt(const byte[], u32bit) const;

      bool check_params() const;
      BigInt get_x() const { return x; }

      ElGamal_PrivateKey(const DL_Group&);
      ElGamal_PrivateKey(const DL_Group&, const BigInt&, const BigInt&);
   private:
      BigInt x;
   };

}

#endif
