/*************************************************
* PKCS1 EME Header File                          *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EME_PKCS_H__
#define BOTAN_EME_PKCS_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* EME_PKCS1v15                                   *
*************************************************/
class EME_PKCS1v15 : public EME
   {
   public:
      u32bit maximum_input_size(u32bit) const;
   private:
      SecureVector<byte> pad(const byte[], u32bit, u32bit) const;
      SecureVector<byte> unpad(const byte[], u32bit, u32bit) const;
   };

}

#endif
