/*************************************************
* EMSA4 Header File                              *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_EMSA4_H__
#define BOTAN_EMSA4_H__

#include <botan/pk_misc.h>

namespace Botan {

/*************************************************
* EMSA4                                          *
*************************************************/
class EMSA4 : public EMSA
   {
   public:
      EMSA4(const std::string&, const std::string&);
      EMSA4(const std::string&, const std::string&, u32bit);
      ~EMSA4() { delete mgf; delete hash; }
   private:
      void update(const byte[], u32bit);
      SecureVector<byte> encoding_of(const SecureVector<byte>&, u32bit);
      SecureVector<byte> raw_data();
      bool verify(const SecureVector<byte>&, const SecureVector<byte>&,
                  u32bit) throw();
      const u32bit SALT_SIZE;
      HashFunction* hash;
      const MGF* mgf;
   };

}

#endif
