/*************************************************
* MD4 Header File                                *
* (C) 1999-2002 The Botan Project                *
*************************************************/

#ifndef BOTAN_MD4_H__
#define BOTAN_MD4_H__

#include <botan/mdx_hash.h>

namespace Botan {

/*************************************************
* MD4                                            *
*************************************************/
class MD4 : public MDx_HashFunction
   {
   public:
      void clear() throw();
      std::string name() const { return "MD4"; }
      HashFunction* clone() const { return new MD4; }
      MD4() : MDx_HashFunction(16, 64) { clear(); }
   private:
      void final_result(byte[]);
      void hash(const byte[]);
      static void FF(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      static void GG(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      static void HH(u32bit&, u32bit, u32bit, u32bit, u32bit, byte);
      SecureBuffer<u32bit, 16> M;
      SecureBuffer<u32bit, 4> digest;
   };

}

#endif
